DROP TABLE CONFIGURATION

CREATE TABLE CONFIGURATION
	(CATEGORY VARCHAR(255) NOT NULL,
	NAME VARCHAR(255) NOT NULL,
	VALUE TEXT NOT NULL)
	
DROP TABLE PREFERENCES

CREATE TABLE GLOBAL_SCRIPT_TEMP
	(ID VARCHAR(255) NOT NULL PRIMARY KEY,
	SCRIPT TEXT)

INSERT INTO GLOBAL_SCRIPT_TEMP VALUES (ID, SCRIPT) (SELECT ID, SCRIPT FROM SCRIPT WHERE ID = 'Deploy' OR ID = 'Shutdown' OR ID = 'Preprocessor' OR ID = 'Postprocessor')

DROP TABLE SCRIPT

CREATE TABLE SCRIPT
	(GROUP_ID VARCHAR(36) NOT NULL,
	ID VARCHAR(36) NOT NULL,
	SCRIPT TEXT,
	PRIMARY KEY(GROUP_ID, ID))

INSERT INTO SCRIPT VALUES (GROUP_ID, ID, SCRIPT) (SELECT 'GLOBAL', ID, SCRIPT FROM GLOBAL_SCRIPT_TEMP)

DROP TABLE GLOBAL_SCRIPT_TEMP

DELETE FROM TEMPLATE

ALTER TABLE TEMPLATE ADD GROUP_ID VARCHAR(255) NOT NULL

ALTER TABLE TEMPLATE ADD CONSTRAINT GROUP_ID_PK PRIMARY KEY (GROUP_ID, ID)

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'update.url', 'http://updates.mirthcorp.com')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'update.enabled', '1')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'stats.enabled', '1')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'firstlogin', '1')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'server.resetglobalvariables', '1')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'smtp.auth', '0')

INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES ('core', 'smtp.secure', '0')