/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.connectors.js;

import java.util.List;
import java.util.Properties;
import java.util.UUID;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JavaScriptTokenMarker;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.connectors.ConnectorClass;
import com.mirth.connect.model.DriverInfo;

/**
 * A form that extends from ConnectorClass. All methods implemented are
 * described in ConnectorClass.
 */
public class JavaScriptWriter extends ConnectorClass {

    private static SyntaxDocument jsMappingDoc;
    private List<DriverInfo> drivers;

    public JavaScriptWriter() {
        name = JavaScriptWriterProperties.name;

        initComponents();

        jsMappingDoc = new SyntaxDocument();
        jsMappingDoc.setTokenMarker(new JavaScriptTokenMarker());

        javaScriptTextPane.setDocument(jsMappingDoc);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put(JavaScriptWriterProperties.DATATYPE, name);
        properties.put(JavaScriptWriterProperties.JAVASCRIPT_HOST, "sink");
        properties.put(JavaScriptWriterProperties.JAVASCRIPT_SCRIPT, javaScriptTextPane.getText());

        return properties;
    }

    public void setProperties(Properties props) {
        resetInvalidProperties();
        javaScriptTextPane.setText((String) props.get(JavaScriptWriterProperties.JAVASCRIPT_SCRIPT));

    }

    public Properties getDefaults() {
        return new JavaScriptWriterProperties().getDefaults();
    }

    public boolean checkProperties(Properties props, boolean highlight) {
        resetInvalidProperties();
        boolean valid = true;

        if (((String) props.get(JavaScriptWriterProperties.JAVASCRIPT_SCRIPT)).length() == 0) {
            valid = false;
            if (highlight) {
                javaScriptTextPane.setBackground(UIConstants.INVALID_COLOR);
            }
        }

        return valid;
    }

    public String[] getDragAndDropCharacters(Properties props) {
        return new String[]{"$('", "')"};
    }

    private void resetInvalidProperties() {
        javaScriptTextPane.setBackground(null);
    }

    public String doValidate(Properties props, boolean highlight) {
        String error = null;

        if (!checkProperties(props, highlight)) {
            error = "Error in the form for connector \"" + getName() + "\".\n\n";
        }

        String script = ((String) props.get(JavaScriptWriterProperties.JAVASCRIPT_SCRIPT));

        if (script.length() != 0) {
            Context context = Context.enter();
            try {
                context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
            } catch (EvaluatorException e) {
                if (error == null) {
                    error = "";
                }
                error += "Error in connector \"" + getName() + "\" at Javascript:\nError on line " + e.lineNumber() + ": " + e.getMessage() + ".\n\n";
            } catch (Exception e) {
                if (error == null) {
                    error = "";
                }
                error += "Error in connector \"" + getName() + "\" at Javascript:\nUnknown error occurred during validation.";
            }

            Context.exit();
        }

        return error;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jsLabel = new javax.swing.JLabel();
        javaScriptTextPane = new com.mirth.connect.client.ui.components.MirthSyntaxTextArea(true,false);

        setBackground(new java.awt.Color(255, 255, 255));
        setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));

        jsLabel.setText("JavaScript:");

        javaScriptTextPane.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(javaScriptTextPane, javax.swing.GroupLayout.DEFAULT_SIZE, 327, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(javaScriptTextPane, javax.swing.GroupLayout.DEFAULT_SIZE, 259, Short.MAX_VALUE)
                    .addComponent(jsLabel))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private com.mirth.connect.client.ui.components.MirthSyntaxTextArea javaScriptTextPane;
    private javax.swing.JLabel jsLabel;
    // End of variables declaration//GEN-END:variables
}
