/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.connectors;

import java.util.ArrayList;
import java.util.Properties;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.CodeTemplate;

/**
 * Used to extend from for all of the Connectors. Each method is re-implemented
 * in each Connector.
 */
public class ConnectorClass extends javax.swing.JPanel {

    public String name;
    public Frame parent;
    public final String RESULT_PATTERN = "responseMap.put\\(['|\"]([^'|^\"]*)[\"|']";

    /** Creates new form ConnectorClass */
    public ConnectorClass() {
        this.parent = PlatformUI.MIRTH_FRAME;
        initComponents();
    }

    /** Gets the name of the connector */
    public String getName() {
        return name;
    }

    public ArrayList<CodeTemplate> getReferenceItems() {
        return new ArrayList<CodeTemplate>();
    }

    /**
     * Gets a properties object with all of the current data in the connector's
     * form.
     */
    public Properties getProperties() {
        return new Properties();
    }

    /**
     * Sets all of the current data in the connector's form to the data in the
     * properties object parameter
     */
    public void setProperties(Properties props) {
    }

    /**
     * Gets a properties object with all of the default settings for that form
     * as the data.
     */
    public Properties getDefaults() {
        return new Properties();
    }

    /**
     * Checks to see if the properties in the connector are all valid.
     * Highlights fields that are not valid if highlight=true.
     * 
     * @param props
     * @param highlight
     * @return
     */
    public boolean checkProperties(Properties props, boolean highlight) {
        return true;
    }

    public String[] getDragAndDropCharacters(Properties props) {
        return new String[]{"${", "}"};
    }

    /**
     * Runs any custom validation that has been created on the channel.
     * Returns null if successful, and a String error message otherwise.
     * Also validates the form and highlights invalid fields if
     * highlight=true.
     * @param props
     * @return
     */
    public String doValidate(Properties props, boolean highlight) {
        return null;
    }

    public void updateResponseDropDown() {
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
