/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.client.ui.panels.reference;

import java.util.ArrayList;

import com.mirth.connect.model.CodeTemplate;

public class ReferenceListPanel extends javax.swing.JPanel {

    /**
     * Creates new form ReferenceListPanel
     */
    public ReferenceListPanel(String title, ArrayList<CodeTemplate> items) {
        initComponents();
        variableReferenceTable = new VariableReferenceTable(title, items);
        variableReferenceTable.setDragEnabled(true);
        variableReferenceTable.setTransferHandler(new ReferenceListHandler(items));
        variableReferenceScrollPane.setViewportView(variableReferenceTable);
    }

    /**
     * Refreshes the reference table items based on the find string parameter
     * 
     * @param filterString The search expression
     */
    public void refreshTableList(final String filterString) {
    	variableReferenceTable.performFilter(filterString);      
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        variableReferenceScrollPane = new javax.swing.JScrollPane();
        variableReferenceTable = new com.mirth.connect.client.ui.panels.reference.VariableReferenceTable();

        setBackground(new java.awt.Color(255, 255, 255));

        variableReferenceScrollPane.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        variableReferenceScrollPane.setMinimumSize(new java.awt.Dimension(0, 0));
        variableReferenceScrollPane.setViewportView(variableReferenceTable);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(variableReferenceScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 12, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(variableReferenceScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 12, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane variableReferenceScrollPane;
    private com.mirth.connect.client.ui.panels.reference.VariableReferenceTable variableReferenceTable;
    // End of variables declaration//GEN-END:variables
}
