/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.client.ui.editors;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

import com.mirth.connect.client.ui.BeanBinder;
import com.mirth.connect.client.ui.PlatformUI;

public class BoundPropertiesSheetDialog extends javax.swing.JDialog {

    Object bean;
    Properties properties;

    public BoundPropertiesSheetDialog(Properties p, Object bean) {
        this(p, bean, -1, -1);
    }

    public BoundPropertiesSheetDialog(Properties p, Object bean, int width, int height) {
        super(PlatformUI.MIRTH_FRAME);
        this.bean = bean;
        this.properties = p;
        setBeanInfo();
        initComponents();
        BeanBinder beanBinder = new BeanBinder(bean, propertySheetPanel, null);
        beanBinder.setWriteEnabled(true);

        if (width > 0 && height > 0) {
            this.setSize(width, height);
        }

        this.setLocationRelativeTo(PlatformUI.MIRTH_FRAME);
        setVisible(true);
    }

    public void setBeanInfo() {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        } catch (IntrospectionException ex) {
            ex.printStackTrace();
        }

        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (!pd.getName().equals("class")) {
                try {
                    Object value = null;
                    if (properties.get(pd.getName()) != null) {
                        value = properties.get(pd.getName());
                        if (value.equals("false") || value.equals("true")) {
                            pd.getWriteMethod().invoke(bean, new Object[]{Boolean.valueOf((String) value)});
                        } else {
                            pd.getWriteMethod().invoke(bean, new Object[]{value});
                        }
                    } else {
                        value = pd.getReadMethod().invoke(bean, new Object[]{});
                        pd.getWriteMethod().invoke(bean, new Object[]{value});
                    }
                } catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                } catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                } catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void getBeanInfo() {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        } catch (IntrospectionException ex) {
            ex.printStackTrace();
        }

        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (!pd.getName().equals("class")) {
                try {
                    properties.put(pd.getName(), String.valueOf(pd.getReadMethod().invoke(bean, new Object[]{})));
                } catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                } catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                } catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc=" Generated Code
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        propertySheetPanel = new com.l2fprod.common.propertysheet.PropertySheetPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Properties");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
        });

        propertySheetPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        propertySheetPanel.setAutoscrolls(true);
        propertySheetPanel.setDescriptionVisible(true);
        propertySheetPanel.setToolBarVisible(true);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(propertySheetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 273, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(propertySheetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 283, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowClosed(java.awt.event.WindowEvent evt)// GEN-FIRST:event_formWindowClosed
    {// GEN-HEADEREND:event_formWindowClosed
        getBeanInfo();
    }// GEN-LAST:event_formWindowClosed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.l2fprod.common.propertysheet.PropertySheetPanel propertySheetPanel;
    // End of variables declaration//GEN-END:variables
}
