/*
 * Copyright (c) Mirth Corporation. All rights reserved.
 * http://www.mirthcorp.com
 *
 * The software in this package is published under the terms of the MPL
 * license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */

package com.mirth.connect.client.ui.browsers.event;

import com.mirth.connect.client.ui.UIConstants;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.mirth.connect.model.Event;

public class EventBrowserAdvancedFilter extends javax.swing.JDialog {

    private Integer user = -1;
    private String outcome = UIConstants.ALL_OPTION;
    private String ipAddress = "";
    private Map<Integer, String> userMapById;
    private Map<String, Integer> userMapByName;

    public EventBrowserAdvancedFilter(com.mirth.connect.client.ui.Frame parent, String title, boolean modal, Map<Integer, String> userMap) {
        super(parent, title, modal);

        initComponents();
        getContentPane().setBackground(new java.awt.Color(255, 255, 255));

        pack();
        Dimension dlgSize = getPreferredSize();
        Dimension frmSize = parent.getSize();
        Point loc = parent.getLocation();

        if ((frmSize.width == 0 && frmSize.height == 0) || (loc.x == 0 && loc.y == 0)) {
            setLocationRelativeTo(null);
        } else {
            setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }

        setResizable(false);

        // Cache the user map by both names and ids for easy lookup
        // The first items in the map are [-1, ALL] and [0, System]
        userMapById = userMap;
        userMapByName = new LinkedHashMap<String, Integer>();

        for (Entry<Integer, String> entry : userMapById.entrySet()) {
            userMapByName.put(entry.getValue(), entry.getKey());
        }

        userComboBox.setModel(new javax.swing.DefaultComboBoxModel(userMapById.values().toArray()));

        String[] outcomeValues = new String[Event.Outcome.values().length + 1];
        outcomeValues[0] = UIConstants.ALL_OPTION;
        for (int i = 1; i < outcomeValues.length; i++) {
            outcomeValues[i] = Event.Outcome.values()[i - 1].toString();
        }

        outcomeComboBox.setModel(new javax.swing.DefaultComboBoxModel(outcomeValues));

        reset();
    }

    public void reset() {
        user = -1;
        outcome = UIConstants.ALL_OPTION;
        ipAddress = "";

        userComboBox.setSelectedIndex(0);
        outcomeComboBox.setSelectedIndex(0);
        ipAddressField.setText(ipAddress);
    }

    public void setFieldValues(Integer user, String outcome, String ipAddress) {
        this.user = user;
        this.outcome = outcome;
        this.ipAddress = ipAddress;

        userComboBox.setSelectedItem(userMapById.get(user));
        outcomeComboBox.setSelectedItem(outcome);
        ipAddressField.setText(this.ipAddress);
    }

    public Integer getUser() {
        return user;
    }

    public String getOutcome() {
        return outcome;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        userLabel = new javax.swing.JLabel();
        userComboBox = new javax.swing.JComboBox();
        advancedSearchOKButton = new javax.swing.JButton();
        advancedSearchCancelButton = new javax.swing.JButton();
        ipAddressField = new com.mirth.connect.client.ui.components.MirthTextField();
        ipAddressLabel = new javax.swing.JLabel();
        outcomeLabel = new javax.swing.JLabel();
        outcomeComboBox = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        userLabel.setText("User:");

        advancedSearchOKButton.setText("OK");
        advancedSearchOKButton.setMaximumSize(new java.awt.Dimension(65, 23));
        advancedSearchOKButton.setMinimumSize(new java.awt.Dimension(65, 23));
        advancedSearchOKButton.setPreferredSize(new java.awt.Dimension(65, 23));
        advancedSearchOKButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                advancedSearchOKButtonActionPerformed(evt);
            }
        });

        advancedSearchCancelButton.setText("Cancel");
        advancedSearchCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                advancedSearchCancelButtonActionPerformed(evt);
            }
        });

        ipAddressLabel.setText("IP Address:");

        outcomeLabel.setText("Outcome:");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(outcomeLabel)
                    .addComponent(userLabel)
                    .addComponent(ipAddressLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(outcomeComboBox, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(userComboBox, 0, 125, Short.MAX_VALUE)
                    .addComponent(ipAddressField, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(146, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(210, Short.MAX_VALUE)
                .addComponent(advancedSearchOKButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(advancedSearchCancelButton)
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {advancedSearchCancelButton, advancedSearchOKButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(userLabel)
                    .addComponent(userComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(outcomeLabel)
                    .addComponent(outcomeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(ipAddressField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(ipAddressLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(advancedSearchCancelButton)
                    .addComponent(advancedSearchOKButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {advancedSearchCancelButton, advancedSearchOKButton});

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void advancedSearchOKButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_advancedSearchOKButtonActionPerformed
        // "OK" button clicked.  save settings, and exit.
        user = userMapByName.get((String) userComboBox.getSelectedItem());
        outcome = (String) outcomeComboBox.getSelectedItem();
        ipAddress = ipAddressField.getText();

        setVisible(false);
    }//GEN-LAST:event_advancedSearchOKButtonActionPerformed

    private void advancedSearchCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_advancedSearchCancelButtonActionPerformed
        // "Cancel" button clicked.  Just exit.
        setVisible(false);
    }//GEN-LAST:event_advancedSearchCancelButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton advancedSearchCancelButton;
    private javax.swing.JButton advancedSearchOKButton;
    private com.mirth.connect.client.ui.components.MirthTextField ipAddressField;
    private javax.swing.JLabel ipAddressLabel;
    private javax.swing.JComboBox outcomeComboBox;
    private javax.swing.JLabel outcomeLabel;
    private javax.swing.JComboBox userComboBox;
    private javax.swing.JLabel userLabel;
    // End of variables declaration//GEN-END:variables
}
