/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 *  Appointments Widget
 *
 * @param {} config
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg desktop
 *    Reference to application desktop object
 */
Ext.hui.widget.provider.References = function(config)
{
    Ext.hui.widget.provider.References.superclass.constructor.call(this, config);
}

Ext.extend(Ext.hui.widget.provider.References, Ext.hui.widget.Widget,
{
    title: "References",
    height:200,
    tools:[
        {
			id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
                    Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
        {
            id:'refresh',
            qtip: 'Refresh',
            handler: function(event, toolEl, panel){
                panel.dataStore.reload();
            }
        },
        {
            id:'close',
            qtip: 'Close Widget',
            handler: function(event, toolEl, panel){
                panel.destroy();
                Ext.hui.session.saveConfig();
            }
        }
    ],
    listeners: {
        /*afterrender:function()
        {
            var showMoreConsults = function()
            {
                this.desktop.createWindow({
                    patientToken:this.patientToken,
                    desktop:this.desktop,
                    startDate:this.startDate,
                    endDate:this.endDate,
                    cls: 'x-portlet'
                }, Ext.hui.desktopwindow.patient.Consults).show();
            }

            Ext.EventManager.addListener(String.format('consults-more-{0}', this.id), 'click', showMoreConsults, this);
        }      */
    },

    initComponent: function() {
        //Ext.hui.session.prov_ref = Ext.hui.session.getCookie('prov_ref');

        var genData = function(){
            if (!Ext.hui.session.prov_ref){
                Ext.hui.session.prov_ref = [
                    {linkDesc:'CDC',linkUrl:'http://www.cdc.gov/'},
                    {linkDesc:'FDA',linkUrl:'http://www.fda.gov'},
                    {linkDesc:'Medscape',linkUrl:'http://emedicine.medscape.com'},
                    {linkDesc:'webMD.com',linkUrl:'http://www.webmd.com'},
                    {linkDesc:'DermAtlas',linkUrl:'http://dermatlas.med.jhmi.edu/derm/'}
                ];
                //Ext.hui.session.setCookie('prov_ref',Ext.hui.session.prov_ref);
            }
            return Ext.hui.session.prov_ref;
        }

        var Reference = Ext.data.Record.create([{
            name: 'linkDesc',
            type: 'string'
        }, {
            name: 'linkUrl',
            type: 'string'
        }]);

        var store  = new Ext.data.GroupingStore({
            reader: new Ext.data.JsonReader({fields: Reference}),
            data: genData(),
            sortInfo: {field: 'linkDesc', direction: 'ASC'}
        });

        var gridPanel = new Ext.grid.EditorGridPanel({
            store: store
            ,columns:[
                {
                    header: "Link",
                    width: 55,
                    sortable: true,
                    dataIndex: 'linkDesc',
                    renderer:function(value, p, record){
                        return String.format(
                            '<b><a id="{1}" class="referenceLink" href="{1}" target="_blank" title="{1}">{0}</a></b>',
                            value, record.data.linkUrl);
                    }
                }
            ]
            ,selModel: new Ext.grid.CellSelectionModel()
            ,viewConfig:{forceFit:true}
            ,stripeRows: true,
            autoExpandColumn:'linkDesc',
            border:true,
            bodyBorder:true,
            //selModel: new Ext.grid.RowSelectionModel(selModel),
            columnLines:true,
            loadMask:true,
            layout:'fit',
            region: 'center',
            clicksToEdit: 2,
            bbar: [
                {text: 'Add',
                handler : function(){
                        var getLink = function(btn, text){
                            if(btn=='ok'){
                                var inputs = text.split('\r\n');
                                if (inputs.length == 2){
                                    if (inputs[1].indexOf('http')==0 && inputs[1] !='http://your.url'){
                                        var lnk = new Link({
                                            linkDesc: inputs[0],
                                            linkUrl: inputs[1]
                                        });
                                        store.insert(0, lnk);
                                        Ext.hui.session.prov_ref = Ext.hui.common.dataToJSON(store);
                                        //Ext.hui.session.setCookie('prov_ref',Ext.hui.common.dataToJSON(store));
                                        Ext.hui.session.saveUIConfig();
                                    } else {
                                        Ext.Msg.alert('Invalid Input', 'Invalid URL ("http://") detected on the second line');
                                    }
                                }
                            }
                        }
                        // access the Record constructor through the grid's store
                        var Link = gridPanel.getStore().recordType;

                        Ext.Msg.show({
                           title: 'New Reference Link',
                           msg: 'Please enter a description with a URL on the 2nd line:',
                           width: 300,
                           buttons: Ext.MessageBox.OKCANCEL,
                           multiline: true,
                           value:'Link Description\r\nhttp://your.url',
                           fn: getLink
                        });
                    }
                },
                {text: 'Remove',
                handler : function(){
                        // access the Record constructor through the grid's store
                       // var s = gridPanel.getSelectionModel().getSelectedItems();
                        if (gridPanel.getSelectionModel().hasSelection()){
                            var cell = gridPanel.getSelectionModel().getSelectedCell();
                            var record = gridPanel.getStore().getAt(cell[0]);
                            gridPanel.getStore().remove(record);
                            Ext.hui.session.prov_ref = Ext.hui.common.dataToJSON(store);
                            //Ext.hui.session.setCookie('prov_ref',Ext.hui.common.dataToJSON(store));
                            Ext.hui.session.saveUIConfig();
                        }
                    }
                }
            ],
            viewConfig: {
                emptyText:"No results",
                forceFit:true
            }
        });

        this.items = [gridPanel];

        Ext.hui.widget.provider.References.superclass.initComponent.call(this);
    }
});

Ext.reg('prov_references_widget', Ext.hui.widget.provider.References);