/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Provider OrdersResulted Widget
 *
 * @param {} config
 *
 * @cfg provToken
 *     Provider's security token
 * @cfg desktop
 *    Reference to application desktop object
 */
Ext.hui.widget.provider.OrdersResulted = function(config)
{
    var today =new Date();
    var ONE_DAY = 24*60*60*1000;

//    if(!config.endDay){
        this.endDate = today;
//    } else {
//        this.endDate = new Date((today.getTime() + config.endDay*ONE_DAY));
//    }
//    if(!config.startDay){
        this.startDate = new Date((today.getTime() - 14*ONE_DAY));
//    } else {
//        this.startDate = new Date((today.getTime() + config.startDay*ONE_DAY));
//    }

    if(Ext.hui.app.EXTEND_YEAR=="true"){
            this.startDate.setYear(Ext.hui.app.EXTEND_YEAR_DATE);
        }

    Ext.hui.widget.provider.OrdersResulted.superclass.constructor.call(this, config);
}

Ext.extend(Ext.hui.widget.provider.OrdersResulted, Ext.hui.widget.Widget,
{
	title: "Orders Resulted",
	height:200,
    layout:'border',
    tools:[
		{
			id: 'filter',
			qtip: 'Configure Filter',
            cls: 'x-tool-filter',
            overCls:'x-tool-filter-over',
			handler: function (event,toolEl, panel){
				if (panel.dateFilter) {
                    panel.dateFilter.toggleView();
				}
			}
		},
        {
			id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
                    Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
		{
		    id:'refresh',
		    qtip: 'Refresh',
		    handler: function(event, toolEl, panel){
		        panel.dataStore.reload();
		    }
		},
		{
			id:'close',
		    qtip: 'Close Widget',
		    handler: function(event, toolEl, panel){
                panel.destroy();
                Ext.hui.session.saveConfig();
		    }
		}
	],
	initComponent: function() {
        this.dataStore = new Ext.data.Store({
			restful:true,
			proxy: new Ext.data.HttpProxy({
						url: 'rest/providerOrdersResulted.json',
						disableCaching:true,
                        timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
						method:'GET'
	    			}),
            baseParams:
            {
                startDate:Ext.util.Format.dateRenderer("m/d/y")(this.startDate),
                endDate:Ext.util.Format.dateRenderer("m/d/y")(this.endDate)
            },
	        reader: this.createJsonReader(),

	        sortInfo: {
			    field: 'orderDate',
			    direction: 'DESC'
			},
			listeners:
			{
				exception:{scope:this, fn:function(dataProxy, type, action, options, response, arg){
                    Ext.hui.common.handleNetworkFailure(response.status, this);

                }},
				beforeLoad:
                {
                    scope:this,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading = new Ext.LoadMask(this.gridArea.el, {msg:"Loading...", store:this.dataStore});
                        this.loading.show();
                        if (this.dateFilter) this.dateFilter.disable();
                    }
                },
                load:
				{
					scope:this,
					fn:
					  	function(store, records, options){
		    				if (!this || this.isDestroy) return;
                            var inMemoryStore = new Ext.data.Store({
                                proxy: new Ext.ux.data.PagingMemoryProxy(store.reader.jsonData),
                                remoteSort:true,
                                reader: this.createJsonReader(),
                                sortInfo: {
                                    field: 'orderDate',
                                    direction: 'DESC'
                                }
                            });
                            //destroy previous grid panel
                            if (this.gridPanel)
                            {
                                this.gridPanel.destroy();
                            }
                            this.gridPanel = this.createGrid(inMemoryStore, this);
                            inMemoryStore.load({params:{start:0, limit:Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE}});

                            this.gridArea.removeAll();
                            this.gridArea.add(this.gridPanel);
                            this.doLayout();

                            this.setTitle("Orders Resulted ("+records.length+")");

                            if (this.dateFilter) this.dateFilter.enable();
	    				}
    			}
			}
	    });

        this.dateFilter = new Ext.hui.filter.DateFilter({
            region:'north',
            dataStore:this.dataStore,
            startDate:this.startDate,
            endDate:this.endDate,
            disabled:true,
            hidden:true
        });

        this.gridArea = new Ext.Container({layout:'fit', region:'center', html:''});
		this.items = [this.dateFilter, this.gridArea];

		Ext.hui.widget.provider.OrdersResulted.superclass.initComponent.call(this);
	},
    createJsonReader: function()
    {
        return new Ext.data.JsonReader({
	            root: ''
	        },
			[
                {name: 'orderDate', type:'date'},
                {name: 'orderId'},
				{name: 'type'},
				{name: 'description'},
                {name: 'siteCode'},
                {name: 'providerName'},
                {name: 'status'},
                {name: 'recordDetailsToken'},
				{name: 'siteMoniker'},
                {name: 'patientName'},
                {name: 'patientToken'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
	        ]);
    },
    createGrid: function(gridDataStore, refWidget)
    {
        var dateRenderer = Ext.util.Format.dateRenderer('M d, Y H:i');

		return new Ext.grid.GridPanel({
	        store: gridDataStore,
	        columns: [
	            {
	                header   : 'Site',
	                width    : 40,
	                sortable : true,
	                dataIndex: 'siteMoniker',
	                renderer :
	                        function(value, metaData, record, rowIndex, colIndex, store) {
	                            return Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker);
	                        }
	            },
	            {
	                width    : 40,
	                header   : 'Order Date',
	                sortable : true,
	                dataIndex: 'orderDate',
	                renderer: dateRenderer
	            },
                {
	                width    : 50,
	                header   : 'Patient',
	                sortable : true,
	                dataIndex: 'patientName',
                    renderer :
	                        function(value, metaData, record, rowIndex, colIndex, store) {
	                            return String.format('<span id="patient-link-{0}-{1}" class="selectpatient" alt="Link Select Patient">'+record.data.patientName+'</span>', refWidget.id, record.id);
	                        }
	            },
                {
                    id: 'description',
	                width    : 80,
	                header   : 'Description',
	                sortable : true,
	                dataIndex: 'description',
                    renderer :{
	                        fn:function(value, metaData, record, rowIndex, colIndex, store) {
	                            if (record.data.recordDetailsToken != null)
	                            {
	                            	return String.format('<span class="record-details" id="order-details-{0}-{1}">{2}</span>', refWidget.id, record.id, record.data.description);
	                            }
	                            else return record.data.description;

	                        },
	                        scope:this
	                }
	            }

	        ],
	        listeners:{
	        	rowclick:
	        	{
	        		scope:this,
	        		fn:function(grid, rowIdx, evtObj) {
	        			var record = grid.getStore().getAt(rowIdx);
                        if(evtObj.within(String.format("patient-link-{0}-{1}", refWidget.id, record.id)))
                        {
                            Ext.hui.app.selectPatient(record.data.patientToken, record.data.patientName, refWidget.id);
                        }
                        if (Ext.get(String.format("order-details-{0}-{1}", refWidget.id, record.id))){
                            if(evtObj.within(String.format("order-details-{0}-{1}", refWidget.id, record.id)))
                            {
                                refWidget.desktop.createWindow({
                                    title:String.format("Order Details ~ {0} {1} :: {2}",
                                        Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker),
                                        record.data.registrationNum, record.data.patientName),
                                    patientToken:record.data.patientToken,
                                    desktop:refWidget.desktop,
                                    recordDetailsToken:record.data.recordDetailsToken
                                }, Ext.hui.desktopwindow.patient.OrderDetails).show();
                            }
                        }
                    }
	        	}
	        },

            selModel: new Ext.grid.CellSelectionModel(),
	        stripeRows: true,
            columnLines:true,
	        autoExpandColumn:'description',
	        border:true,
	        bodyBorder:true,
	        loadMask:true,
            layout:'fit',
            region: 'center',
            bbar: new Ext.PagingToolbar({
                pageSize: Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE,
                store: gridDataStore,
                displayInfo: true,
                items:[
                {
                    text: 'more >>',
                    cls: 'more-link',
                    listeners:
			        {
                        click: function(btn, pressed){
                            refWidget.desktop.createWindow({
                                desktop:refWidget.desktop,
                                startDate:refWidget.startDate,
                                endDate:refWidget.endDate
                            }, Ext.hui.desktopwindow.provider.OrdersResulted).show();
                        }

                    }
                }]
            }),
	        viewConfig: {
	        	emptyText:"No results",
				forceFit:true
	        }
	    });
    }
});

Ext.reg('prov_ordersresulted_widget', Ext.hui.widget.provider.OrdersResulted);