/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Labs Widget
 *
 * @param {} config
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg desktop
 *    Reference to application desktop object
 */
Ext.hui.widget.patient.Labs = function(config)
{
    var today =new Date();
    var ONE_DAY = 24*60*60*1000;

//    if(!config.endDay){
        this.endDate = today;
//    } else {
//        this.endDate = new Date((today.getTime() + config.endDay*ONE_DAY));
//    }
//    if(!config.startDay){
        this.startDate = new Date((today.getTime() - 120*ONE_DAY));
//    } else {
//        this.startDate = new Date((today.getTime() + config.startDay*ONE_DAY));
//    }
    if(Ext.hui.app.EXTEND_YEAR=="true"){
                this.startDate.setYear(Ext.hui.app.EXTEND_YEAR_DATE);
            }

    Ext.hui.widget.patient.Labs.superclass.constructor.call(this, config);
}

Ext.extend(Ext.hui.widget.patient.Labs, Ext.hui.widget.Widget,
{
    title: "Labs",
    height:200,
    layout:'border',
    tools:[
        {
			id: 'filter',
			qtip: 'Configure Filter',
            cls: 'x-tool-filter',
            overCls:'x-tool-filter-over',
			handler: function (event,toolEl, panel){
				if (panel.filter) {
                    panel.filter.toggleView();
				}
			}
		},
        {
			id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
                    Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
        {
            id:'refresh',
            qtip: 'Refresh',
            handler: function(event, toolEl, panel){
                panel.dataStore.reload();
            }
        },
        {
            id:'close',
            qtip: 'Close Widget',
            handler: function(event, toolEl, panel){
                panel.destroy();
                Ext.hui.session.saveConfig();
            }
        }
    ],
    initComponent: function() {

        this.dataStore = new Ext.data.Store({
            restful:true,
            proxy: new Ext.data.HttpProxy({
                url: 'rest/patientLabs.json',
                disableCaching:true,
                timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
                method:'GET'
            }),
            baseParams:{
                patToken:this.patientToken,
                startDate:Ext.util.Format.dateRenderer("m/d/y")(this.startDate),
                endDate:Ext.util.Format.dateRenderer("m/d/y")(this.endDate)
            },
            reader: this.createJsonReader(),

            sortInfo: {
                field: 'collectionDate',
                direction: 'DESC'
            },
            listeners:
            {
                exception:{
                    scope:this,
                    fn:function(dataProxy, type, action, options, response, arg){
                        Ext.hui.common.handleNetworkFailure(response.status, this);

                    }
                },
                beforeLoad:
                {
                    scope:this,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading = new Ext.LoadMask(this.gridArea.el, {msg:"Loading...", store:this.dataStore});
                        this.loading.show();
                        if (this.filter) this.filter.disable();
                    }
                },
                load:
                {
                    scope:this,
                    fn:
                    function(store, records, options){
                        if (!this || this.isDestroy) return;
                        var inMemoryStore = new Ext.data.Store({
                            proxy: new Ext.ux.data.PagingMemoryProxy(store.reader.jsonData),
                            remoteSort:true,
                            reader: this.createJsonReader(),
                            sortInfo: {
                                field: 'collectionDate',
                                direction: 'DESC'
                            }
                        });
                        //destroy previous grid panel
                        if (this.gridPanel)
                        {
                            this.gridPanel.destroy();
                        }
                        this.gridPanel = this.createGrid(inMemoryStore, this);
                        inMemoryStore.load({params:{start:0, limit:Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE}});

                        this.gridArea.removeAll();
                        this.gridArea.add(this.gridPanel);
                        this.doLayout();

                        this.setTitle("Labs ("+records.length+")");

                        if (this.filter) this.filter.enable();
                    }
                }

            }
        });

        this.filter = new Ext.hui.filter.DateFilter({
            region:'north',
            dataStore:this.dataStore,
            startDate:this.startDate,
            endDate:this.endDate,
            disabled:true,
            hidden:true
        });


        this.gridArea = new Ext.Container({layout:'fit', region:'center', html:''});
        this.items = [this.filter, this.gridArea];

        Ext.hui.widget.patient.Labs.superclass.initComponent.call(this);
    },
    createJsonReader: function()
    {
        return new Ext.data.JsonReader({
                root: ''
            },
            [
                {name: 'testName'},
                {name: 'collectionDate', type:'date'},
                {name: 'nonPlainTextResult'},
                {name: 'recordDetailsToken'},
                {name: 'siteCode'},
                {name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
            ]);
    },
    createGrid: function(gridDataStore, refWidget)
    {
        var dateRenderer = Ext.util.Format.dateRenderer('M d, Y H:i');

        return new Ext.grid.GridPanel({
            store: gridDataStore,
            ctCls: "dataGrid",
            columns: [
            {
                header   : 'Site',
                width    : 60,
                sortable : true,
                dataIndex: 'siteMoniker',
                renderer :
                function(value, metaData, record, rowIndex, colIndex, store) {
                    return Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker);
                }
            },
            {
                width    : 125,
                header   : 'Date',
                sortable : true,
                dataIndex: 'collectionDate',
                renderer: dateRenderer
            },
            {
                id: 'testName',
                width    : 125,
                header   : 'Test',
                sortable : true,
                dataIndex: 'testName',
                renderer :{
                    fn:function(value, metaData, record, rowIndex, colIndex, store) {
                        if (record.data.recordDetailsToken != null)
                        {
                            return String.format('<span class="record-details" id="lab-details-{0}-{1}">{2}</span>', refWidget.id, record.id, record.data.testName);
                        }
                        else return record.data.testName;

                    },
                    scope:this
                }
            }
            ],
            listeners:{
                rowclick:
                {
                    scope:this,
                    fn:function(grid, rowIdx, evtObj) {
                        var record = grid.getStore().getAt(rowIdx);
                        if (Ext.get(String.format("lab-details-{0}-{1}", refWidget.id, record.id))){
                            if(evtObj.within(String.format("lab-details-{0}-{1}", refWidget.id, record.id)))
                            {
                                if (record.data.nonPlainTextResult)
                                {
                                    refWidget.desktop.createWindow({
                                        title:String.format("Lab Results ~ {0} {1}",
                                                Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker),
                                                record.data.testName),
                                        patientToken:refWidget.patientToken,
                                        desktop:refWidget.desktop,
                                        recordDetailsToken:record.data.recordDetailsToken,
                                        siteMoniker:record.data.siteMoniker
                                    }, Ext.hui.desktopwindow.patient.LabResults).show();
                                }
                                else
                                {
                                    refWidget.desktop.createWindow({
                                        title:String.format("Lab Results ~ {0} {1}",
                                                Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker),
                                                record.data.testName),
                                        patientToken:refWidget.patientToken,
                                        desktop:refWidget.desktop,
                                        recordDetailsToken:record.data.recordDetailsToken
                                    }, Ext.hui.desktopwindow.patient.LabReport).show();
                                }
                            }
                        }
                    }
                }
            },
            selModel: new Ext.grid.CellSelectionModel(),
            stripeRows: true,
            autoExpandColumn:'testName',
            border:true,
            bodyBorder:true,
            columnLines:true,
            loadMask:true,
            layout:'fit',
            region: 'center',
            bbar: new Ext.PagingToolbar({
                pageSize: Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE,
                store: gridDataStore,
                displayInfo: true,
                items:[
                {
                    text: 'more >>',
                    cls: 'more-link',
                    listeners:
			        {
                        click: function(btn, pressed){
                            refWidget.desktop.createWindow({
                                patientToken:refWidget.patientToken,
                                desktop:refWidget.desktop,
                                startDate:refWidget.startDate,
                                endDate:refWidget.endDate
                            }, Ext.hui.desktopwindow.patient.Labs).show();
                        }

                    }
                }]
            }),
            viewConfig: {
                emptyText:"No results",
                forceFit:true
            }
        });
    }
});

Ext.reg('labs_widget', Ext.hui.widget.patient.Labs);