/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Allergies Widget
 * 
 * @param {} config
 * 
 * @cfg patientToken
 *     Patient's security token
 * @cfg desktop
 *    Reference to application desktop object
 */
Ext.hui.widget.patient.Allergies = Ext.extend(Ext.hui.widget.Widget,
{
	title: "Allergies",
	height:200,
	tools:[
		{
			id: 'copy',
            enableTabbing: true,
			qtip: 'Copy to Clipboard',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
                    Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
            enableTabbing: true,
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
			{
		    id:'refresh',
                enableTabbing: true,
		    qtip: 'Refresh',
		    handler: function(event, toolEl, panel){
		        panel.dataStore.reload();
		    }
		},
		{
			id:'close',
            enableTabbing: true,
		    qtip: 'Close Widget',
		    handler: function(event, toolEl, panel){
		        panel.destroy();
                Ext.hui.session.saveConfig();
		    }
		}
	],
	initComponent: function() {

        this.bhieSourceReport = null;

        this.dataStore = new Ext.data.Store({
			restful:true,
			proxy: new Ext.data.HttpProxy({
                url: 'rest/patientAllergies.json',
                disableCaching:true,
                method:'GET',
                timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS
            }),
            baseParams:
            {
                patToken:this.patientToken
            },
	        reader: this.createJsonReader(),
	        
	        sortInfo: {
			    field: 'name',
			    direction: 'ASC'
			},
			listeners:
			{
				exception:
				{
					scope:this, fn:function(dataProxy, type, action, options, response, arg){
												Ext.hui.common.handleNetworkFailure(response.status, this);

											}},
                beforeload:
                {
                    scope:this,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading = new Ext.LoadMask(this.gridArea.el, {msg:"Loading...", store:this.dataStore});
                        this.loading.show();
                        this.bhieSourceReport = null;
                    }
                },
				load:{scope:this, fn:function(store, records, options)
					{
			    		if (!this || this.isDestroy) return;
                        var jsonDt = [];
                        for(var i = 0; i < records.length; i++)
                        {
                            jsonDt[i] = records[i].json;
                        }


                        var inMemoryStore = new Ext.data.Store({
                            proxy: new Ext.ux.data.PagingMemoryProxy(jsonDt),
                            remoteSort:true,
                            reader: this.createJsonReader(),
                            sortInfo: {
                                field: 'name',
                                direction: 'ASC'
                            }
                        });
                        //destroy previous grid panel
                        if (this.gridPanel)
                        {
                            this.gridPanel.destroy();
                        }
                        this.gridPanel = this.createGrid(inMemoryStore, this);
                        inMemoryStore.load({params:{start:0, limit:Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE}});

                        this.gridArea.removeAll();
                        this.gridArea.add(this.gridPanel);
                        this.doLayout();

                        this.setTitle("Allergies ("+jsonDt.length+")");

		    			
			    	}}
			}
	    });
        this.gridArea = new Ext.Container({layout:'fit', region:'center', html:''});
		this.items = [this.gridArea];

		Ext.hui.widget.patient.Allergies.superclass.initComponent.call(this); 
	},
    createJsonReader: function()
    {
        return new Ext.data.JsonReader({
	            root: ''
	        },
	        [
				{name: 'name'},
				{name: 'siteCode'},
				{name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
	        ]);
    },
    createGrid: function(gridDataStore, refWidget)
    {

        var pagingBarItems = [
        {
            text: 'more >>',
            cls: 'more-link',
            listeners:
            {
                click: function(btn, pressed){
                    refWidget.desktop.createWindow({
                        patientToken:refWidget.patientToken,
                        desktop:refWidget.desktop,
                        startDate:refWidget.startDate,
                        endDate:refWidget.endDate
                    }, Ext.hui.desktopwindow.patient.Allergies).show();
                }

            }
        }];

        var gridPanel = new Ext.grid.GridPanel({
	        store: gridDataStore,
	        columns: [
	            {
	                header   : 'Site',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'siteMoniker',
	                renderer :
	                        function(value, metaData, record, rowIndex, colIndex, store) {
	                            return Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker);
	                        }
	            },
	        	{
	                id       :'name',
	                header   : 'Name',
	                width    : 250,
                    sortable : true,
	                dataIndex: 'name'
	            }
	        ],
            selModel: new Ext.grid.CellSelectionModel(),
	        stripeRows: true,
            columnLines:true,
	        autoExpandColumn:'name',
	        border:true,
	        bodyBorder:true,
	        loadMask:true,
            bbar: new Ext.PagingToolbar({
                pageSize: Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE,
                store: gridDataStore,
                displayInfo: true,
                items: pagingBarItems
            }),
	        viewConfig: {
	        	emptyText:"No results",
	        	forceFit:true
	        }
	    });

        return gridPanel;
    }
});

Ext.reg('allergies_widget', Ext.hui.widget.patient.Allergies);