/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.hui.widget.widgetIconDragZone = function(v) {
    v.dragZone = new Ext.dd.DragZone(v.getEl(), {

//      On receipt of a mousedown event, see if it is within a draggable element.
//      Return a drag data object if so. The data object can contain arbitrary application
//      data, but it should also contain a DOM element in the ddel property to provide
//      a proxy to drag.
        getDragData: function(e) {
            var sourceEl = e.getTarget(v.itemSelector, 10), d;
            if (sourceEl) {
                d = sourceEl.cloneNode(true);

                d.id = Ext.id();

                var widgetConfig = {xtype:v.widgetId, desktop:Ext.hui.app.desktop, renderTo:'dropPlaceholder'};

                if(Ext.hui.app.desktop.activePortal == Ext.hui.desktop.PORTAL_PATIENT)
                {
                    widgetConfig.patientToken = Ext.hui.app.patientView.getPatientToken();
                }

                var widget = Ext.ComponentMgr.create(widgetConfig);
                var dragdata = v.dragData = {
                    sourceEl: sourceEl,
                    repairXY: false,
                    ddel: d,
                    panel: widget
                };

                return dragdata;
            }
        },
        //create the Proxy (copy of original object)
        /*startDrag:function(x, y) {
            var dragEl = Ext.get(this.getDragEl());
            var el = Ext.get(this.getEl());
            dragEl.applyStyles({'z-index':2000});
            dragEl.update(el.dom.innerHTML);
           dragEl.addClass(el.dom.className + ' dd-proxy');

        },*/
//      Provide coordinates for the proxy to slide back to on failed drag.
//      This is the original XY coordinates of the draggable element.
        getRepairXY: function() {
            //return this.dragData.repairXY;
            return false;
        },
        //prevent offscreen drag/scroll
        scroll:false
    });
}

var insertWidget = function (panelIndex, col, widgetId){
    var views = Ext.query('.portalView');
    if (panelIndex == Ext.hui.desktop.PORTAL_PROVIDER) {
        Ext.getCmp(views[panelIndex].id).getActiveTab().items.items[0].items.items[col].add(
                {
                    xtype: widgetId,
                    desktop:Ext.hui.app.desktop
                }
        ).show();
        Ext.getCmp(views[panelIndex].id).getActiveTab().items.items[0].items.items[col].doLayout();
        Ext.hui.session.saveConfig();
    } else if (panelIndex == Ext.hui.desktop.PORTAL_PATIENT) {
        Ext.getCmp(views[panelIndex].id).getActiveTab().items.items[0].items.items[col].add(
                {
                    xtype: widgetId,
                    desktop:Ext.hui.app.desktop,
                    patientToken:Ext.hui.app.patientView.getPatientToken()
                }
        ).show();
        Ext.getCmp(views[panelIndex].id).getActiveTab().items.items[0].items.items[col].doLayout();
        Ext.hui.session.saveConfig();

    } else {
        //alert('invalid target.');
    }
}


Ext.hui.widget.WidgetIcon = function(config){
	Ext.hui.widget.WidgetIcon.superclass.constructor.call(this, config);
	var widgetGroup;
    var widgetId;
    var image;
}

Ext.extend(Ext.hui.widget.WidgetIcon, Ext.Container, {
	cls: 'widgetIcon',
	overCls: 'widgetIconOver',
    itemSelector: 'div.widgetIcon',
    height: 50,
	width: 50,
	initComponent: function() {
    	Ext.hui.widget.WidgetIcon.superclass.initComponent.call(this);
    },
    afterRender: function(){
        var iconText = this.getEl().dom.innerHTML.replace(" ", "<br>");
        this.getEl().dom.title =  this.getEl().dom.innerHTML;
    	this.update('<div class="widgetIconText">' + iconText + '</div>');
        this.getEl().on({
            keydown: this.onKeyDown,
            scope: this
        });

    },
    listeners: {
        render: Ext.hui.widget.widgetIconDragZone
    },
    onKeyDown: function(e, t){
        //e.getKey()  "1" = 49, "2" = 50, "3" = 51;
        if(e.ctrlKey){
            var col = null;
            if (e.getKey() == 49){
                col = 0;
            } else
            if (e.getKey() == 50){
                col = 1;
            } else
            if (e.getKey() == 51){
                col = 2;
            }

            if(col != null) {
                insertWidget(Ext.hui.app.desktop.activePortal,col,Ext.getCmp(this.id).widgetId);
            }
        }
    }
});

Ext.reg('widgetIcon', Ext.hui.widget.WidgetIcon);