/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Abstract Widget Class
 */
Ext.hui.widget.Widget = function(config)
{
	Ext.hui.widget.Widget.superclass.constructor.call(this, config); 
}
Ext.extend(Ext.hui.widget.Widget, Ext.Panel, 
{
	//anchor : '100%',
	layout: 'fit',
    frame : true,
    collapsible : false,
    draggable : true,
    cls : 'x-portlet',
    isWidgetLoaded: false,

    //widget components
    gridArea:null,
    gridPanel:null,
    dateFilter:null,
    loading:null,

    dataStore:null,

    loadWidget: function()
    {
        if (this.dataStore)
        {
            this.dataStore.load();
        }

        this.isWidgetLoaded = true;
    },
    showErrorMsg: function(errorMsg)
	{
		if (!this || this.isDestroy) return;

        var errorMsgCont = new Ext.Container({region:"center", html:"<span class='error-message'>"+errorMsg+"</span>"});
        if (this.gridArea)
        {
            this.gridArea.removeAll();
            this.gridArea.add(errorMsgCont);
        }
        else this.add(errorMsgCont);

        this.doLayout();
	},
    destroy: function()
    {
        this.isDestroy = true;

        if (this.gridPanel)
        {
            this.gridPanel.destroy();
            this.gridPanel = null;
        }
        if (this.dataStore)
        {
            this.dataStore.destroy();
            this.dataStore = null;
        }
        if (this.gridArea)
        {
            this.gridArea.destroy();
            this.gridArea = null;
        }

        Ext.hui.widget.Widget.superclass.destroy.call(this);
    },
	initComponent: function(){
		Ext.hui.widget.Widget.superclass.initComponent.apply(this, arguments);
		this.on({ 
			afterrender: function(p) {
	            this.resizer = new Ext.Resizable(p.getEl(), {
	                handles: 's',
	                pinned: false,
	                transparent: true,
				    minHeight: 100,
				    maxHeight: 550,
	                resizeElement: function() {
	                    var box = this.proxy.getBox();
	                    p.updateBox(box);
	                    if (p.layout) {
	                        p.doLayout();
                        }
                        Ext.hui.session.saveConfig();
	                    return box;
	               	}
                });
	        },
            afterLayout: function() {
            },
            destroy: function (p){
            }

		});	
	}

});

Ext.reg('widget', Ext.hui.widget.Widget);