/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.namespace('Ext.hui.session');

Ext.hui.session.COOKIE_EXPIRATION = new Date(new Date().getTime()+(1000*60*60*24*365));

Ext.hui.session.setCookie = function(_key, _value){
    Ext.util.Cookies.set(_key, Ext.encode(_value),Ext.hui.session.COOKIE_EXPIRATION);
}

Ext.hui.session.getCookie = function(_key){
    return Ext.decode(Ext.util.Cookies.get(_key));
}

Ext.hui.session.clearCookie = function(_key){
    Ext.util.Cookies.set(_key, null, new Date("January 1, 1970"));
    Ext.util.Cookies.clear(_key);
}

//Ext.hui.session.clearCookie('prov_view_cfg');
//Ext.hui.session.clearCookie('pat_view_cfg');

//Ext.hui.session.prov_view_cfg = Ext.hui.session.getCookie('prov_view_cfg');
//Ext.hui.session.pat_view_cfg = Ext.hui.session.getCookie('pat_view_cfg');
Ext.hui.session.prov_view_cfg = "";
Ext.hui.session.pat_view_cfg = "";
Ext.hui.session.ui_conf = "";

Ext.each(Ext.hui.session.cfg,function(conf,tCnt) {
    if(conf.cfgItem == "PORTAL_PROVIDER"){
        Ext.hui.session.prov_view_cfg = conf;
    } else if (conf.cfgItem == "PORTAL_PATIENT"){
        Ext.hui.session.pat_view_cfg = conf;
    } else if (conf.cfgItem == "UI_CONF"){
        Ext.hui.session.ui_conf = conf;
    }
});

if (Ext.hui.session.prov_view_cfg == null || Ext.hui.session.prov_view_cfg == "") {
    Ext.hui.session.prov_view_cfg = {
        tabs:[
            {"label": ""
             ,"cols":[
                {"widgets":[
                    {"widgetType": "prov_admissions_widget","height":200},
                    {"widgetType": "prov_orderspending_widget","height":200}
                ]}
                ,{"widgets":[
                    {"widgetType": "prov_appointments_widget","height":200}
                ]}
                ,{"widgets":[{"widgetType": "prov_consultsreceived_widget","height":200}
                ]}
            ]},
            {"label": "My Custom Tab"
             ,"cols":[
                {"widgets":[
                    {"widgetType": "prov_consultsrequested_widget","height":200}
                ]}
                ,{"widgets":[]}
                ,{"widgets":[]}
            ]}
        ]
    };
    //Ext.hui.session.setCookie('prov_view_cfg',Ext.hui.session.prov_view_cfg);
};

if (Ext.hui.session.pat_view_cfg == null || Ext.hui.session.pat_view_cfg == "") {
    Ext.hui.session.pat_view_cfg = {
        tabs:[
        {"label": ""     //first tab already has a label
         ,"cols":[
            {"widgets":[
                {"widgetType": "allergies_widget","height":400}
            ]}
            ,{"widgets":[
                {"widgetType": "problemlist_widget","height":540}
            ]}
            ,{"widgets":[
                {"widgetType": "outpatientmedications_widget","height":260},
                {"widgetType": "labs_widget","height":270}
            ]}
        ]},
        {"label": "Docs"
         ,"cols":[
            {"widgets":[
                {"widgetType": "consults_widget","height":355}
            ]}
            ,{"widgets":[
                {"widgetType": "outpatientnotes_widget","height":495}
            ]}
            ,{"widgets":[
                {"widgetType": "radiologyexams_widget","height":495}
            ]}
        ]}
    ]
    };
    //Ext.hui.session.setCookie('pat_view_cfg',Ext.hui.session.pat_view_cfg);
};


//check to see if there is a UI configuration loaded.
if (Ext.hui.session.ui_conf == null || Ext.hui.session.ui_conf == "") {
    //if there are no configuration loaded, set the theme to "default"
    Ext.hui.session.ui_conf = {
         options:[
            {"theme":"default"}
         ]
    }
}

//load ui config (theme, prov_ref)
if (Ext.hui.session.ui_conf.options != null && Ext.hui.session.ui_conf.options.length > 0){
    Ext.each(Ext.hui.session.ui_conf.options,function(opt,tCnt) {
        if(opt.theme){
            Ext.hui.session.theme = opt.theme;
        } else if(opt.prov_ref) {
            Ext.hui.session.prov_ref = opt.prov_ref;
        }
    });
}

Ext.hui.session.saveUIConfig = function(_rload){
    var cfg = [];
    var options = [];

    if(Ext.hui.session.cfg){
        cfg = Ext.hui.session.cfg;
    }

    options.push({theme:Ext.hui.session.theme});
    options.push({prov_ref:Ext.hui.session.prov_ref});

    //delete any instance of UI_CONF in the JSON object
    for(var i = cfg.length-1; i >= 0; i--){
        if(cfg[i].cfgItem == "UI_CONF"){
            cfg.splice(i,1);
        }
    }
    //add new config to the JSON object
    cfg.push({"cfgItem":"UI_CONF","options":options});

    Ext.hui.session.cfg = cfg;
    Ext.hui.session.saveConfigToDB(cfg,_rload);
}

Ext.hui.session.uiSaveConfirm = function (_rload){
    if(Ext.getCmp('UIConfig_window')){
        if(_rload){
            Ext.Msg.confirm("Save Configuration",
                "Reload the application to apply your settings?",
                function(btn, text){
                    if (btn == 'yes'){
                       //alert("you hit save");
                       window.location.reload();
                    }
                }
            );
        }  else {
            Ext.Msg.alert("Save Configuration",
                "Your settings were saved"
                )
            Ext.getCmp('UIConfig_window').close();
        }
    }
}


Ext.hui.session.saveConfig = function(){
    var views = Ext.query('.portalView');
    //Ext.getCmp(views[Ext.hui.app.desktop.activePortal].id).getActiveTab().items.items[0].items.items[2]
    //Ext.getCmp(views[Ext.hui.app.desktop.activePortal].id).items;
    var cfg = [];
    var tabs = [];

    if(Ext.hui.session.cfg){
        cfg = Ext.hui.session.cfg;
    }

    //make sure we aren't in the process of changing patients
    //we only want to save changes made to the current view
    if (views[Ext.hui.app.desktop.activePortal]){
        var portal = Ext.getCmp(views[Ext.hui.app.desktop.activePortal].id);

        Ext.each(portal.items.items,function(tab,tCnt) {
            var cols = []
            if (tab.title != "+" && tab.items.items[0].items.items){
                Ext.each(tab.items.items[0].items.items,function(col,cCnt) {
                    var widgets = [];
                    if (col.items.items){
                        Ext.each(col.items.items,function(wgt,wCnt) {
                            if (wgt.xtype != 'patientdemographics_widget' && wgt.xtype != undefined){
                                var widgetHeight = function(wgt) {
                                    if (wgt.getHeight() == 0){
                                        return wgt.height;
                                    } else {
                                        if(Math.abs(wgt.getHeight() - wgt.height) > 2) {
                                            return wgt.getHeight();
                                        } else return wgt.height;
                                    }
                                };
                                var widgetStartDay = function(wgt){
                                    if (wgt.startDate){
                                        var today =new Date();
                                        var sDate = new Date(wgt.startDate);
                                        var ONE_DAY=1000*60*60*24;
                                        return Math.ceil((sDate.getTime() - today.getTime())/ONE_DAY);
                                    } else {
                                        return "0";
                                    }
                                };
                                var widgetEndDay = function(wgt){
                                    if (wgt.endDate){
                                        var today =new Date();
                                        var eDate = new Date(wgt.endDate);
                                        var ONE_DAY=1000*60*60*24;
                                        return Math.ceil((eDate.getTime() - today.getTime())/ONE_DAY);
                                    } else {
                                        return "0";
                                    }
                                };
                                widgets.push({widgetType:wgt.xtype,height:widgetHeight(wgt),startDay:widgetStartDay(wgt),endDay:widgetEndDay(wgt)});
                            }
                        });
                        cols.push({widgets:widgets});
                    }
                });
                tabs.push({label:tab.title,cols:cols});
            }
        });
        // cfg[Ext.hui.app.desktop.activePortal] = {tabs:tabs};
        if (Ext.hui.app.desktop.activePortal == Ext.hui.desktop.PORTAL_PROVIDER){
            //loop to delete the old PORTAL_PROVIDER config
            for(var i = cfg.length-1; i >= 0; i--){
                if(cfg[i].cfgItem == "PORTAL_PROVIDER"){
                    cfg.splice(i,1);
                }
            }
            cfg.push({"cfgItem":"PORTAL_PROVIDER",tabs:tabs});
        } else if(Ext.hui.app.desktop.activePortal == Ext.hui.desktop.PORTAL_PATIENT) {
            for(var i = cfg.length-1; i >= 0; i--){
                if(cfg[i].cfgItem == "PORTAL_PATIENT"){
                    cfg.splice(i,1);
                }
            }
            Ext.hui.session.pat_view_cfg = {"cfgItem":"PORTAL_PATIENT",tabs:tabs};
            cfg.push({"cfgItem":"PORTAL_PATIENT",tabs:tabs});
        }
        Ext.hui.session.cfg = cfg;
        Ext.hui.session.saveConfigToDB(cfg);
    }
}

Ext.hui.session.saveConfigToDB = function(_cfg,_rload){
    Ext.Ajax.request({
            url: 'rest/userCfg',
            params: {
                cfg:Ext.util.JSON.encode(_cfg)
            },
            disableCaching:true,
            method: 'POST',
            timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
            success : function(response,opt){
                Ext.hui.session.uiSaveConfirm(_rload);
            },//success
            failure : function(response){
                Ext.Msg.alert(
                        "Error Detected: ", "An error occurred trying to save your configuration - " + response.responseText
                );
            }//failure
        });
}