/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.hui.portal.Provider = function() {

    var prov_panel = new Ext.Panel({
    	activeTab: 0,
    	layout: 'fit',
        autoScroll: true,
        title: 'Provider Portal',
    	id: 'prov_default_tab',
    	cls: 'prov_tab',
    	items:[{
            xtype:'portal',
            layout: 'column',
            border: false,
            items:[{
                columnWidth:.33,
                style:'padding:10px 0 10px 10px'
            },{
                columnWidth:.33,
                style:'padding:10px 0 10px 10px'
            },{
                columnWidth:.33,
                style:'padding:10px'
            }]
            
 
        }]
    }); 

    Ext.hui.portal.Provider.addTab = function (tabPanel, newTabName){
        tabPanel.insert( (tabPanel.items.length-1),{
            title: newTabName,
            closable:true,
            layout: 'fit',
            autoScroll: true,
            border: false,
            cls: 'prov_tab',
            listeners: {
                beforeclose:function(p){
                    var doClose = Ext.MessageBox.confirm('Close Tab','Close "' + p.title +  '"?', function(btn){
                        if (btn=='yes'){
                           p.destroy();
                           Ext.hui.session.saveConfig();
                        }
                    });
                    return false;
                }
            },
            items:[{
                xtype:'portal',
                layout: 'column',
                border: false,
                items:[{
                        maxHeight: 500,
                        columnWidth:.33,
                        style:'padding:10px 0 10px 10px'
                    },{
                        columnWidth:.33,
                        maxHeight: 500,
                        style:'padding:10px 0 10px 10px'
                    },{
                        columnWidth:.33,
                        maxHeight: 500,
                        style:'padding:10px'
                }]
            }]
         }).show();
    };

    var prov_tabPanel = new Ext.hui.portal.PortalTabPanel({
 	    renderTo: 'panel1',
 	    id: 'prov_tabPanel',
        relayTo: 'searchText',
        items:[
            prov_panel,
            {
                title: '+'
            }
        	],
        listeners: {
        	beforetabchange: function(tabPanel, newTab, currentTab){
                if(newTab){
                    if(newTab.title=="+"){
                        var dialog = Ext.Msg.prompt('New Tab', 'Please type in a new tab name:',function(btn,newTabName){
                            if ((btn=='ok') && newTabName){
                                Ext.hui.portal.Provider.addTab(tabPanel, newTabName);
                            } else {
                                tabPanel.activate(currentTab);
                            }

                        }).getDialog();
//                        dialog.defaultButton = 2;
                        dialog.enableTabbing = true;
                        Ext.select('ext-mb-input').addClass('x-a11y-focusable');
                        Ext.select('ext-mb-input').focus();

                        dialog.focus();


                    }
                }
            },
            beforeremove : function(tabPanel,closeTab){
                if (tabPanel.activeTab == closeTab){
                    tabPanel.activate(tabPanel.items.items[tabPanel.items.items.indexOf(closeTab)-1]);
                }
            },
            tabchange: function(tabPanel, newTab){
                newTab.doLayout();
            }
         }
            
    }); 
  
};