/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.hui.portal.PortalTabPanel = Ext.extend(Ext.TabPanel, {
    cls: 'portalView',
    boxMaxWidth: 1790,
    boxMinWidth: 920,
    plain: true,
    defaultType: 'portal',
    activeTab: 0,
    initComponent: function(config)
    {
        this.width = Ext.lib.Dom.getViewWidth()-20;
        this.height = Ext.lib.Dom.getViewHeight()-160;

        Ext.hui.portal.PortalTabPanel.superclass.initComponent.call(this);
    },
    setActiveTab: function(item)
    {
         Ext.hui.portal.PortalTabPanel.superclass.setActiveTab.call(this, item);

        //starting loading the tab's widgets
        var tab = this.getActiveTab();

        //bail if no items
        if (tab.items.items.length < 1)return;

        var tabCols = tab.items.items[0].items.items;
        for(var i = 0; i < tabCols.length; i++)
        {
            var colItems = tabCols[i].items.items;

            if (colItems)
            {
                for(var j = 0; j < colItems.length; j++)
                {
                    var widget = colItems[j];
                    if (widget && !widget.isWidgetLoaded)
                    {
                        if (widget.loadWidget) widget.loadWidget();
                    }
                }
            }

        }
    }

});