/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.hui.portal.Patient = function(patientToken, desktop,patName) {

    /**
     * Patient token accessor
     */
    this.getPatientToken = function()
    {
    	return patientToken;
    }
	
    var pat_panel = new Ext.Panel({
    	activeTab: 0,
    	title: patName,
    	layout: 'fit',
        autoScroll: true,
        cls: 'pat_tab',
    	items:[{
            xtype:'portal',
            border: false,

            items:[{
                columnWidth:.33,
                style:'padding:10px 0 10px 10px',
                items: new Ext.hui.widget.patient.PatientDemographics({
                    id: 'patDemographics',
                    patientToken:patientToken,
                    desktop:desktop,
                    renderTo:"demographicsPanel",
                        draggable : false})
            },{
                columnWidth:.33,
                style:'padding:10px 0 10px 10px'
            },{
                columnWidth:.33,
                style:'padding:10px'
            }]


        }]
    }); 
    
//    var demoWidget = new Ext.hui.widget.patient.PatientDemographics({
//            id: 'patDemographics',
//	    	width:Ext.lib.Dom.getViewWidth()/3-20,
//            patientToken:patientToken,
//	    	desktop:desktop,
//	    	renderTo:"demographicsPanel"
//    	});



    Ext.hui.portal.Patient.addTab = function (tabPanel, newTabName){
        tabPanel.insert( (tabPanel.items.length-1),{
            title: newTabName,
            closable:true,
            layout: 'fit',
            autoScroll: true,
            activeTab: 1,
            border: false,
            cls: 'pat_tab',
            listeners: {
                beforeclose:function(p){
                    var doClose = Ext.MessageBox.confirm('Close Tab?','Close Tab: ' + p.title +  '?', function(btn){
                        if (btn=='yes'){
                           p.destroy();
                           Ext.hui.session.saveConfig();
                        }
                    });
                    return false;
                }
            },
            items:[{
                xtype:'portal',
                border: false,
                items:[{
                        columnWidth:.33,
                        maxHeight: 500,
                        style:'padding:10px 0 10px 10px'
                    },{
                        columnWidth:.33,
                        maxHeight: 500,
                        style:'padding:10px 0 10px 10px'
                    },{
                        columnWidth:.33,
                        maxHeight: 500,
                        style:'padding:10px'
                }]
            }]
         }).show();
    };

    var pat_tabPanel = new Ext.hui.portal.PortalTabPanel({
 	    renderTo: 'panel2',
 	    id: 'pat_tabPanel',
 	    cls: 'portalView',
        items:[
            pat_panel,
            {
                title: '+',
                isFocusable: false
            }
        	],
        listeners: {
        	beforetabchange: function(tabPanel, newTab, currentTab){
                if(newTab){
                    if(newTab.title=="+"){
                        Ext.Msg.prompt('New Tab', 'Please type in a new tab name:',function(btn,newTabName){
                            if ((btn=='ok') && newTabName){
                                Ext.hui.portal.Patient.addTab(tabPanel, newTabName);
                            } else {
                                tabPanel.activate(currentTab);
                            }

                        });
                    }
                }
            },
            beforeremove : function(tabPanel,closeTab){
                if (tabPanel.activeTab == closeTab){
                    tabPanel.activate(tabPanel.items.items[tabPanel.items.items.indexOf(closeTab)-1]);
                }
            },
            tabchange: function(tabPanel, newTab){
                newTab.doLayout();
            }
         }
            
    });
    
    this.destroy = function()
    {
    	//clear out previous patient demographics
    	Ext.fly("demographicsPanel").dom.innerHTML = "";
    	pat_tabPanel.destroy();
    	pat_panel.destroy();
    	tools = null;
    }	
};