/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Vitals Filter
 * @param config VitalsFilter config object
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.VitalsFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.VitalsFilter.superclass.renderFilter.call(this);

        this.vitalsStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'type'
            ]
        });

        this.typeCombo = new Ext.form.ComboBox({
            store:this.vitalsStore,
            displayField:'type',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a vital type...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'type',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var typeFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Type', cls:'filter-label'},
                this.typeCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), typeFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyTypes(records);
    },
    applyTypes:function(records)
    {
        this.typeCombo.setValue("");
        this.vitalsStore.removeAll();
        var TypeRecord = Ext.data.Record.create([{name:'type'}]);
        var types = [];

        for(var i = 0; i < records.length; i++)
        {
            var type = records[i].data.type;
            if (Ext.hui.common.searchList(type, types) < 0)
            {
                if (type && type.length > 0) types.push(type);
            }
        }
        for(var i = 0; i < types.length; i++)
        {
            var typeRec = new TypeRecord({type:types[i]});

            this.vitalsStore.add(typeRec);
        }

        this.vitalsStore.singleSort('type', 'ASC');

        var typeRec = new TypeRecord({type:'All'});
        this.vitalsStore.insert(0, typeRec);
    }
});