/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Radiology Exam Filter
 * @param config RadiologyExamFilter config object
 * @cfg startDate Filter start date
 * @cfg endDate   Filter end date
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.RadiologyExamFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.RadiologyExamFilter.superclass.renderFilter.call(this);

        this.studyStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'study'
            ]
        });

        this.studyCombo = new Ext.form.ComboBox({
            store:this.studyStore,
            displayField:'study',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select study...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'study',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var studyFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Study', cls:'filter-label'},
                this.studyCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), studyFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyStudyNames(records);
    },
    applyStudyNames:function(records)
    {
        this.studyCombo.setValue("");
        this.studyStore.removeAll();
        var StudyRecord = Ext.data.Record.create([{name:'study'}]);

        var studyNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var studyName = records[i].data.study;
            if (Ext.hui.common.searchList(studyName, studyNames) < 0)
            {
                if (studyName && studyName.length > 0) studyNames.push(studyName);
            }
        }
        for(var i = 0; i < studyNames.length; i++)
        {
            var studyRec = new StudyRecord({study:studyNames[i]});

            this.studyStore.add(studyRec);
        }

        this.studyStore.singleSort('study', 'ASC');

        var studyRec = new StudyRecord({study:'All'});
        this.studyStore.insert(0, studyRec);
    }
});