/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Note Filter
 * @param config NoteFilter config object
 * @cfg startDate Filter start date
 * @cfg endDate   Filter end date
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.NoteFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.NoteFilter.superclass.renderFilter.call(this);

        this.noteTypeStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'noteType'
            ]
        });

        this.providerNamesStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'providerName'
            ]
        });
        this.noteTypeCombo = new Ext.form.ComboBox({
            store:this.noteTypeStore,
            displayField:'noteType',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a note type...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'noteType',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }

                        this.providerNameCombo.setValue("");
                    }
                }
            }
        });

        this.providerNameCombo = new Ext.form.ComboBox({
            store:this.providerNamesStore,
            displayField:'providerName',
            cls:'combo-list',
            resizable:true,
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a provider...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'providerName',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }

                        this.noteTypeCombo.setValue("");
                    }
                }
            }

        });

        var noteFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Note Type', cls:'filter-label'},
                {xtype:'label', html:'Filter by Provider', cls:'filter-label'},
                this.noteTypeCombo,
                this.providerNameCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), noteFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyNoteTypes(records);
        this.applyProviderNames(records);
    },
    applyNoteTypes:function(records)
    {
        this.noteTypeCombo.setValue("");
        this.noteTypeStore.removeAll();
        var NoteTypeRecord = Ext.data.Record.create([{name:'noteType'}]);

        var noteTypes = [];

        for(var i = 0; i < records.length; i++)
        {
            var noteType = records[i].data.noteType;
            if (Ext.hui.common.searchList(noteType, noteTypes) < 0)
            {
                if (noteType && noteType.length > 0) noteTypes.push(noteType);
            }
        }
        for(var i = 0; i < noteTypes.length; i++)
        {
            var noteTypeRec = new NoteTypeRecord({noteType:noteTypes[i]});

            this.noteTypeStore.add(noteTypeRec);
        }

        this.noteTypeStore.singleSort('noteType', 'ASC');

        var noteTypeRec = new NoteTypeRecord({noteType:'All'});
        this.noteTypeStore.insert(0, noteTypeRec);
    },
    applyProviderNames:function(records)
    {
        this.providerNameCombo.setValue("");
        this.providerNamesStore.removeAll();
        var ProviderNameRecord = Ext.data.Record.create([{name:'providerName'}]);

        var providerNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var providerName = records[i].data.providerName;
            if (Ext.hui.common.searchList(providerName, providerNames) < 0)
            {
                if (providerName && providerName.length > 0) providerNames.push(providerName);
            }
        }
        for(var i = 0; i < providerNames.length; i++)
        {
            var providerNameRec = new ProviderNameRecord({providerName:providerNames[i]});

            this.providerNamesStore.add(providerNameRec);
        }

        this.providerNamesStore.singleSort('providerName', 'ASC');

        var providerNameRec = new ProviderNameRecord({providerName:'All'});
        this.providerNamesStore.insert(0, providerNameRec);
    }
});