/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Medication Filter
 * @param config MedicationFilter config object
 * @cfg startDate Filter start date
 * @cfg endDate   Filter end date
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.MedicationFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.MedicationFilter.superclass.renderFilter.call(this);

        this.drugNamesStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'drugName'
            ]
        });

        this.hcpNamesStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'drugName'
            ]
        });
        this.drugNameCombo = new Ext.form.ComboBox({
            store:this.drugNamesStore,
            displayField:'drugName',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a drug...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'drugName',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }

                        this.hcpNameCombo.setValue("");
                    }
                }
            }
        });

        this.hcpNameCombo = new Ext.form.ComboBox({
            store:this.hcpNamesStore,
            displayField:'orderingProvider',
            cls:'combo-list',
            resizable:true,
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select an ordering HCP...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'orderingProvider',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }

                        this.drugNameCombo.setValue("");
                    }
                }
            }

        });

        var medFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Drug', cls:'filter-label'},
                {xtype:'label', html:'Filter by Ordering HCP', cls:'filter-label'},
                this.drugNameCombo,
                this.hcpNameCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), medFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyDrugNames(records);
        this.applyHCPNames(records);
    },
    applyDrugNames:function(records)
    {
        this.drugNameCombo.setValue("");
        this.drugNamesStore.removeAll();
        var DrugNameRecord = Ext.data.Record.create([{name:'drugName'}]);

        var drugNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var drugName = records[i].data.drugName;
            if (Ext.hui.common.searchList(drugName, drugNames) < 0)
            {
                if (drugName && drugName.length > 0) drugNames.push(drugName);
            }
        }
        for(var i = 0; i < drugNames.length; i++)
        {
            var drugNameRec = new DrugNameRecord({drugName:drugNames[i]});

            this.drugNamesStore.add(drugNameRec);
        }

        this.drugNamesStore.singleSort('drugName', 'ASC');

        var drugNameRec = new DrugNameRecord({drugName:'All'});
        this.drugNamesStore.insert(0, drugNameRec);
    },
    applyHCPNames:function(records)
    {
        this.hcpNameCombo.setValue("");
        this.hcpNamesStore.removeAll();
        var HCPNameRecord = Ext.data.Record.create([{name:'orderingProvider'}]);

        var hcpNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var hcpName = records[i].data.orderingProvider;
            if (Ext.hui.common.searchList(hcpName, hcpNames) < 0)
            {
                if (hcpName && hcpName.length > 0) hcpNames.push(hcpName);
            }
        }
        for(var i = 0; i < hcpNames.length; i++)
        {
            var hcpNameRec = new HCPNameRecord({orderingProvider:hcpNames[i]});

            this.hcpNamesStore.add(hcpNameRec);
        }

        this.hcpNamesStore.singleSort('orderingProvider', 'ASC');

        var hcpNameRec = new HCPNameRecord({orderingProvider:'All'});
        this.hcpNamesStore.insert(0, hcpNameRec);
    }
});