/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Lab Filter
 * @param config LabFilter config object
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.LabFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.LabFilter.superclass.renderFilter.call(this);

        this.labStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'testName'
            ]
        });

        this.testCombo = new Ext.form.ComboBox({
            store:this.labStore,
            displayField:'testName',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a test...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'testName',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var labFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Test', cls:'filter-label'},
                this.testCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), labFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyTestNames(records);
    },
    applyTestNames:function(records)
    {
        this.testCombo.setValue("");
        this.labStore.removeAll();
        var TestNameRecord = Ext.data.Record.create([{name:'testName'}]);

        var testNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var testName = records[i].data.testName;
            if (Ext.hui.common.searchList(testName, testNames) < 0)
            {
                if (testName && testName.length > 0) testNames.push(testName);
            }
        }
        for(var i = 0; i < testNames.length; i++)
        {
            var testNameRec = new TestNameRecord({testName:testNames[i]});

            this.labStore.add(testNameRec);
        }

        this.labStore.singleSort('testName', 'ASC');

        var testNameRec = new TestNameRecord({testName:'All'});
        this.labStore.insert(0, testNameRec);
    }
});