/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Immunization Filter
 * @param config ImmunizationFilter config object
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.ImmunizationFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.ImmunizationFilter.superclass.renderFilter.call(this);

        this.vaccineStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'vaccine'
            ]
        });

        this.vaccineCombo = new Ext.form.ComboBox({
            store:this.vaccineStore,
            displayField:'vaccine',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a vaccine...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'vaccine',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var immFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Vaccine', cls:'filter-label'},
                this.vaccineCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[immFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyVaccines(records);
    },
    applyVaccines:function(records)
    {
        this.vaccineCombo.setValue("");
        this.vaccineStore.removeAll();
        var VaccineRecord = Ext.data.Record.create([{name:'vaccine'}]);

        var vaccines = [];

        for(var i = 0; i < records.length; i++)
        {
            var vaccine = records[i].data.vaccine;
            if (Ext.hui.common.searchList(vaccine, vaccines) < 0)
            {
                if (vaccine && vaccine.length > 0) vaccines.push(vaccine);
            }
        }
        for(var i = 0; i < vaccines.length; i++)
        {
            var vaccineRec = new VaccineRecord({vaccine:vaccines[i]});

            this.vaccineStore.add(vaccineRec);
        }

        this.vaccineStore.singleSort('vaccine', 'ASC');

         var vaccineRec = new VaccineRecord({vaccine:'All'});
        this.vaccineStore.insert(0, vaccineRec);
    }
});