/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Filter Base Class
 * @param config Filter config object
 */
Ext.hui.filter.Filter = Ext.extend(Ext.Container, {
    cls : 'filter',
    autoHeight:true,
    initComponent : function() {
        var tpl = new Ext.XTemplate
        (
            '<div id="filter-{id}"></div>',
            '<div id="filter-link-{id}" class="filter-link">',
                'Open Filter',
            '</div>'
        );

        this.html = tpl.apply({id:this.id});

        this.listeners =
        {
            afterrender:
            {
                scope:this,
                fn:this.renderFilter
            }
        };

        Ext.hui.filter.Filter.superclass.initComponent.call(this);
    },
    getFilterParent: function()
    {
        var filterParent = this.findParentByType("widget");
        if (!filterParent)
        {
            filterParent = this.findParentByType("desktopwindow");
        }

        return filterParent;
    },
    renderFilter : function() {
        
        Ext.fly('filter-'+this.id).setVisibilityMode(Ext.Element.DISPLAY);
        Ext.fly('filter-'+this.id).setVisible(false);
        Ext.EventManager.addListener(String.format('filter-link-{0}', this.id), 'click', this.toggleView, this);
    },
    toggleView:function()
    {
        var filterEl = Ext.get('filter-'+this.id);
        this.displayFilter(!filterEl.isVisible());
    },
    displayFilter:function(isVisible)
    {
        var filterEl = Ext.get('filter-'+this.id);
        if (isVisible)
        {
            filterEl.setVisible(true);
            Ext.fly('filter-link-'+this.id).dom.innerHTML = "Close Filter";
            this.show();
        }
        else
        {
            filterEl.setVisible(false);
            Ext.fly('filter-link-'+this.id).dom.innerHTML = "Open Filter";
            this.hide();
        }

        var filterParent = this.getFilterParent();

        if (filterParent)
        {
            filterParent.doLayout();
        }
    },
    createDateFilterForm:function(startDate, endDate, dataStore) {
        var dateFormat = 'd-M-Y';

        //add date fields
        this.dpStartDate = new Ext.form.DateField({
            allowBlank: false,
            layout:'fit',
            format:dateFormat,
            value:startDate,
            width:100,
            cls:'date-display'
        });

        this.dpEndDate = new Ext.form.DateField({
            allowBlank: false,
            format:dateFormat,
            value:endDate,
            width:100,
            cls:'date-display'
        });

        var dateApplyButton = {
            xtype:'button',
            text:'Apply',
            cls:'filter',
            scope:this,
            handler:function(button, evtObj)
            {
                if (this.dpStartDate.getValue() > this.dpEndDate.getValue())
                {
                    Ext.Msg.alert("Invalid Date Range", "Invalid date range: start date must come before end date.");
                }
                else if (this.dpStartDate.isValid() && this.dpEndDate.isValid())
                {
                    var filterParent = this.getFilterParent();

                    if (filterParent)
                    {
                        filterParent.startDate = this.dpStartDate.getValue();
                        filterParent.endDate =  this.dpEndDate.getValue();
                        //save config to save the new widget dates.
                        //Ext.hui.session.saveConfig();
                    }

                    if (dataStore)
                    {
                        dataStore.baseParams.startDate = Ext.util.Format.dateRenderer("m/d/y")(this.dpStartDate.getValue());
                        dataStore.baseParams.endDate = Ext.util.Format.dateRenderer("m/d/y")(this.dpEndDate.getValue());
                        dataStore.reload();
                    }

                }
                else
                {
                    if (!this.dpStartDate.isValid()) Ext.Msg.alert("Invalid Start Date", this.dpStartDate.getErrors()[0]);
                    else if (!this.dpEndDate.isValid()) Ext.Msg.alert("Invalid End Date", this.dpEndDate.getErrors()[0]);
                }
            }
        }

        var dateFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:3,
                tableAttrs: {
                    style: {
                        width: '275px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Start Date', cls:'filter-label'},
                {xtype:'label', html:'End Date', cls:'filter-label', colspan:2},
                this.dpStartDate,
                this.dpEndDate,
                dateApplyButton
            ]
        });

        return dateFilterForm;
    }

});