/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * DateFilter
 * @param config DateFilter config object
 * @cfg startDate Filter start date
 * @cfg endDate   Filter end date
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.DateFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter:function() {
        Ext.hui.filter.DateFilter.superclass.renderFilter.call(this);

        var dateFilter = new Ext.Container({
            renderTo:'filter-'+this.id,
            items:this.createDateFilterForm(this.startDate, this.endDate, this.dataStore)
        });
    }
});
Ext.reg('datefilter', Ext.hui.filter.DateFilter);