/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Consult Filter
 * @param config ConsultFilter config object
 * @cfg startDate Filter start date
 * @cfg endDate   Filter end date
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.ConsultFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.ConsultFilter.superclass.renderFilter.call(this);

        this.serviceStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'service'
            ]
        });

        this.serviceCombo = new Ext.form.ComboBox({
            store:this.serviceStore,
            displayField:'service',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select service...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'service',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var serviceFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Service', cls:'filter-label'},
                this.serviceCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), serviceFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyServiceNames(records);
    },
    applyServiceNames:function(records)
    {
        this.serviceCombo.setValue("");
        this.serviceStore.removeAll();
        var ServiceRecord = Ext.data.Record.create([{name:'service'}]);

        var serviceNames = [];

        for(var i = 0; i < records.length; i++)
        {
            var serviceName = records[i].data.service;
            if (Ext.hui.common.searchList(serviceName, serviceNames) < 0)
            {
                if (serviceName && serviceName.length > 0) serviceNames.push(serviceName);
            }
        }
        for(var i = 0; i < serviceNames.length; i++)
        {
            var serviceRec = new ServiceRecord({service:serviceNames[i]});

            this.serviceStore.add(serviceRec);
        }

        this.serviceStore.singleSort('service', 'ASC');

         var serviceRec = new ServiceRecord({service:'All'});
        this.serviceStore.insert(0, serviceRec);
    }
});