/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Appointments Filter
 * @param config AppointmentsFilter config object
 * @cfg dataStore Filter's data store
 */
Ext.hui.filter.AppointmentsFilter = Ext.extend(Ext.hui.filter.Filter, {
    renderFilter: function()
    {
        Ext.hui.filter.AppointmentsFilter.superclass.renderFilter.call(this);

        this.apptsStore = new Ext.data.ArrayStore({
            autoDestroy: true,
            idIndex: 0,
            fields: [
               'clinic'
            ]
        });

        this.clinicCombo = new Ext.form.ComboBox({
            store:this.apptsStore,
            displayField:'clinic',
            resizable:true,
            cls:'combo-list',
            typeAhead: true,
            mode: 'local',
            editable:false,
            forceSelection: true,
            triggerAction: 'all',
            emptyText:'Select a clinic...',
            width:250,
            listeners:{
                scope: this,
                'select': function(combo, record, index)
                {
                    var dataStore = this.dataStore;
                    if (dataStore)
                    {
                        if (combo.value == 'All')
                        {
                            dataStore.clearFilter();
                        }
                        else
                        {
                            dataStore.filter([{
                                   property: 'clinic',
                                   value: combo.value,
                                   anyMatch: false,
                                   exactMatch: true
                            }]);
                        }
                    }
                }
            }
        });

        var clinicFilterForm = new Ext.FormPanel({
            labelAlign:'top',
            layout:'table',
            cls:'filter',
            layoutConfig:{
                columns:1,
                tableAttrs: {
                    style: {
                        width: '550px'
                    }
                }
            },
            frame:false,
            items: [
                {xtype:'label', html:'Filter by Clinic', cls:'filter-label'},
                this.clinicCombo
            ]
        });

        new Ext.Container({
            layout:'table',
            layoutConfig:{
                columns:2,
                tableAttrs: {
                    style: {
                        width: '400px'
                    }
                }
            },
            renderTo:'filter-'+this.id,
            items:[this.createDateFilterForm(this.startDate, this.endDate, this.dataStore), clinicFilterForm]
        });
    },
    loadWithData:function()
    {
        var store = this.dataStore;
        store.clearFilter();
        var records = store.getRange();
        this.applyClinics(records);
    },
    applyClinics:function(records)
    {
        this.clinicCombo.setValue("");
        this.apptsStore.removeAll();
        var ClinicRecord = Ext.data.Record.create([{name:'clinic'}]);

        var clinics = [];

        for(var i = 0; i < records.length; i++)
        {
            var clinic = records[i].data.clinic;
            if (Ext.hui.common.searchList(clinic, clinics) < 0)
            {
                if (clinic && clinic.length > 0) clinics.push(clinic);
            }
        }
        for(var i = 0; i < clinics.length; i++)
        {
            var clinicRec = new ClinicRecord({clinic:clinics[i]});

            this.apptsStore.add(clinicRec);
        }

        this.apptsStore.singleSort('clinic', 'ASC');

        var clinicRec = new ClinicRecord({clinic:'All'});
        this.apptsStore.insert(0, clinicRec);
    }
});