/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * User Config Window
 * @param {} config Class configuration object
 *
 */
Ext.hui.desktopwindow.provider.UIConfig = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
    id: 'UIConfig_window',
    loadTheme: function(theme){
        var removeCSS = function(fileName){
            var allLinks = document.getElementsByTagName("link");
            for(var i=allLinks.length-1; i>=0;i--){
                if(allLinks[i].getAttribute("href").indexOf(fileName)!=-1){
                    allLinks[i].parentNode.removeChild(allLinks[i]);
                }
            }
        }

        var loadCSS = function(file) {
            var link = document.createElement('link');
            link.href = file;
            link.rel = 'stylesheet';
            link.type = 'text/css';
            document.getElementsByTagName('head')[0].appendChild(link);
        }

        var removeThemes = function () {
            //removeCSS("ext-all");
            removeCSS("theme");
        }

       Ext.hui.app.shiftView('l');

        switch(theme)
        {
        case "default":
          removeThemes();
          loadCSS(Ext.hui.session.THEME_DEFAULT);
          loadCSS(Ext.hui.session.THEME_DEFAULT2);
          break;
        case "blue":
          removeThemes();
          loadCSS(Ext.hui.session.THEME_BLUE);
          loadCSS(Ext.hui.session.THEME_BLUE2);
          break;
        case "gray":
          removeThemes();
          loadCSS(Ext.hui.session.THEME_GRAY);
          loadCSS(Ext.hui.session.THEME_GRAY2);
          break;
        case "access":
          removeThemes();
          loadCSS(Ext.hui.session.THEME_ACCESS);
          loadCSS(Ext.hui.session.THEME_ACCESS2);
          break;
        default:
          removeThemes();
          loadCSS(Ext.hui.session.THEME_DEFAULT);
          loadCSS(Ext.hui.session.THEME_DEFAULT2);
        }
    },
	initComponent: function() {
        this.title='User Configuration';
        this.width = 700;
        this.height = 500;
        this.layout = "fit";
        this.iconCls = 'icon-grid';
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;
        //this.dataStore = this.dataStore;

        this.formArea = new Ext.form.FormPanel({
            cls: 'uiconfig',
            width: 300,
            items: [{
                xtype: 'radiogroup',
                fieldLabel: 'Theme',
                id: 'rbGroupTheme',
                items: [{
                    xtype: 'radio',
                    boxLabel: 'Default',
                    name: 'rbTheme',
                    inputValue: 'default',
                    checked: Ext.hui.session.theme == 'default',
                    id: 'rbDefault',
                    handler: function(ctl, val) {
                        if(ctl.checked)
                        Ext.getCmp('UIConfig_window').loadTheme(ctl.inputValue);
                    }
                },{
                    xtype: 'radio',
                    boxLabel: 'Blue',
                    name: 'rbTheme',
                    inputValue: 'blue',
                    checked: Ext.hui.session.theme == 'blue',
                    id: 'rbBlue',
                    handler: function(ctl, val) {
                        if(ctl.checked)
                        Ext.getCmp('UIConfig_window').loadTheme(ctl.inputValue);
                    }
                },{
                    xtype: 'radio',
                    boxLabel: 'Gray',
                    name: 'rbTheme',
                    inputValue: 'gray',
                    checked: Ext.hui.session.theme == 'gray',
                    id: 'rbGray',
                    handler: function(ctl, val) {
                        if(ctl.checked)
                        Ext.getCmp('UIConfig_window').loadTheme(ctl.inputValue);
                    }
                },{
                    xtype: 'radio',
                    boxLabel: 'Accessible',
                    name: 'rbTheme',
                    inputValue: 'access',
                    checked: Ext.hui.session.theme == 'access',
                    id: 'rbAccess',
                    handler: function(ctl, val) {
                        if(ctl.checked)
                        Ext.getCmp('UIConfig_window').loadTheme(ctl.inputValue);
                    }
                }]
            }],
            buttons: [{
                text: 'Save',
                handler: function(){
                    Ext.hui.session.theme = Ext.getCmp('rbGroupTheme').getValue().inputValue;
                    var saved = false;

                    //if (Ext.hui.session.theme == 'access'){
                        Ext.hui.session.saveUIConfig('reload');
//                    } else {
//                        Ext.hui.session.saveUIConfig();
//                    }
                }
            },
            {
                text: 'Cancel',
                handler: function(){
                    this.ownerCt.ownerCt.ownerCt.close();
                }
            }]
        });

	    this.items = [this.formArea];

        Ext.hui.desktopwindow.provider.UIConfig.superclass.initComponent.call(this);
	},
    listeners: {
//        'afterRender': function() {
//            Ext.each(Ext.getCmp('rbGroupTheme').items.items,function(rad,rIndex) {
//                if (rad.inputValue == Ext.hui.session.theme){
//                    Ext.getCmp(rad.id).setValue(true);
//                }
//            });
//        }
    }
});

Ext.reg('prov_config_window', Ext.hui.desktopwindow.provider.UIConfig);