/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Radiology Report Window
 * @param {} config Class configuration object
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg recordDetailsToken
 * 		Record security token
 */
Ext.hui.desktopwindow.patient.RadiologyReport = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
    initComponent: function() {
		if (!this.title || this.title.length < 0)
        {
            this.title = "Radiology Report";
        }
	    this.width = 700;
        this.height = 500;
        this.cls = "radiology-report";
        this.autoScroll = true;

        this.on('afterrender', function(){this.fetchData()}, this);

        this.addTool({
            id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, window){
				if (window) {
                    Ext.hui.common.copyWindow(window);
				}
			}
        });
        this.addTool({
            id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, window){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (window) {
					Ext.ux.Printer.printPatInfo(window);
				}
			}
        });
	    Ext.hui.desktopwindow.patient.RadiologyReport.superclass.initComponent.call(this);
	},

	fetchData: function()
	{
		this.getUpdater().setRenderer(new Ext.hui.desktopwindow.patient.RadiologyReportRenderer(this));
		this.load({
			url: 'rest/patientRadiologyReport.json',
			method:'GET',
			params: {patToken:this.patientToken, recToken:this.recordDetailsToken},
			discardUrl: true,
		    nocache: true,
            disableCaching:true,
		    text: 'Loading...',
		    timeout:Ext.hui.common.CONNECTION_TIMEOUT_SECONDS,
		    scripts: false,
		    scope:this,
	    	callback:function(options, isSuccess, response)
			{
				if (!isSuccess)
				{
					Ext.hui.common.handleNetworkFailure(response.status, this);
				}
			}
		});
	}
});

Ext.reg('radiologyreport_window', Ext.hui.desktopwindow.patient.RadiologyReport);

/**
 * Radiology report renderer, parses json response and sends it to the widgets initLayout function.
 */
Ext.hui.desktopwindow.patient.RadiologyReportRenderer = function(window)
{
	this.window = window;
	Ext.hui.desktopwindow.patient.RadiologyReportRenderer.superclass.constructor.call(this);
}

Ext.extend(Ext.hui.desktopwindow.patient.RadiologyReportRenderer, Ext.Updater.BasicRenderer,
{
    render: function(el, xhr, updateManager, callback)
	{
		if (!this.window || this.window.isDestroy) return;

        var jsonResponse = Ext.util.JSON.decode(xhr.responseText);
		el.dom.innerHTML = "";

		var tpl = "";
        if (jsonResponse.plainTextReport)
        {
            tpl = new Ext.XTemplate
            (
                '<pre class="plain-text">',
                    '{reportText}',
                '</pre>'

            );
        }
        else
        {
            tpl = new Ext.XTemplate
            (
                '<table class="radiology-report" width="100%" border="0">',
                    '<tr>',
                        '<td class="rad-header">Priority:</td>',
                        '<td>{priority}</td>',
                        '<td>&nbsp;</td>',
                        '<td class="rad-header">Exam Number:</td>',
                        '<td>{accessionNumber}</td>',
                    '</tr>',
                    '<tr>',
                        '<td class="rad-header">Procedure:</td>',
                        '<td>{procedure}</td>',
                        '<td>&nbsp;</td>',
                        '<td class="rad-header">Exam Date:</td>',
                        '<td>{examDate}</td>',
                    '</tr>',
                    '<tr>',
                        '<td class="rad-header">Result Code:</td>',
                        '<td>{resultCode}</td>',
                        '<td>&nbsp;</td>',
                        '<td class="rad-header">Report Status:</td>',
                        '<td>{reportStatus}</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5" style="height:5px;">&nbsp;</td>',
                    '</tr>',
                    '<tr>',
                        '<td class="rad-header" colspan="5">Reason for Order:</td>',
                  '</tr>',
                  '<tr>',
                        '<td colspan="5">{orderReason}</td>',
                  '</tr>',
                   '<tr>',
                       '<td colspan="5" style="height:5px;">&nbsp;</td>',
                   '</tr>',
                   '<tr>',
                        '<td class="rad-header" colspan="5">Impression:</td>',
                   '</tr>',
                   '<tr>',
                        '<td colspan="5">{impressionText}</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5" style="height:5px;">&nbsp;</td>',
                    '</tr>',
                    '<tr>',
                        '<td class="rad-header" colspan="5">Report:</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5">{reportText}</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5" style="height:5px;">&nbsp;</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5">',
                            '<span class="rad-header">Transcription D/T:</span>',
                            '&nbsp;',
                            '<span>{transcribeDate}</span>',
                        '</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5">',
                            '<span class="rad-header">Interpreted by:</span>',
                            '&nbsp;',
                            '<span>{interpretingHCP}</span>',
                        '</td>',
                    '</tr>',
                    '<tr>',
                        '<td colspan="5">',
                            '<span class="rad-header">Approved by:</span>',
                            '&nbsp;',
                            '<span>{approvingHCP}</span>',
                        '</td>',
                    '</tr>',
                '</table>'
            );
        }

        var html = tpl.apply(jsonResponse);
        this.window.body.dom.innerHTML = html;
        this.window.doLayout();
	}
});
