/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Progress Note details.
 * @param {} config Class configuration object
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg recordDetailsToken
 * 		Record security token
 */
Ext.hui.desktopwindow.patient.ProgressNoteDetails = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {
		if (!this.title || this.title.length < 0)
        {
            this.title = "Progress Note Details";
        }
	    this.width = 700;
        this.height = 500;
        this.autoScroll = true;

        this.tools =
	    [
            {
                id: 'copy',
                qtip: 'Copy to Clipboard',
                cls: 'x-tool-copy',
                overCls:'x-tool-copy-over',
                handler: function (event,toolEl, window){
                    if (window) {
                        Ext.hui.common.copyPre(window);
                    }
                }
            },
            {
                id: 'print',
                qtip: 'Print',
                handler: function (event,toolEl, window){
                    Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
                    if (window) {
                        Ext.ux.Printer.printPatInfo(window);
                    }
                }
            }
		];

        this.on('afterrender', function(){this.fetchData()}, this);

	    Ext.hui.desktopwindow.patient.ProgressNoteDetails.superclass.initComponent.call(this);
	},

	fetchData: function()
	{
		this.getUpdater().setRenderer(new Ext.hui.desktopwindow.patient.ProgressNoteDetailsRenderer(this));
		this.load({
			url: 'rest/patientProgressNoteDetails.json',
			method:'GET',
			params: {patToken:this.patientToken, recToken:this.recordDetailsToken},
			discardUrl: true,
		    nocache: true,
            disableCaching:true,
		    text: 'Loading...',
		    timeout:Ext.hui.common.CONNECTION_TIMEOUT_SECONDS,
		    scripts: false,
		    scope:this,
	    	callback:function(options, isSuccess, response)
			{
				if (!isSuccess)
				{
					Ext.hui.common.handleNetworkFailure(response.status, this);
				}
			}
		});
	}

});

Ext.reg('progressnotedetails_window', Ext.hui.desktopwindow.patient.ProgressNoteDetails);

/**
 * Problem details renderer, parses json response and sends it to the widgets initLayout function.
 */
Ext.hui.desktopwindow.patient.ProgressNoteDetailsRenderer = function(window)
{
	this.window = window;
	Ext.hui.desktopwindow.patient.ProgressNoteDetailsRenderer.superclass.constructor.call(this);
}

Ext.extend(Ext.hui.desktopwindow.patient.ProgressNoteDetailsRenderer, Ext.Updater.BasicRenderer,
{
	render: function(el, xhr, updateManager, callback)
	{
		if (!this.window || this.window.isDestroy) return;

        var jsonResponse = Ext.util.JSON.decode(xhr.responseText);
		el.dom.innerHTML = "";

		var tpl = new Ext.XTemplate
        (
            '<pre class="report-details">',
                '{noteText}',
                '{images}',
            '</pre>'

        );
        var html = tpl.apply(jsonResponse);
        this.window.body.dom.innerHTML = html;
        this.window.doLayout();
	}
});
