/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Problem Details Window
 * @param {} config Class configuration object
 * 
 * @cfg patientToken
 *     Patient's security token
 * @cfg recordDetailsToken
 * 		Record security token
 */
Ext.hui.desktopwindow.patient.ProblemDetails = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
    initComponent: function() {
		if (!this.title || this.title.length < 0)
        {
            this.title = "Problem Details";
        }
	    this.width = 500;
        this.height = 400;
        this.cls = "problemdetails";
        this.autoScroll = true;

        this.on('afterrender', function(){this.fetchData()}, this);

        this.addTool({
            id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, window){
				if (window) {
                    Ext.hui.common.copyWindow(window);
				}
			}
        });
        this.addTool({
            id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, window){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (window) {
					Ext.ux.Printer.printPatInfo(window);
				}
			}
        });
	    Ext.hui.desktopwindow.patient.ProblemDetails.superclass.initComponent.call(this);
	},
	
	fetchData: function()
	{
		this.getUpdater().setRenderer(new Ext.hui.desktopwindow.patient.ProblemDetailsRenderer(this));
		this.load({
			url: 'rest/patientProblemDetails.json',
			method:'GET',
			params: {patToken:this.patientToken, recToken:this.recordDetailsToken},
			discardUrl: true,
		    nocache: true,
            disableCaching:true,
		    text: 'Loading...',
		    timeout:Ext.hui.common.CONNECTION_TIMEOUT_SECONDS,
		    scripts: false,
		    scope:this,
	    	callback:function(options, isSuccess, response)
			{
				if (!isSuccess)
				{
					Ext.hui.common.handleNetworkFailure(response.status, this);
				}	    
			}
		});
	}
});

Ext.reg('problemdetails_window', Ext.hui.desktopwindow.patient.ProblemDetails);

/**
 * Problem details renderer, parses json response and sends it to the widgets initLayout function.
 */
Ext.hui.desktopwindow.patient.ProblemDetailsRenderer = function(window)
{
	this.window = window;
	Ext.hui.desktopwindow.patient.ProblemDetailsRenderer.superclass.constructor.call(this); 
}

Ext.extend(Ext.hui.desktopwindow.patient.ProblemDetailsRenderer, Ext.Updater.BasicRenderer,
{
    render: function(el, xhr, updateManager, callback)
	{
		if (!this.window || this.window.isDestroy) return;

        var jsonResponse = Ext.util.JSON.decode(xhr.responseText);
		el.dom.innerHTML = "";
		
		var tpl = new Ext.XTemplate
        (
            '<div class="title">{description}</div>',
            '<table align="center" class="problemdetails">',
                '<tr>',
                    '<td align="right">Onset Date:</td>',
                    '<td align="left">{onsetDate}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Status:</td>',
                    '<td align="left">{status}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Provider:</td>',
                    '<td align="left">{responsibleProvider}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Clinic:</td>',
                    '<td align="left">{hospitalLocation}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Recorded Date:</td>',
                    '<td align="left">{recordedDate:date("M d, Y")}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Recorded By:</td>',
                    '<td align="left">{recordedBy}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Entered Date:</td>',
                    '<td align="left">{enteredDate:date("M d, Y")}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Entered By:</td>',
                    '<td align="left">{enteredBy}</td>',
                '</tr>',
                '<tr>',
                    '<td align="right">Modified Date:</td>',
                    '<td align="left">{lastUpdated:date("M d, Y")}</td>',
                '</tr>',
            '</table>',
            '<div class="title">Comments</div>',
            '<tpl for="notes">',
            '<table align="center" class="problemdetails">',
                '<tr>',
                    '<td align="left">{noteText}</td>',
                '</tr>',
                '<tr>',
                    '<td align="left">Entered By: {noteEnteredBy} on {noteDate:date("M d, Y")}</td>',
                '</tr>',
            '</table>',
            '</tpl>'

        );
        var html = tpl.apply(jsonResponse);
        this.window.body.dom.innerHTML = html;
        this.window.doLayout();
	}
});
