/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Outpatient Medications Window
 * @param {} config Class configuration object
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg recordDetailsToken
 *      Record security token
 */
Ext.hui.desktopwindow.patient.PrescriptionFills = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {

        this.dataStore = new Ext.data.Store({
            restful:true,
            proxy: new Ext.data.HttpProxy({
                url: 'rest/patientPrescriptionFills.json',
                disableCaching:true,
                timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
                method:'GET'
            }),
            baseParams:{
                patToken:this.patientToken,
                recToken:this.recordDetailsToken
            },

            reader: new Ext.data.JsonReader({
                root: ''
            },
            [
                {name: 'drugName'},
                {name: 'fillOrderDate', type:'date'},
                {name: 'quantity'},
                {name: 'daysSupply'},
                {name: 'dispensingPharmacy'},
                {name: 'expirationDate', type:'date'},
                {name: 'siteCode'},
                {name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}

            ]),
            sortInfo: {
                field: 'fillOrderDate',
                direction: 'DESC'
            },
            listeners:
            {
                exception:{
                    scope:this,
                    fn:function(dataProxy, type, action, options, response, arg){
                        Ext.hui.common.handleNetworkFailure(response.status, this);
                    }
                }
            },
            autoLoad: true
        });

        var dateRenderer = Ext.util.Format.dateRenderer('M d, Y');

        this.gridPanel = new Ext.grid.GridPanel({
                store: this.dataStore,
                columns: [
                    {
                        width    : 100,
                        header   : 'Fill Date',
                        sortable : true,
                        dataIndex: 'fillOrderDate',
                        renderer: dateRenderer
                    },
                    {
                        id: 'drugName',
                        width    : 200,
                        header   : 'Drug',
                        sortable : true,
                        dataIndex : 'drugName'
                    },
                    {
                        width    : 100,
                        header   : 'Quantity',
                        sortable : true,
                        dataIndex: 'quantity'
                    },
                    {
                        width    : 100,
                        header   : 'Days Supply',
                        sortable : true,
                        dataIndex: 'daysSupply'
                    },
                    {
                        width    : 100,
                        header   : 'Fill Expiration',
                        sortable : true,
                        dataIndex: 'expirationDate',
                        renderer: dateRenderer
                    },
                    {
                        width:200,
                        header : 'Dispensing Pharmacy',
                        sortable:true,
                        dataIndex: 'dispensingPharmacy'
                    },
                    {
                        width:100,
                        header : 'Sig',
                        sortable:true,
                        renderer :{
                            fn:function(value, metaData, record, rowIndex, colIndex, store) {
                                if (this.sig)
                                {
                                    return this.sig
                                }
                                else return "";

                            },
                            scope:this
                        }
                    }
                ],

            selModel: new Ext.grid.CellSelectionModel(),
                stripeRows: true,
                border:true,
                bodyBorder:true,
                loadMask:true,
                layout:'fit',
                columnLines:true,
                viewConfig: {
                    emptyText:"No results",
                    forceFit:true
                }
        });

        if (!this.title || this.title.length < 1)
        {
            this.title='Outpatient Medication Details';
        }
        this.width = 800;
        this.height = 350;
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;
        this.layout = 'fit';
        this.dataStore = this.dataStore;
	    this.tools =
	    [{
			id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
                    Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
			{
				    id:'refresh',
				    qtip: 'Refresh',
				    handler: function(event, toolEl, win){
				        win.dataStore.reload();
				    }
				}
		];

	    this.items = [this.gridPanel];

	    Ext.hui.desktopwindow.patient.PrescriptionFills.superclass.initComponent.call(this);
	}
});
Ext.reg('prescriptionfills_window', Ext.hui.desktopwindow.patient.PrescriptionFills);