/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Demographic Details Desktop Window
 * 
 * @param {} config Class Configuration object.
 * 
 * @cfg patientToken
 *     Patient's security token
 */
Ext.hui.desktopwindow.patient.PatientDemographicDetails = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {
		tabPanel = new Ext.TabPanel({
	        activeTab: 0,
	        bodyBorder:false,
	        border:false,
	        tabPosition:'top',
			enableTabScroll:true
		});
		
		this.title='Patient Demographics';
        this.width = 850;
        this.height = 500;
        this.iconCls = 'icon-search';
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;
        this.layout = 'fit';
	    this.items = [tabPanel];
	    
	    this.on('afterrender', function(){this.fetchData(tabPanel)}, this);

        this.addTool({
            id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, window){
				if (window) {
                    Ext.hui.common.copyWindow(window);
				}
			}
        });
        this.addTool({
            id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, window){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (window) {
					Ext.ux.Printer.printPatInfo(window);
				}
			}
        });
		Ext.hui.desktopwindow.patient.PatientDemographicDetails.superclass.initComponent.call(this);
	},
	
	fetchData: function(tabPanel)
	{
		tabPanel.getUpdater().setRenderer(new Ext.hui.desktopwindow.patient.DemographicDetailsRenderer(this.initLayout, tabPanel));
		tabPanel.load({
			url: 'rest/patientDemographicDetails.json',
			method:'GET',
			params: {patToken:this.patientToken},
			discardUrl: true,
		    nocache: true,
            disableCaching:true,
		    text: 'Loading...',
		    timeout:Ext.hui.common.CONNECTION_TIMEOUT_SECONDS,
		    scripts: false,
		    scope:this,
	    	callback:function(options, isSuccess, response)
			{
				if (!isSuccess)
				{
					Ext.hui.common.handleNetworkFailure(response.status, this);
				}	    
			}
		});
	}
});

/**
 * Demographic details Renderer, parses json response and handles layout.
 * 
 */
Ext.hui.desktopwindow.patient.DemographicDetailsRenderer = function(layoutFunction, tabPanel)
{
	this.layoutFunction = layoutFunction;
	this.tabPanel = tabPanel;
	Ext.hui.desktopwindow.patient.DemographicDetailsRenderer.superclass.constructor.call(this); 
}

Ext.extend(Ext.hui.desktopwindow.patient.DemographicDetailsRenderer, Ext.Updater.BasicRenderer,
{
	render: function(el, xhr, updateManager, callback)
	{
		if (!this.tabPanel || this.tabPanel.isDestroy) return;
		var reader = 
			new Ext.data.JsonReader({
	            root: ''
	        }, 
	        [
	        	{name: 'report'},
                {name: 'siteName'},
				{name: 'siteCode'},
				{name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
	        ]);
		var jsonResponse = reader.read(xhr);
		el.dom.innerHTML = "";
		var records = jsonResponse.records;
		
		if (this.tabPanel)
	    {
			for(var i = 0; i < records.length; i++)
			{
				var tpl = new Ext.XTemplate
				(
					'<pre class="details">',
						'{report}',
					'</pre>'
				);

				var data = records[i].data;
				var panel = new Ext.Panel({
						title:Ext.hui.common.formatSiteMonikerDisplay(data.siteAgency, data.siteMoniker),
                        tabTip:data.siteName,
						autoScroll:true,
						cls:"demographics"
					});
				data.panelId = panel.id;
				var html = tpl.apply(data);
				panel.html = html;

				this.tabPanel.add(panel);
			}
			this.tabPanel.setActiveTab(0);
			this.tabPanel.doLayout();
	    }
	}
});
