/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Lab Report Window
 * @param {} config Class configuration object
 *
 * @cfg patientToken
 *     Patient's security token
 * @cfg recordDetailsToken
 * 		Record security token
 */
Ext.hui.desktopwindow.patient.LabReport = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
    initComponent: function() {
		if (!this.title || this.title.length < 0)
        {
            this.title = "Lab Results";
        }
	    this.width = 900;
        this.height = 500;
        this.cls = "labreport";
        this.autoScroll = true;

        this.on('afterrender', function(){this.fetchData()}, this);

        this.addTool({
            id: 'copy',
			qtip: 'Copy to Clipboard',
            cls: 'x-tool-copy',
            overCls:'x-tool-copy-over',
			handler: function (event,toolEl, window){
				if (window) {
                    Ext.hui.common.copyWindow(window);
				}
			}
        });
        this.addTool({
            id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, window){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (window) {
					Ext.ux.Printer.printPatInfo(window);
				}
			}
        });
	    Ext.hui.desktopwindow.patient.LabReport.superclass.initComponent.call(this);
	},

	fetchData: function()
	{
		this.getUpdater().setRenderer(new Ext.hui.desktopwindow.patient.LabReportRenderer(this));
		this.load({
			url: 'rest/patientLabResults.json',
			method:'GET',
			params: {patToken:this.patientToken, recToken:this.recordDetailsToken},
			discardUrl: true,
		    nocache: true,
            disableCaching:true,
		    text: 'Loading...',
		    timeout:Ext.hui.common.CONNECTION_TIMEOUT_SECONDS,
		    scripts: false,
		    scope:this,
	    	callback:function(options, isSuccess, response)
			{
				if (!isSuccess)
				{
					Ext.hui.common.handleNetworkFailure(response.status, this);
				}
			}
		});
    }
});

Ext.reg('labreport_window', Ext.hui.desktopwindow.patient.LabReport);

/**
 * Problem details renderer, parses json response and sends it to the widgets initLayout function.
 */
Ext.hui.desktopwindow.patient.LabReportRenderer = function(window)
{
	this.window = window;
	Ext.hui.desktopwindow.patient.LabReportRenderer.superclass.constructor.call(this);
}

Ext.extend(Ext.hui.desktopwindow.patient.LabReportRenderer, Ext.Updater.BasicRenderer,
{
    render: function(el, xhr, updateManager, callback)
	{
		if (!this.window || this.window.isDestroy) return;

        var jsonResponse = Ext.util.JSON.decode(xhr.responseText);
		el.dom.innerHTML = "";
        var html = "";
        if (jsonResponse.length < 1)
        {
            html = "No lab results found.";
        }
        else
        {
            var data = jsonResponse[0];
            var tpl = new Ext.XTemplate
            (
                '<table width="100%" border="0">',
                    '<tr>',
                        '<td><span class="report-header">Test:</span>&nbsp;{testName}</td>',
                        '<td><span class="report-header">Specimen:</span>&nbsp;{specimen}</td>',
                        '<td colspan="2"><span class="report-header">Accession Num:</span>&nbsp;{accession}</td>',
                    '</tr>',

                    '<tpl if="this.isValidStr(resultStatus)">',
                    '<tr>',
                        '<td><span class="report-header">Status:</span>&nbsp;{resultStatus}</td>',
                        '<td colspan="3"><span class="report-header">Date:</span>&nbsp;{resultDate}</td>',
                    '</tr>',
                    '</tpl>',
                    '<tpl if="this.isValidStr(comment)">',
                    '<tr>',
                        '<td><span class="report-header">Comment:</span>&nbsp;{comment}</td>',
                    '</tr>',
                    '</tpl>',
                    '<tpl if="this.isValidStr(result)">',
                    '<tr>',
                        '<td colspan="4" valign="top" class="result-markup">{result}</td>',
                    '</tr>',
                    '</tpl>',
                '</table>',
                {
                    isValidStr: function(str)
                    {
                        return str != null && str.length > 0;
                    }
                }

            );
            html += tpl.apply(data);
	    }

        this.window.body.dom.innerHTML = html;
        this.window.doLayout();
	}
});
