/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Immunizations Window
 * @param {} config Class configuration object
 *
 * @cfg patientToken
 *     Patient's security token
 */
Ext.hui.desktopwindow.patient.Immunizations = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {

		this.sortInfo =  {
            field: 'adminDate',
            direction: 'DESC'
        };

        this.dataStore = new Ext.data.Store({
			restful:true,
			proxy: new Ext.data.HttpProxy({
						url: 'rest/patientImmunizations.json',
						disableCaching:true,
						method:'GET',
                        timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS
	    			}),
            baseParams:
            {
                patToken:this.patientToken
            },
	        reader: this.createJsonReader(),

	        sortInfo: this.sortInfo,
			listeners:
			{
				exception:
				{
					scope:this, fn:function(dataProxy, type, action, options, response, arg){
												Ext.hui.common.handleNetworkFailure(response.status, this);
											}},
                beforeLoad:
                {
                    scope:this,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading = new Ext.LoadMask(this.gridArea.el, {msg:"Loading...", store:this.dataStore});
                        this.loading.show();
                        if (this.filter) this.filter.disable();
                    }
                },
				load:{scope:this, fn:function(store, records, options)
					{
			    		if (!this || this.isDestroy) return;
                        if (this.filter)
                        {
                            this.filter.enable();
                            this.filter.loadWithData();
                        }
                        this.setTitle("Immunizations ("+records.length+")");

                }},
                datachanged:
                {
                    scope:this,
                    fn:function(store)
                    {
                        if (!this || this.isDestroy) return;
                        this.tableExpandToggleText = Ext.hui.common.EXPAND_TABLE_TEXT;

                        var recs = store.getRange();
                        var jsonDt = [];
                        for(var i = 0; i < recs.length; i++)
                        {
                            jsonDt[i] = recs[i].json;
                        }

                        var inMemoryStore = new Ext.data.Store({
                            proxy: new Ext.ux.data.PagingMemoryProxy(jsonDt),
                            remoteSort:true,
                            reader: this.createJsonReader(),
                            sortInfo: this.sortInfo
                        });

                        //destroy previous grid panel
                        if (this.gridPanel)
                        {
                            this.gridPanel.destroy();
                        }
                        this.gridPanel = this.createGrid(inMemoryStore, this, Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE);
                        inMemoryStore.load({params:{start:0, limit:Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE}});

                        this.gridArea.removeAll();
                        this.gridArea.add(this.gridPanel);
                        this.doLayout();
                        if (this.filter) this.filter.displayFilter(true);
                    }
                }
			},
	        autoLoad: true
	    });

        this.filter = new Ext.hui.filter.ImmunizationFilter({
            region:'north',
            dataStore:this.dataStore,
            disabled:true,
            hidden:true
        });



	    this.title='Immunizations';
        this.width = 600;
        this.height = 450;
        this.iconCls = 'icon-grid';
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;
        this.layout = "border";
        this.dataStore = this.dataStore;
	    this.tools =
	    [
            {
                id: 'filter',
                qtip: 'Configure Filter',
                cls: 'x-tool-filter',
                overCls:'x-tool-filter-over',
                handler: function (event,toolEl, panel){
                    if (panel.filter) {
                        panel.filter.toggleView();
                    }
                }
            },
            {
                id: 'copy',
                qtip: 'Copy to Clipboard',
                handler: function (event,toolEl, panel){
                    if (panel.gridPanel) {
                        Ext.hui.common.copyGridPanel(panel.gridPanel);
                    }
                }
            },
            {
                id: 'print',
                qtip: 'Print',
                handler: function (event,toolEl, panel){
                    Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
                    if (panel.gridPanel) {
                        Ext.ux.Printer.printPatInfo(panel.gridPanel);
                    }
                }
            },
            {
                    id:'refresh',
                    qtip: 'Refresh',
                    handler: function(event, toolEl, win){
                        win.dataStore.reload();
                    }
            }
		];

        this.gridArea = new Ext.Container({layout:'fit', region:'center', html:''});
	    this.items = [this.filter, this.gridArea];

	    Ext.hui.desktopwindow.patient.Immunizations.superclass.initComponent.call(this);
	},
    createJsonReader: function()
    {
        return new Ext.data.JsonReader({
	            root: ''
	        },
	        [
				{name: 'vaccine'},
				{name: 'adminDate', type:'date'},
				{name: 'series'},
                {name: 'reaction'},
				{name: 'siteCode'},
				{name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
	        ]);
    },
    createGrid: function(gridDataStore, refWin, recordsPerPage)
    {
        var dateRenderer = Ext.util.Format.dateRenderer('M d, Y');

		return new Ext.grid.GridPanel({
	        store: gridDataStore,
	        columns: [
	            {
	                header   : 'Site',
	                width    : 50,
	                sortable : true,
	                dataIndex: 'siteMoniker',
	                renderer :
	                        function(value, metaData, record, rowIndex, colIndex, store) {
	                            return Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker);
	                        }
	            },
	        	{
	                id       :'adminDate',
                    width    : 100,
	                header   : 'Admin Date',
	                sortable : true,
	                dataIndex: 'adminDate',
                    renderer: dateRenderer
	            },
                {
	                id       :'vaccine',
	                header   : 'Vaccine',
	                width: 200,
	                sortable : true,
	                dataIndex: 'vaccine'
	            },
	            {
	                id       :'series',
	                header   : 'Series',
	                sortable : true,
	                dataIndex: 'series'
	            },
	            {
	                id       :'reaction',
	                header   : 'Reaction',
	                sortable : true,
	                dataIndex: 'reaction'
	            }
	        ],
            listeners:{
                viewready:
                {
                    scope:refWin,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        if (this.filter) this.filter.enable();
                        this.loading.hide();
                    }
                }
	        },
            selModel: new Ext.grid.CellSelectionModel(),
	        stripeRows: true,
	        autoExpandColumn:'vaccine',
	        loadMask:true,
            columnLines:true,
            region: 'center',
            bbar: refWin.createPagingToolbar(gridDataStore, recordsPerPage),
	        viewConfig: {
	        	emptyText:"No results",
                forceFit: true
	        },
	        cls:"patientsearch"
	    });
    }
});
Ext.reg('immunizations_window', Ext.hui.desktopwindow.patient.Immunizations);