/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Allergies Window
 * @param {} config Class configuration object
 * 
 * @cfg patientToken
 *     Patient's security token
 */
Ext.hui.desktopwindow.patient.Allergies = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {
		
		this.sortInfo = {
            field: 'name',
            direction: 'ASC'
        };

        this.bhieSourceReport = null;

        this.dataStore = new Ext.data.Store({
			restful:true,
			proxy: new Ext.data.HttpProxy({
						url: 'rest/patientAllergies.json',
						disableCaching:true,
                        timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
						method:'GET'
	    			}),
            baseParams:
            {
                patToken:this.patientToken
            },
	        reader: this.createJsonReader(),
	        
	        sortInfo: this.sortInfo,
			listeners:
			{
				exception:
				{
					scope:this, fn:function(dataProxy, type, action, options, response, arg){
												Ext.hui.common.handleNetworkFailure(response.status, this);
                }},
                beforeLoad:
                {
                    scope:this,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading = new Ext.LoadMask(this.gridArea.el, {msg:"Loading...", store:this.dataStore});
                        this.loading.show();
                        this.bhieSourceReport = null;
                    }
                },
				load:{scope:this, fn:function(store, records, options)
					{
			    		if (!this || this.isDestroy) return;

                }},
                datachanged:
                {
                    scope:this,
                    fn:function(store)
                    {
                        if (!this || this.isDestroy) return;
                        this.tableExpandToggleText = Ext.hui.common.EXPAND_TABLE_TEXT;

                        var recs = store.getRange();
                        var jsonDt = [];
                        for(var i = 0; i < recs.length; i++)
                        {
                            jsonDt[i] = recs[i].json;
                        }

                        this.setTitle("Allergies ("+jsonDt.length+")");

                        var inMemoryStore = new Ext.data.Store({
                            proxy: new Ext.ux.data.PagingMemoryProxy(jsonDt),
                            remoteSort:true,
                            reader: this.createJsonReader(),
                            sortInfo: this.sortInfo
                        });

                        //destroy previous grid panel
                        if (this.gridPanel)
                        {
                            this.gridPanel.destroy();
                        }
                        this.gridPanel = this.createGrid(inMemoryStore, this, Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE);
                        inMemoryStore.load({params:{start:0, limit:Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE}});

                        this.gridArea.removeAll();
                        this.gridArea.add(this.gridPanel);
                        this.doLayout();
                    }
                }
			},
	        autoLoad: true
	    });
		

	    
	    this.title='Allergies';
        this.width = 600;
        this.height = 450;
        this.iconCls = 'icon-grid';
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;
        this.layout = 'fit';
        this.dataStore = this.dataStore;
	    this.tools = 
	    [
				{
			id: 'copy',
			qtip: 'Copy to Clipboard',
			handler: function (event,toolEl, panel){
				if (panel.gridPanel) {
					Ext.hui.common.copyGridPanel(panel.gridPanel);
				}
			}
		},
		{
			id: 'print',
			qtip: 'Print',
			handler: function (event,toolEl, panel){
				Ext.ux.Printer.BaseRenderer.prototype.stylesheetPath = 'css/print.css';
				if (panel.gridPanel) {
					Ext.ux.Printer.printPatInfo(panel.gridPanel);
				}
			}
		},
			{
				    id:'refresh',
				    qtip: 'Refresh',
				    handler: function(event, toolEl, win){
				        win.dataStore.reload();
				    }
				}
		];

        this.gridArea = new Ext.Container({layout:'fit', region:'center', html:''});
	    this.items = [this.gridArea];
	    
	    Ext.hui.desktopwindow.patient.Allergies.superclass.initComponent.call(this);
	},
    createJsonReader: function()
    {
        return new Ext.data.JsonReader({
	            root: ''
	        },
	        [
				{name: 'name'},
				{name: 'comment'},
				{name: 'severity'},
				{name: 'siteCode'},
				{name: 'siteMoniker'},
                {name: 'siteAgency'},
                {name: 'sourcePlatform'}
	        ]);
    },
    createGrid: function(gridDataStore, refWin, recordsPerPage)
    {
        var toolbarItems = null;

// SB: jMeadows is no longer sending BHIE allergies
//        toolbarItems = [{
//                text: 'BHIE Status',
//                cls: 'more-link',
//                listeners:
//                {
//                    click: function(btn, pressed){
//                        var win = refWin.desktop.createWindow({
//                            title:"BHIE Status ~ Allergies",
//                            width: 600,
//                            height: 500,
//                            autoScroll: true
//                        });
//                        win.show();
//                        var sourceStatus = Ext.hui.app.BHIE_STATUS_NO_REPORT_MSG;
//
//                        if (refWin.bhieSourceReport != null)
//                        {
//                            sourceStatus = refWin.bhieSourceReport;
//                        }
//
//                        win.body.dom.innerHTML = "<div class='bhie-report'>" + sourceStatus + "</div>";
//                    }
//
//                }
//            }];

        var pagingToolbar = refWin.createPagingToolbar(gridDataStore, recordsPerPage, toolbarItems);

        return new Ext.grid.GridPanel({
	        store: gridDataStore,
	        columns: [
	            {
	                header   : 'Site',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'siteMoniker',
	                renderer :
	                        function(value, metaData, record, rowIndex, colIndex, store) {
	                            return Ext.hui.common.formatSiteMonikerDisplay(record.data.siteAgency, record.data.siteMoniker);
	                        }
	            },
	        	{
	                id       :'name',
	                header   : 'Name',
	                width: 200,
	                sortable : true,
	                dataIndex: 'name'
	            },
	            {
	                id       :'comment',
	                header   : 'Comment',
	                width: 200,
	                sortable : true,
	                dataIndex: 'comment'
	            },
	            {
	                id       :'severity',
	                header   : 'Severity',
	                sortable : true,
	                dataIndex: 'severity'
	            }
	        ],
            listeners:{
                viewready:
                {
                    scope:refWin,
                    fn:function()
                    {
                        if (!this || this.isDestroy) return;
                        this.loading.hide();
                    }
                }
	        },
            selModel: new Ext.grid.CellSelectionModel(),
	        stripeRows: true,
	        autoExpandColumn:'name',
	        loadMask:true,
            columnLines:true,
            bbar: pagingToolbar,
	        viewConfig: {
	        	emptyText:"No results",
                forceFit: true
	        },
	        cls:"patientsearch"
	    });
    }
});
Ext.reg('allergies_window', Ext.hui.desktopwindow.patient.Allergies);