/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Patient Add Note Window
 * @param {} config Class configuration object
 * 
 * @cfg patientToken
 *     Patient's security token
 */
Ext.hui.desktopwindow.patient.AddNote = Ext.extend(Ext.hui.desktopwindow.DesktopWindow,
{
	initComponent: function() {

	    this.title='New Note';
        ctCls: 'addNoteWidget';
        this.width = 820;
        this.height = 400;
        this.layout = 'fit';
        this.animCollapse = false;
        this.constrainHeader = true;
        this.draggable = true;


        var titles = [
            ['732', 'ZZTEST DEMO IEHR']
        ];

        var comboStore = new Ext.data.SimpleStore({
                    fields: ['val', 'titleValue'],
                    data : titles
                });

        /*
        this.noteText = new Ext.form.textfield({
                    fieldLabel:'Note Text: ',
                    name: 'noteText',
                    width: 500,
                    height: 300
                });

        this.noteSig = new Ext.form.textfield({
                    fieldLabel:'Sig: ',
                    name: 'noteSig'
                });
                    */
        this.noteForm = new Ext.form.FormPanel({
                    title: 'New Note',
                    id: 'noteForm',
                    header: false,
                    monitorValid:true,
                    items:[
                        new Ext.form.ComboBox({
                            width: 600,
                            allowBlank: false,
                            validateOnBlur: true,
                            store: comboStore,
                            id: 'form_noteTitle',
                            fieldLabel: 'Title',
                            valueField: 'val',
                            displayField:'titleValue',
                            typeAhead: true,
                            mode: 'local',
                            triggerAction: 'all',
                            emptyText:'Select a  note title...'
                        }),
                        new Ext.form.TextArea({
                            id: 'form_noteText',
                            fieldLabel: 'Text',
                            allowBlank: false,
                            validateOnBlur: true,
                            cls: 'noteTextArea',
                            //width: 700,
                            height: 250,
                                autoCreate: {
                                    tag: 'textarea',
                                    cols: 81,
                                    wrap: 'hard'
                                }

                        }),
                        new Ext.form.TextField({
                            id: 'form_noteSig',
                            fieldLabel: 'Sig',
                            inputType: 'password',
                            allowBlank:false,
                            validateOnBlur: true
                        })
                    ],buttons:[{
                        text: 'Submit',
                        formBind:true,
                        scope:this,
                        ctCls: 'noteButton',
                        handler:
                            function(button, event)
                            {
                                var loadMask = new Ext.LoadMask('noteForm', { msg: "Saving..." });
                                loadMask.show();
                                Ext.Ajax.request({
                                    url: 'rest/addNote',
                                    loadMask: true,
                                    params: {
                                        patToken: this.patientToken,
                                        noteTitleId: Ext.getCmp('form_noteTitle').value,
                                        noteText: Ext.getCmp('form_noteText').el.getValue(),
                                        noteSig: Ext.getCmp('form_noteSig').el.getValue(),
                                        noteClinicId: this.clinicId
                                    },
                                    form: 'noteForm',
                                    disableCaching:true,
                                    method: 'POST',
                                    timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS,
                                    success : function(response){
                                        loadMask.hide();
                                        //alert("Success: " + response.responseText);
                                        Ext.Msg.alert(
                                            "Add Note Successful",
                                            response.responseText
                                        );
                                        Ext.getCmp('noteForm').ownerCt.close();
                                    },//success
                                    failure : function(response){
                                        loadMask.hide();
                                        Ext.Msg.alert(
                                                "Add Note Failure",
                                                "Error Detected: " + response.responseText
                                        );
                                    }//failure


                                });
                            }
                    }]
                });

        this.items = [this.noteForm];
	    
	    Ext.hui.desktopwindow.patient.AddNote.superclass.initComponent.call(this);
	}
});
Ext.reg('AddNote_window', Ext.hui.desktopwindow.patient.AddNote);