
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Abstract Desktop Window class, extends Window
 * 
 * @param {} config
 */
Ext.hui.desktopwindow.DesktopWindow = Ext.extend(Ext.Window,
{
	cls: 'x-portlet',

    //window components
    gridArea:null,
    gridPanel:null,
    filter:null,

    dataStore:null,
    loading:null,
    sortInfo:null,

    showErrorMsg: function(errorMsg)
	{
		if (!this || this.isDestroy) return;

        var errorMsgCont = new Ext.Container({region:"center", html:"<span class='error-message'>"+errorMsg+"</span>"});
        if (this.gridArea)
        {
            this.gridArea.removeAll();
            this.gridArea.add(errorMsgCont);
        }
        else this.add(errorMsgCont);

		this.doLayout();
	},
    destroy: function()
    {
        this.isDestroy = true;

        if (this.gridPanel)
        {
            this.gridPanel.destroy();
            this.gridPanel = null;
        }

        if (this.dataStore)
        {
            this.dataStore.destroy();
            this.dataStore = null;
        }

        if (this.gridArea)
        {
            this.gridArea.destroy();
            this.gridArea = null;
        }

        Ext.hui.widget.Widget.superclass.destroy.call(this);
    },
    createPagingToolbar: function(gridDataStore, recordsPerPage, toolbarItems)
    {
        var items = [];
        //do not show expand button if number of records is less than paging amount
        //if in expanded mode, we always want to show collapse button
        if (recordsPerPage < this.dataStore.getTotalCount() ||
            this.tableExpandToggleText == Ext.hui.common.COLLAPSE_TABLE_TEXT)
        {
            items = [
                    {
                        text: this.tableExpandToggleText,
                        cls: 'more-link',
                        listeners:
                        {
                            scope:this,
                            click: function(btn, pressed){

                                var recs = this.dataStore.getRange();

                                if (this.filter) this.filter.disable();

                                if (this.tableExpandToggleText == Ext.hui.common.EXPAND_TABLE_TEXT)
                                {
                                    this.tableExpandToggleText = Ext.hui.common.COLLAPSE_TABLE_TEXT;
                                }
                                else this.tableExpandToggleText = Ext.hui.common.EXPAND_TABLE_TEXT;

                                var newRecordsPerPage = this.dataStore.getTotalCount();
                                if (recordsPerPage == newRecordsPerPage)
                                {
                                    newRecordsPerPage = Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE;
                                }

                                var jsonDt = [];
                                for(var i = 0; i < recs.length; i++)
                                {
                                    jsonDt[i] = recs[i].json;
                                }

                                var memStoreConfig = {
                                    proxy: new Ext.ux.data.PagingMemoryProxy(jsonDt),
                                    remoteSort:true,
                                    reader: this.createJsonReader(),
                                    listeners:
                                    {
                                        load:
                                        {
                                            scope:this,
                                            fn:function()
                                            {
                                                this.gridArea.add(this.gridPanel);
                                                this.doLayout();
                                            }
                                        }
                                    }
                                };

                                var sortInfo = this.sortInfo;

                                if (sortInfo)
                                {
                                    memStoreConfig.sortInfo = sortInfo;
                                }

                                var inMemoryStore = new Ext.data.Store(memStoreConfig);

                                if (newRecordsPerPage == this.dataStore.getTotalCount())
                                {
                                    this.loading.show();
                                }

                                this.gridArea.removeAll();
                                this.gridPanel.destroy();
                                this.gridPanel = this.createGrid(inMemoryStore, this, newRecordsPerPage, this.tableExpandToggleText);

                                inMemoryStore.load({params:{start:0, limit:newRecordsPerPage}});
                            }
                        }
                }];
        }

        if (toolbarItems != null && toolbarItems != undefined)
        {
            items.push(toolbarItems);
        }

        return new Ext.PagingToolbar({
                    pageSize: recordsPerPage,
                    store: gridDataStore,
                    displayInfo: true,
                    items:items
        });
    }
});

Ext.reg('desktopwindow', Ext.hui.desktopwindow.DesktopWindow);
