/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.hui.desktop.WidgetMenu = function(config){
	Ext.hui.desktop.WidgetMenu.superclass.constructor.call(this, config);
	this.collapsed = true;	
}

Ext.extend(Ext.hui.desktop.WidgetMenu, Ext.Container, {
    frame : true,
    renderTo: 'ux-widgetMenu',
    enableTabbing: true,
    autoscroll: true,
    cls : 'widgetMenu',
    title: 'Widgets',
    layout: 'anchor',
 	defaultType: 'widgetIcon',
    initComponent: function() {
		Ext.apply(this, { 
            items : [
	            {	            	
	            	widgetId: 'problemlist_widget',
		            html: 'Problem List',
		            cls: 'widgetIcon',
                    hidden: true,
		            widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
	            {
	            	widgetId: 'allergies_widget',
	                html: 'Allergies',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'outpatientmedications_widget',
	                html: 'Outpatient Medications',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'inpatientmedications_widget',
	                html: 'Inpatient Medications',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'immunizations_widget',
	                html: 'Immunizations',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'outpatientnotes_widget',
	                html: 'Progress Notes',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'inpatientnotes_widget',
	                html: 'Discharge / Essentris <br/> Notes',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'consults_widget',
	                html: 'Consults',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'admissions_widget',
	                html: 'Admissions',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'appointments_widget',
	                html: 'Appointments',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_consultsreceived_widget',
	                html: 'Consults Received',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_consultsrequested_widget',
	                html: 'Consults Requested',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_appointments_widget',
	                html: 'Appointments',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_admissions_widget',
	                html: 'Admissions',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_references_widget',
	                html: 'References',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_orderspending_widget',
	                html: 'Orders Pending',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_ordersresulted_widget',
	                html: 'Orders Resulted',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_unsignednotes_widget',
	                html: 'Unsigned Notes',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'prov_lababnormalresults_widget',
	                html: 'Abnormal Lab Results',
	                cls: 'widgetIcon',
                    hidden: false,
	                widgetGroup: Ext.hui.desktop.PORTAL_PROVIDER,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'radiologyexams_widget',
	                html: 'Radiology Exams',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'labs_widget',
	                html: 'Labs',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'clinicalreminders_widget',
	                html: 'Clinical Reminders',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'orders_widget',
	                html: 'Orders',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            },
                {
	            	widgetId: 'vitals_widget',
	                html: 'Vitals',
	                cls: 'widgetIcon',
                    hidden: true,
	                widgetGroup: Ext.hui.desktop.PORTAL_PATIENT,
		            image: 'images/widgetIcons/widgetIcon.png'
	            }
    		] 
        });
       
        Ext.hui.desktop.WidgetMenu.superclass.initComponent.call(this); 
		Ext.EventManager.onWindowResize(this.collapse);
	},
	collapse: function(){
		//var distance = Ext.lib.Dom.getViewHeight() - Ext.get('ux-widgetMenu').getTop();
		//Ext.get('ux-widgetMenu').move('down', distance, {duration: .5, easing: 'easeBoth'});
        var distance = Ext.lib.Dom.getViewHeight();
        Ext.get('ux-widgetMenu').moveTo(0, distance, {duration: .5, easing: 'easeBoth'});
        this.collapsed = true;
	},
	unCollapse: function(){
		//var distance = Ext.get('ux-widgetMenu').getHeight()-(Ext.get('ux-widgetMenu').getTop()-Ext.lib.Dom.getViewHeight());
		//Ext.get('ux-widgetMenu').move('up', distance, {duration: .5, easing: 'easeBoth'});
        var distance = Ext.lib.Dom.getViewHeight()-Ext.get('ux-widgetMenu').getHeight();
        Ext.get('ux-widgetMenu').moveTo(0, distance, {duration: .5, easing: 'easeBoth'});
        this.collapsed = false;

	},
	isCollapsed: function(){
		return this.collapsed;
	}
});


