/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */
 
Ext.hui.desktop.PORTAL_PROVIDER = 0;
Ext.hui.desktop.PORTAL_PATIENT = 1;

Ext.hui.desktop.Desktop = function() {
    this.taskbar = new Ext.hui.desktop.TaskBar();
    this.xTickSize = this.yTickSize = 1;
    var taskbar = this.taskbar;

    var desktopEl = Ext.get('ux-desktop');
    var taskbarEl = Ext.get('ux-taskbar');

    var windows = new Ext.WindowGroup();
    var activeWindow;
	var activePortal;
    
    function minimizeWin(win) {
        win.minimized = true;
        win.hide();
    }

    function markActive(win) {
        if (activeWindow && activeWindow != win) {
            markInactive(activeWindow);
        }
        taskbar.setActiveButton(win.taskButton);
        activeWindow = win;
        Ext.fly(win.taskButton.el).addClass('active-win');
        win.minimized = false;
    }

    function markInactive(win) {
        if (win == activeWindow) {
            activeWindow = null;
            Ext.fly(win.taskButton.el).removeClass('active-win');
        }
    }

    function removeWin(win) {
        taskbar.removeTaskButton(win.taskButton);
        layout();
    }

    this.removeAllWindows = function()
    {   //except UI Config window
    	windows.each(function(win){
            if (win.id != 'UIConfig_window')
    		  win.close();
		});
    }

    function layout() {
        //desktopEl.setHeight(Ext.lib.Dom.getViewHeight() - taskbarEl.getHeight());
        desktopEl.setHeight(Ext.lib.Dom.getViewHeight());
    }
    Ext.EventManager.onWindowResize(layout);

    this.layout = layout;
    
    this.createWindow = function(config, cls) {
        var win = new(cls || Ext.Window)(
        Ext.applyIf(config || {},
        {
            renderTo: desktopEl,
            manager: windows,
            minimizable: true,
            maximizable: true
        })
        );
        win.dd.xTickSize = this.xTickSize;
        win.dd.yTickSize = this.yTickSize;
        if (win.resizer) {
            win.resizer.widthIncrement = this.xTickSize;
            win.resizer.heightIncrement = this.yTickSize;
        }
        win.render(desktopEl);
        win.taskButton = taskbar.addTaskButton(win);

        win.cmenu = new Ext.menu.Menu({
            items: [

            ]
        });

        win.animateTarget = win.taskButton.el;

        win.on({
            'activate': {
                fn: markActive
            },
            'beforeshow': {
                fn: markActive
            },
            'show': {
                fn: function(){
                    if (Ext.a11y && Ext.a11y.Frame){
                        var focItems = this.getFocusItems();
                        var setFocus = function(){
                            if (this.el.query('.x-grid-panel').length == 1){
                                if(Ext.getCmp(this.el.query('.x-grid-panel')[0].id)){
                                    var grid = Ext.getCmp(this.el.query('.x-grid-panel')[0].id);
                                    if(grid.getSelectionModel) {
                                        grid.getView().focusEl.focus()
                                        //Ext.a11y.FocusFrame.frame.defer(20, Ext.a11y.FocusFrame, [grid.fi.el]);
                                        Ext.a11y.FocusFrame.frame.defer(20, Ext.a11y.FocusFrame, [grid.fi.el.select('.x-grid3').elements[0]]);
                                        return;
                                    }
                                }
                            }   else {
                                if (focItems.length > 0) {
                                    focItems.items[0].focus();
                                }
                            }
                        }
                        setFocus.defer(1500,this);
                    }
                }
            },
            'deactivate': {
                fn: markInactive
            },
            'minimize': {
                fn: minimizeWin
            },
            'close': {
                fn: removeWin
            }
        });

        layout();
        return win;
    };

    this.getManager = function() {
        return windows;
    };

    this.getWindow = function(id) {
        return windows.get(id);
    };

    this.getWinWidth = function() {
        var width = Ext.lib.Dom.getViewWidth();
        return width < 200 ? 200: width;
    };

    this.getWinHeight = function() {
        var height = (Ext.lib.Dom.getViewHeight() - taskbarEl.getHeight());
        return height < 100 ? 100: height;
    };

    this.getWinX = function(width) {
        return (Ext.lib.Dom.getViewWidth() - width) / 2;
    };

    this.getWinY = function(height) {
        return (Ext.lib.Dom.getViewHeight() - taskbarEl.getHeight() - height) / 2;
    };

    this.setTickSize = function(xTickSize, yTickSize) {
        this.xTickSize = xTickSize;
        if (arguments.length == 1) {
            this.yTickSize = xTickSize;
        } else {
            this.yTickSize = yTickSize;
        }
        windows.each(function(win) {
            win.dd.xTickSize = this.xTickSize;
            win.dd.yTickSize = this.yTickSize;
            win.resizer.widthIncrement = this.xTickSize;
            win.resizer.heightIncrement = this.yTickSize;
        },
        this);
    };

    this.cascade = function() {
        var x = 0,
        y = 0;
        windows.each(function(win) {
            if (win.isVisible() && !win.maximized) {
                win.setPosition(x, y);
                x += 20;
                y += 20;
            }
        },
        this);
    };

    this.loading = function() {
        windows.each(function(win) {
             win.close();
        },
        this);
    };

    this.tile = function() {
        var availWidth = desktopEl.getWidth(true);
        var x = this.xTickSize;
        var y = this.yTickSize;
        var nextY = y;
        windows.each(function(win) {
            if (win.isVisible() && !win.maximized) {
                var w = win.el.getWidth();

                //              Wrap to next row if we are not at the line start and this Window will go off the end
                if ((x > this.xTickSize) && (x + w > availWidth)) {
                    x = this.xTickSize;
                    y = nextY;
                }

                win.setPosition(x, y);
                x += w + this.xTickSize;
                nextY = Math.max(nextY, y + win.el.getHeight() + this.yTickSize);
            }
        },
        this);
    };

    this.copyText = function() {
        var selectedText = document.selection;
        if (window.clipboardData && clipboardData.setData) {
            if (selectedText.type == 'Text') {
                var newRange = selectedText.createRange();
                clipboardData.setData('text', newRange.text);
            }
        }
    }


    this.contextMenu = new Ext.menu.Menu({
        items: [{
            text: 'Tile',
            handler: this.tile,
            scope: this
        },
        {
            text: 'Cascade',
            handler: this.cascade,
            scope: this
        },
        {
            text: 'Copy',
            handler: this.copyText,
            scope: this
        }]
    });
    desktopEl.on('contextmenu',
        function(e) {
            e.stopEvent();
            this.contextMenu.showAt(e.getXY());
        },
        this);

    layout();
};
