/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

/**
 * Common utility functions
 */


Ext.hui.common.WIDGET_NUM_RECORDS_PER_PAGE = 20;
Ext.hui.common.WINDOW_NUM_RECORDS_PER_PAGE = 20;
Ext.hui.common.EXPAND_TABLE_TEXT = "Expand";
Ext.hui.common.COLLAPSE_TABLE_TEXT = "Collapse";

Ext.hui.common.CONNECTION_TIMEOUT_MS = 300000; //five minutes
Ext.hui.common.CONNECTION_TIMEOUT_SECONDS = 300;
 
Ext.hui.common.formatSiteIconDisplay = function(siteAgency)
{
	if (!siteAgency) return "No site agency";

    var imgTag = "No site agency marker";

    if (siteAgency == Ext.hui.app.AGENCY_VA)
    {
        imgTag = "<img src='images/vaMarker.png' alt=\"VA Marker\" />";
    }
    else if (siteAgency == Ext.hui.app.AGENCY_DOD)
    {
        imgTag = "<img src='images/dodMarker.png' alt=\"DoD Marker\" />";
    }

	return imgTag;
}

Ext.hui.common.formatSiteMonikerDisplay = function(siteAgency, siteMoniker)
{		
	return Ext.hui.common.formatSiteIconDisplay(siteAgency)+"&nbsp;"+siteMoniker;
}

Ext.hui.common.openAuxBrowserWindow = function(URL, windowTitle)
{
    window.open(URL, windowTitle, "toolbar=1,menubar=1,status=1,scrollbars=1,resizable=1");
}

Ext.hui.common.handleNetworkFailure = function(httpStatus, cmp)
{
	//403 access denied usually occurs from session timeout
	if (httpStatus == "403")
	{
		//refresh page - mvc will redirect user to login screen
		location.reload(true);
	}
	else if (cmp)
	{
		//if data store object contains component reference
		if (cmp.showErrorMsg)
		{
			cmp.showErrorMsg("HTTP Status: " + httpStatus +"<br/>An error occurred while requesting data.");	
		}
	}
}
/**
 * Searches for the first occurrence of an obj in a list of objects.
 * @param obj Obj to match.
 * @param objList List of objects
 * @return index of first occurrence, -1 if object could not be found.
 */
Ext.hui.common.searchList = function(str, strList)
{
    for(var i = 0; i < strList.length; i++)
    {
        if (str == strList[i]) return i;
    }

    return -1;
}

Ext.hui.common.formatDateString = function(date)
{
    var month = date.getMonth();
    var day = date.getDate();
    var year = date.getYear();

    if (month.length == 1)
    {
        month = "0"+month;
    }

    if (day.length == 1)
    {
        day = "0"+day;
    }

    return "";
}

Ext.hui.common.copyGridPanel = function(_gridPanel){
    var dataHTML = _gridPanel.body.dom.innerHTML;
    if (window.clipboardData && clipboardData.setData) {
        //remove linebreaks
        dataHTML = dataHTML.replace(/\r\n/gi, "");
        //remove <div>
        dataHTML = dataHTML.replace(/\<div(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/div\>/gi, "");
        dataHTML = dataHTML.replace(/\<pre(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/pre\>/gi, "");
        dataHTML = dataHTML.replace(/\<span(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/span\>/gi, "");
        //strip table tags
        dataHTML = dataHTML.replace(/\<table(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/table\>/gi, "");
        dataHTML = dataHTML.replace(/\<thead(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/thead\>/gi, "");
        dataHTML = dataHTML.replace(/\<tbody(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/tbody\>/gi, "");
        dataHTML = dataHTML.replace(/\<tr(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/tr\>/gi, "\r\n");
        dataHTML = dataHTML.replace(/\<td(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/td\>/gi, "\t");
        dataHTML = dataHTML.replace(/\<th(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/th\>/gi, "\t");
        //strip anchors <a>
        dataHTML = dataHTML.replace(/\<a(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/a\>/gi, "");
        //strip images <img>
        dataHTML = dataHTML.replace(/\<img(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/img\>/gi, "");
        //strip &nbsp;
        dataHTML = dataHTML.replace(/\&nbsp\;/gi, "");
        //strip <br>
        dataHTML = dataHTML.replace(/\<br\>/gi, "\r\n");
        dataHTML = dataHTML.replace(/\<br\/\>/gi, "\r\n");
        //strip <b>
        dataHTML = dataHTML.replace(/\<b(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/b\>/gi, "");
        //strip <strong>
        dataHTML = dataHTML.replace(/\<strong\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/strong\>/gi, "");
        //strip </n>
        dataHTML = dataHTML.replace(/\<\/n\>/gi, "");
        //strip &lt;
        dataHTML = dataHTML.replace(/\&lt\;/gi, "<");
        //strip &gt;
        dataHTML = dataHTML.replace(/\&gt\;/gi, ">");

        clipboardData.setData('text', dataHTML);
    }
}

Ext.hui.common.copyGridPanelActiveMeds = function(panel){

    if (window.clipboardData && clipboardData.setData) {
        var returnData = "Site\tDrug\tSig\r\n";
        Ext.each(panel.dataStore.data.items, function(record, index) {
            if (record.data.active=="ACTIVE") {
                returnData += record.data.siteMoniker + "\t";
                //returnData += Ext.util.Format.dateRenderer("m/d/y")(record.data.fillOrderDate) + "\t";
                returnData += record.data.drugName + "\t";
                returnData += record.data.sig + "\r\n";
            }
        });
        //remove items without gridRow-active class
        //var test = Ext.DomQuery.select('div.gridRow-active', _gridPanel.body.dom);

        clipboardData.setData('text', returnData);
    }
}

Ext.hui.common.copyWindow = function(_window){
    var dataHTML = _window.body.dom.innerHTML;
    if (window.clipboardData && clipboardData.setData) {
        //remove linebreaks
        dataHTML = dataHTML.replace(/\r\n/gi, "");
        //remove <div>
        dataHTML = dataHTML.replace(/<div(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/div\>/gi, "");
        dataHTML = dataHTML.replace(/<pre(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/pre\>/gi, "");
        dataHTML = dataHTML.replace(/\<span(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/span\>/gi, "");
        //strip table tags
        dataHTML = dataHTML.replace(/\<table(.|[\r\n])+?\>/gi, "\r\n");
        dataHTML = dataHTML.replace(/\<\/table\>/gi, "");
        dataHTML = dataHTML.replace(/\<thead(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/thead\>/gi, "");
        dataHTML = dataHTML.replace(/\<th(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/th\>/gi, "\t");
        dataHTML = dataHTML.replace(/\<tbody(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/tbody\>/gi, "");
        dataHTML = dataHTML.replace(/\<tr(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/tr\>/gi, "\r\n");
        dataHTML = dataHTML.replace(/\<td(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/td\>/gi, "\t");
        //strip anchors <a>
        dataHTML = dataHTML.replace(/\<a(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/a\>/gi, "");
        //strip images <img>
        dataHTML = dataHTML.replace(/\<img(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/img\>/gi, "");
        //strip &nbsp;
        dataHTML = dataHTML.replace(/\&nbsp\;/gi, "");
        //strip &amp;
        dataHTML = dataHTML.replace(/\&amp\;/gi, "&");
        //strip <br>
        dataHTML = dataHTML.replace(/\<br\>/gi, "\r\n");
        dataHTML = dataHTML.replace(/\<br\/\>/gi, "\r\n");
        //strip <b>
        dataHTML = dataHTML.replace(/\<b\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/b\>/gi, "");
        //strip <strong>
        dataHTML = dataHTML.replace(/\<strong\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/strong\>/gi, "");
        //strip </n>
        dataHTML = dataHTML.replace(/\<\/n\>/gi, "");
        //strip &lt;
        dataHTML = dataHTML.replace(/\&lt\;/gi, "<");
        //strip &gt;
        dataHTML = dataHTML.replace(/\&gt\;/gi, ">");


        clipboardData.setData('text', dataHTML);
    }
}

Ext.hui.common.copyPre = function(_window){
    var dataHTML = _window.body.dom.innerHTML;
    if (window.clipboardData && clipboardData.setData) {
        //remove <div>
        dataHTML = dataHTML.replace(/<pre(.|[\r\n])+?\>/gi, "");
        dataHTML = dataHTML.replace(/\<\/pre\>/gi, "");

        clipboardData.setData('text', dataHTML);
    }
}

Ext.hui.common.dataToJSON = function(_data){
    var data = [];
    _data.each(function(record) {
        data.push(record.data);
    });
    return data;
}

Ext.hui.common.scramble = function (str) {
    var scrambled = '',
            randomNum;
    while (str.length > 1) {
        randomNum = Math.floor(Math.random() * str.length);
        scrambled += str.charAt(randomNum);
        if (randomNum == 0) {
            str = str.substr(randomNum + 1);
        }     else if (randomNum == (str.length - 1)) {
            str = str.substring(0, str.length - 1);
        }     else {
            str = str.substring(0, randomNum) + str.substring(randomNum + 1);
        }
    }

    scrambled += str;
    return scrambled;
}
/**
 * Returns a date object with dateStr set as the UTC time.
 */
Ext.hui.common.createUTCDate = function(dateStr)
{
    var resultDate = new Date(dateStr);
    var UTCResultDate = new Date();
    UTCResultDate.setUTCFullYear(resultDate.getFullYear());
    UTCResultDate.setUTCMonth(resultDate.getMonth());
    UTCResultDate.setUTCDate(resultDate.getDate());
    UTCResultDate.setUTCHours(resultDate.getHours());
    UTCResultDate.setUTCMinutes(resultDate.getMinutes());
    UTCResultDate.setUTCSeconds(resultDate.getSeconds(), 0);

    return UTCResultDate;
}

/**
 * Checks if vital type is allowed to be graphed or shown in a table view
 */
Ext.hui.common.isVitalGraphAllowed = function(vitalType)
{
    return vitalType == "TEMPERATURE" || vitalType == "PULSE" || vitalType == "RESPIRATION" ||
            vitalType == "BLOOD PRESSURE" || vitalType == "HEIGHT" || vitalType == "WEIGHT" ||
            vitalType == "PAIN" || vitalType == "PULSE OXIMETRY";
}
