/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

Ext.namespace('Ext.hui.app');
Ext.namespace('Ext.hui.desktop');
Ext.namespace('Ext.hui.widget');
Ext.namespace('Ext.hui.desktopwindow');
Ext.namespace('Ext.hui.desktopwindow.patient');
Ext.namespace('Ext.hui.desktopwindow.provider');
Ext.namespace('Ext.hui.widget.patient');
Ext.namespace('Ext.hui.widget.provider');
Ext.namespace('Ext.hui.portal');
Ext.namespace('Ext.hui.common');
Ext.namespace('Ext.hui.filter');


Ext.onReady(function(){

//    Ext.util.Observable.prototype.fireEvent = Ext.util.Observable.prototype.fireEvent.createInterceptor(function() {
//        console.log(arguments);
//        return true;
//    });
    Ext.QuickTips.init();

    Ext.hui.app.EXTEND_YEAR = "false";
    Ext.hui.app.EXTEND_YEAR_DATE = 2007;
    Ext.hui.app.WRITEBACK_ENABLE = "false";
    Ext.hui.app.WRITEBACK_SITECODE = "459";

    Ext.hui.app.BHIE_STATUS_REPORT_FLAG = "BHIE_SOURCE_STATUS_REPORT";
    Ext.hui.app.BHIE_STATUS_NO_REPORT_MSG = "Status report is not available.";

    Ext.hui.app.desktop = new Ext.hui.desktop.Desktop();
	
	Ext.hui.app.patientSearchButton =
		new Ext.Button({
				renderTo:"patientsearch_button",
                id: 'patSearchButton',
				text:"Search",
                tabIndex: 2,
				handler:
					function()
					{
						var searchWindow = Ext.hui.app.desktop.createWindow({
							searchQuery:Ext.hui.app.patientSearchTextfield.getValue()},
							Ext.hui.desktopwindow.patient.PatientSearch);

						searchWindow.show();
                        Ext.hui.app.patientSearchTextfield.setValue("");
					}
			});
    Ext.hui.app.patientSearchTextfield =
		new Ext.form.TextField({
            id: 'searchText',
            alt: 'Patient Search Text Field',
            tabIndex:  1,
            renderTo:"patientsearch_textfield",
            maxLength: 40,
            listeners: {
                specialkey: function(f,e){
                    if (e.getKey() == e.ENTER) {
                        Ext.hui.app.patientSearchButton.handler();
                    }
                  }
                }
            });
    Ext.getCmp('searchText').focus('', 10);
	
	var providerView = new Ext.hui.portal.Provider();
    Ext.hui.app.desktop.activePortal = Ext.hui.desktop.PORTAL_PROVIDER;  // 0 - provider, 1 - patient, 2 - etc.

    Ext.EventManager.onWindowResize(function(){
        var portalViews = Ext.query(".portalView");
        Ext.each(portalViews,function(port,index){
            var newWidth = (Ext.lib.Dom.getViewWidth()>920) ? (Ext.lib.Dom.getViewWidth()-20):900;
            Ext.getCmp(port.id).setWidth(Ext.lib.Dom.getViewWidth()-20);
            Ext.getCmp(port.id).setHeight(Ext.lib.Dom.getViewHeight()-150),
            Ext.getCmp(port.id).doLayout;

        });
        if (Ext.getCmp('patDemographics')){
            var newWidth = ((Ext.lib.Dom.getViewWidth()/3)>315) ? ((Ext.lib.Dom.getViewWidth()/3)-20):295;
            Ext.getCmp('patDemographics').setWidth(newWidth);
            Ext.getCmp('patDemographics').doLayout;
        }
    });

    //load provider configuration
    Ext.hui.app.loadProviderConfig = function(){
        if (Ext.hui.session.prov_view_cfg.tabs) {
            if (Ext.hui.session.prov_view_cfg.tabs.length > 0) {
                Ext.each(Ext.hui.session.prov_view_cfg.tabs,function(tab,tIndex) {
                    //alert(tab.label + " : tab #" + count);
                    //first create tab (if not the default one)
                    if (tIndex > 0) {
                        Ext.hui.portal.Provider.addTab(Ext.getCmp('prov_tabPanel'),tab.label);
                    }
                    //process by column
                    Ext.each(Ext.hui.session.prov_view_cfg.tabs[tIndex].cols,function(col,cIndex) {
                        Ext.each(Ext.hui.session.prov_view_cfg.tabs[tIndex].cols[cIndex].widgets,function(widget,wIndex) {
                            Ext.getCmp('prov_tabPanel').get(tIndex).items.items[0].items.items[cIndex].add(
                            {
                                xtype: widget.widgetType,
                                desktop:Ext.hui.app.desktop,
                                height: widget.height,
                                startDay: widget.startDay,
                                endDay: widget.endDay
                            }
                                    ).show();
                            Ext.getCmp('prov_tabPanel').get(tIndex).items.items[0].items.items[cIndex].doLayout();
                        });
                    });

                    //load widgets

                }); // eo each
            }
        }
        Ext.getCmp('prov_tabPanel').setActiveTab(0);
    }
    Ext.hui.app.loadProviderConfig();

    //load patient configuration
    Ext.hui.app.loadPatientConfig = function(){
//        Ext.hui.session.pat_view_cfg
//        Ext.each(Ext.hui.session.cfg,function(conf,tCnt) {
//        if(conf.cfgItem == "PORTAL_PROVIDER"){
//            Ext.hui.session.prov_view_cfg = conf;
//        } else if (conf.cfgItem == "PORTAL_PATIENT"){
//            Ext.hui.session.pat_view_cfg = conf;
//        } else if (conf.cfgItem == "UI_CONF"){
//            Ext.hui.session.ui_conf = conf;
//        }
        if (Ext.hui.session.pat_view_cfg.tabs) {
            if (Ext.hui.session.pat_view_cfg.tabs.length > 0) {
                Ext.each(Ext.hui.session.pat_view_cfg.tabs,function(tab,tIndex) {
                    //alert(tab.label + " : tab #" + count);
                    //first create tab (if not the default one)
                    if (tIndex > 0) {
                        Ext.hui.portal.Patient.addTab(Ext.getCmp('pat_tabPanel'),tab.label);
                    }
                    //process by column
                    Ext.each(Ext.hui.session.pat_view_cfg.tabs[tIndex].cols,function(col,cIndex) {
                        Ext.each(Ext.hui.session.pat_view_cfg.tabs[tIndex].cols[cIndex].widgets,function(widget,wIndex) {
                            if (widget.widgetType != 'patientdemographics_widget' && widget.widgetType != undefined){
                                Ext.getCmp('pat_tabPanel').get(tIndex).items.items[0].items.items[cIndex].add(
                                {
                                    xtype: widget.widgetType,
                                    desktop:Ext.hui.app.desktop,
                                    height: widget.height,
                                    patientToken:Ext.hui.app.patientView.getPatientToken(),
                                    startDay: widget.startDay,
                                    endDay: widget.endDay
                                }
                                        ).show();
                                Ext.getCmp('pat_tabPanel').get(tIndex).items.items[0].items.items[cIndex].doLayout();
                            }
                        });
                    });

                    //load widgets

                }); // eo each
            }
        }
        Ext.getCmp('pat_tabPanel').setActiveTab(0);
    }

    //----  setup HOTKEYS ----//

	//listen for left or right keybutton presses
   	var shiftView = new Ext.KeyMap(document, {
		key: [Ext.EventObject.LEFT, Ext.EventObject.RIGHT],  
		ctrl: true,  
		fn: shiftViewEvent	
	});



    //----  END setup HOTKEYS ----//

    Ext.get('nav-button-left').on('click', function() {Ext.hui.app.shiftView('l')});
    Ext.get('nav-button-right').on('click', function() {Ext.hui.app.shiftView('r')});

    function shiftViewEvent(e) {
   		var dir = (e == Ext.EventObject.LEFT) ? 'l' : 'r';
        if((dir=='r' && Ext.hui.app.desktop.activePortal!=Ext.hui.desktop.PORTAL_PATIENT && Ext.hui.app.patientView)
                ||(dir=='l' &&  Ext.hui.app.desktop.activePortal!=Ext.hui.desktop.PORTAL_PROVIDER)){
		    Ext.hui.app.shiftView(dir);
        }
   	};



   	Ext.hui.app.shiftView = function(dir)
   	{
   		var windows = Ext.query(".portalWindow");
   		if ( ((Ext.hui.app.desktop.activePortal==0) && (dir=='l'))  || ((Ext.hui.app.desktop.activePortal==windows.length-1)&&(dir=='r'))) {
			return;
		} 
		
		Ext.hui.app.desktop.removeAllWindows();
   		
   		var nextPanel = (dir=='l') ? (Ext.hui.app.desktop.activePortal-1) : (Ext.hui.app.desktop.activePortal+1);
   		var direction = (dir=='l') ? (1) : (-1) ;
   		var distance = direction*Ext.fly(windows[nextPanel]).getLeft();
		//alert('distance: ' + distance + "  direction: " + dir + "  nextPanel: " + nextPanel + " top of next panel: " + Ext.get(windows[nextPanel]).getTop());
   		Ext.each(windows,function(win, index){
   			Ext.fly(win).move(dir, distance, {duration: 1, easing: 'easeBoth'});	
   		});
   		Ext.hui.app.desktop.activePortal = nextPanel;
   		Ext.hui.app.prepWidgetIcons(Ext.hui.app.desktop.activePortal);
        Ext.hui.app.prepNavButtons(Ext.hui.app.desktop.activePortal);
//        var setFocus = function(){
//            if (Ext.hui.app.desktop.activePortal==0){
//                Ext.getCmp('prov_tabPanel').focus();
//            }  else {
//                Ext.getCmp('pat_tabPanel').focus();
//            }
//        }
//        //delay 1 sec to allow window change animation.
//        setFocus.defer(1000,this);
   	}


   	Ext.hui.app.prepWidgetIcons = function(_activePortal){
   			var icons = Ext.query(".widgetIcon");
   			Ext.each(icons,function(el) {
               if (Ext.getCmp(el.id))    {
                    var cmpIcon = Ext.getCmp(el.id);
                    //cmpIcon.addClass("hidden");
                   cmpIcon.hide();
                    if(cmpIcon.widgetGroup == _activePortal){
                        //cmpIcon.removeClass("hidden");
                        cmpIcon.show();
                    }
               }
			}); // eo each 
   	}

    Ext.hui.app.prepNavButtons = function(_activePortal){
        var buttonLeft = Ext.get('nav-button-left');
        var buttonRight = Ext.get('nav-button-right');

        if((_activePortal == 0)&&(Ext.hui.app.patientView)) {
            buttonRight.setStyle('display', 'block');
            buttonLeft.setStyle('display', 'none');
        }
        if(_activePortal > 0) {
            buttonLeft.setStyle('display', 'block');
            buttonRight.setStyle('display', 'none');
        }
   	}

    Ext.hui.app.selectPatientFromPatientSearch = function(patientToken, isSensitive, patName, objRefId)
    {
        if (isSensitive)
        {
            Ext.MessageBox.confirm(
              'Sensitive Record',
               'This is a VA SENSITIVE Patient record. <br/> Do you wish to continue?',
               function(btnId){
                   if (btnId == "yes") Ext.hui.app.selectPatient(patientToken,patName, objRefId);
               }, this
           );
        }
        else Ext.hui.app.selectPatient(patientToken,patName, objRefId);
    }

   	Ext.hui.app.selectPatient = function(patientToken,patName, objRefId)
   	{
   	    if (objRefId)
        {
            var loadMask2 = new Ext.LoadMask('ux-desktop', {msg:"Selecting Patient..."});
            loadMask2.show();
            Ext.hui.app.desktop.loading();
        }

   	    //patient select request
        Ext.Ajax.request({
           url: 'rest/patientSelect.json',
           success: function()
           {
                if (Ext.hui.app.patientView)
                {
                    Ext.hui.app.patientView.destroy();
                    Ext.hui.app.patientView = null;
                }

                Ext.hui.app.patientView = new Ext.hui.portal.Patient(patientToken, Ext.hui.app.desktop,patName);
                Ext.hui.app.loadPatientConfig();

                if (Ext.hui.app.desktop.activePortal != Ext.hui.desktop.PORTAL_PATIENT)
                {
                    Ext.hui.app.shiftView('r');
                }
                else
                {
                    Ext.hui.app.desktop.removeAllWindows();
                }

               if (loadMask2) loadMask2.hide();
           },

           failure: function()
           {
               loadMask2.hide();
               Ext.hui.app.desktop.removeAllWindows();
               Ext.Msg.alert("Patient Select Error", "An error occurred while trying to select this patient. Please try your request again.");
           },
           params: { patToken: patientToken },
           disableCaching:true,
           method:'GET',
           timeout: Ext.hui.common.CONNECTION_TIMEOUT_MS
        });


   	}
    this.UILogoutButton = new Ext.Button({
        renderTo: 'UILogout_button',
        id: 'logoutButton',
        text: 'Logout',
        handler: function fn(){
            //only allow one UI Config window
             window.location = Ext.hui.app.LOGOUT_URL;
        }
    });
    this.UIConfigButton = new Ext.Button({
        renderTo: 'UIConfig_button',
        id: 'UIConfigButton',
        text: 'User Interface Configuration',
        handler: function fn(){
            //only allow one UI Config window
            if(Ext.getCmp('UIConfig_window')){
                Ext.getCmp('UIConfig_window').close();
            }
            Ext.hui.app.desktop.createWindow(
                {
                    desktop: Ext.hui.app.desktop
                },
                Ext.hui.desktopwindow.provider.UIConfig).show();
            }
    });
    this.UIHelpButton = new Ext.Button({
        renderTo: 'UIHelp_button',
        id: 'helpButton',
        text: 'Help',
        handler: function fn(){
            window.open(Ext.hui.app.ONLINE_HELP_URL, "OnlineHelp", "status=1,resizable=1,scrollbars=1,menubar=0");
        }
    });
    // *******  setup drag drop  ********
    	/*var overrides = {
			// Only called when element is dragged over the a dropzone with the same ddgroup
        	onDragEnter : function(evtObj, targetElId) {

        	},
			//create the Proxy (copy of original object)
			startDrag:function(x, y) {
				var dragEl = Ext.get(this.getDragEl());
				var el = Ext.get(this.getEl());

				dragEl.applyStyles({'z-index':2000});
				dragEl.update(el.dom.innerHTML);
				dragEl.addClass(el.dom.className + ' dd-proxy');

			},
			// Called when element is dropped not anything other than a dropzone with the same ddgroup
			onInvalidDrop : function() {
				//in our case, this "invalid" IS VALID
				this.invalidDrop = true;
			},
			// Called when the drag operation completes
			endDrag : function() {

				if (this.invalidDrop === true) {

                	//insertWidget(Ext.hui.app.desktop.activePortal,Ext.getCmp(this.id).widgetId);
                    delete this.invalidDrop;
					return;
				}

			}
		};
    	var icons = Ext.query(".widgetIcon");
    	Ext.each(icons,function(el) {
			  	// create DDProxy
    			//var dd  = new Ext.dd.DD(el, 'widgetIconDDGroup',{
				el.dd  = new Ext.dd.DDProxy(el, '',{
       		 		isTarget  : false
    			});
    			Ext.apply(el.dd, overrides);
			}); // eo each*/
});
