
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows.webservice;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for provider complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="provider">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="cfg" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="DOB" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="dodProvider" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         &lt;element name="dutyPhone" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="email" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="encryptedAvCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="gender" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="locationIdMappings" type="{http://webservice.vds.med.va.gov/}keyValuePair" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="loginSiteCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="loginSiteName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="NPI" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="pager" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="permissionString" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="primaryPermission" type="{http://webservice.vds.med.va.gov/}keyValuePair" minOccurs="0"/>
 *         &lt;element name="providerClass" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="providerFlag" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="SSN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="securityKeys" type="{http://webservice.vds.med.va.gov/}userSecurityKey" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="sigClass" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="sigText" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="sitePermissions" type="{http://webservice.vds.med.va.gov/}keyValuePair" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="userId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "provider", namespace = "http://webservice.vds.med.va.gov/", propOrder = {
    "cfg",
    "dob",
    "dodProvider",
    "dutyPhone",
    "email",
    "encryptedAvCode",
    "gender",
    "locationIdMappings",
    "loginSiteCode",
    "loginSiteName",
    "npi",
    "name",
    "pager",
    "permissionString",
    "primaryPermission",
    "providerClass",
    "providerFlag",
    "ssn",
    "securityKeys",
    "sigClass",
    "sigText",
    "sitePermissions",
    "userId"
})
public class Provider {

    protected String cfg;
    @XmlElement(name = "DOB")
    protected String dob;
    protected boolean dodProvider;
    protected String dutyPhone;
    protected String email;
    protected String encryptedAvCode;
    protected String gender;
    @XmlElement(nillable = true)
    protected List<KeyValuePair> locationIdMappings;
    protected String loginSiteCode;
    protected String loginSiteName;
    @XmlElement(name = "NPI")
    protected String npi;
    protected String name;
    protected String pager;
    protected String permissionString;
    protected KeyValuePair primaryPermission;
    protected String providerClass;
    protected String providerFlag;
    @XmlElement(name = "SSN")
    protected String ssn;
    @XmlElement(nillable = true)
    protected List<UserSecurityKey> securityKeys;
    protected String sigClass;
    protected String sigText;
    @XmlElement(nillable = true)
    protected List<KeyValuePair> sitePermissions;
    protected String userId;

    /**
     * Gets the value of the cfg property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCfg() {
        return cfg;
    }

    /**
     * Sets the value of the cfg property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCfg(String value) {
        this.cfg = value;
    }

    /**
     * Gets the value of the dob property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDOB() {
        return dob;
    }

    /**
     * Sets the value of the dob property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDOB(String value) {
        this.dob = value;
    }

    /**
     * Gets the value of the dodProvider property.
     * 
     */
    public boolean isDodProvider() {
        return dodProvider;
    }

    /**
     * Sets the value of the dodProvider property.
     * 
     */
    public void setDodProvider(boolean value) {
        this.dodProvider = value;
    }

    /**
     * Gets the value of the dutyPhone property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDutyPhone() {
        return dutyPhone;
    }

    /**
     * Sets the value of the dutyPhone property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDutyPhone(String value) {
        this.dutyPhone = value;
    }

    /**
     * Gets the value of the email property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the value of the email property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEmail(String value) {
        this.email = value;
    }

    /**
     * Gets the value of the encryptedAvCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEncryptedAvCode() {
        return encryptedAvCode;
    }

    /**
     * Sets the value of the encryptedAvCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEncryptedAvCode(String value) {
        this.encryptedAvCode = value;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGender(String value) {
        this.gender = value;
    }

    /**
     * Gets the value of the locationIdMappings property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the locationIdMappings property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLocationIdMappings().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link KeyValuePair }
     * 
     * 
     */
    public List<KeyValuePair> getLocationIdMappings() {
        if (locationIdMappings == null) {
            locationIdMappings = new ArrayList<KeyValuePair>();
        }
        return this.locationIdMappings;
    }

    /**
     * Gets the value of the loginSiteCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLoginSiteCode() {
        return loginSiteCode;
    }

    /**
     * Sets the value of the loginSiteCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLoginSiteCode(String value) {
        this.loginSiteCode = value;
    }

    /**
     * Gets the value of the loginSiteName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLoginSiteName() {
        return loginSiteName;
    }

    /**
     * Sets the value of the loginSiteName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLoginSiteName(String value) {
        this.loginSiteName = value;
    }

    /**
     * Gets the value of the npi property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNPI() {
        return npi;
    }

    /**
     * Sets the value of the npi property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNPI(String value) {
        this.npi = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the pager property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPager() {
        return pager;
    }

    /**
     * Sets the value of the pager property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPager(String value) {
        this.pager = value;
    }

    /**
     * Gets the value of the permissionString property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPermissionString() {
        return permissionString;
    }

    /**
     * Sets the value of the permissionString property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPermissionString(String value) {
        this.permissionString = value;
    }

    /**
     * Gets the value of the primaryPermission property.
     * 
     * @return
     *     possible object is
     *     {@link KeyValuePair }
     *     
     */
    public KeyValuePair getPrimaryPermission() {
        return primaryPermission;
    }

    /**
     * Sets the value of the primaryPermission property.
     * 
     * @param value
     *     allowed object is
     *     {@link KeyValuePair }
     *     
     */
    public void setPrimaryPermission(KeyValuePair value) {
        this.primaryPermission = value;
    }

    /**
     * Gets the value of the providerClass property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProviderClass() {
        return providerClass;
    }

    /**
     * Sets the value of the providerClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProviderClass(String value) {
        this.providerClass = value;
    }

    /**
     * Gets the value of the providerFlag property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProviderFlag() {
        return providerFlag;
    }

    /**
     * Sets the value of the providerFlag property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProviderFlag(String value) {
        this.providerFlag = value;
    }

    /**
     * Gets the value of the ssn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSSN() {
        return ssn;
    }

    /**
     * Sets the value of the ssn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSSN(String value) {
        this.ssn = value;
    }

    /**
     * Gets the value of the securityKeys property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the securityKeys property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSecurityKeys().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UserSecurityKey }
     * 
     * 
     */
    public List<UserSecurityKey> getSecurityKeys() {
        if (securityKeys == null) {
            securityKeys = new ArrayList<UserSecurityKey>();
        }
        return this.securityKeys;
    }

    /**
     * Gets the value of the sigClass property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSigClass() {
        return sigClass;
    }

    /**
     * Sets the value of the sigClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSigClass(String value) {
        this.sigClass = value;
    }

    /**
     * Gets the value of the sigText property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSigText() {
        return sigText;
    }

    /**
     * Sets the value of the sigText property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSigText(String value) {
        this.sigText = value;
    }

    /**
     * Gets the value of the sitePermissions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the sitePermissions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSitePermissions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link KeyValuePair }
     * 
     * 
     */
    public List<KeyValuePair> getSitePermissions() {
        if (sitePermissions == null) {
            sitePermissions = new ArrayList<KeyValuePair>();
        }
        return this.sitePermissions;
    }

    /**
     * Gets the value of the userId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUserId() {
        return userId;
    }

    /**
     * Sets the value of the userId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUserId(String value) {
        this.userId = value;
    }

}
