
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows.webservice;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for patient complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="patient">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="age" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="dob" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="dodEdipn" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="gender" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="localDodIen" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="localVAIen" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="patientId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="patientIdSiteCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="SSN" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="sensitive" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         &lt;element name="vistaIcn" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="vistaLocations" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "patient", namespace = "http://webservice.vds.med.va.gov/", propOrder = {
    "age",
    "dob",
    "dodEdipn",
    "gender",
    "localDodIen",
    "localVAIen",
    "name",
    "patientId",
    "patientIdSiteCode",
    "ssn",
    "sensitive",
    "vistaIcn",
    "vistaLocations"
})
@XmlSeeAlso({
    PatientDemographics.class
})
public class Patient {

    protected String age;
    protected String dob;
    protected String dodEdipn;
    protected String gender;
    protected String localDodIen;
    protected String localVAIen;
    protected String name;
    protected String patientId;
    protected String patientIdSiteCode;
    @XmlElement(name = "SSN")
    protected String ssn;
    protected boolean sensitive;
    protected String vistaIcn;
    @XmlElement(nillable = true)
    protected List<String> vistaLocations;

    /**
     * Gets the value of the age property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAge() {
        return age;
    }

    /**
     * Sets the value of the age property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAge(String value) {
        this.age = value;
    }

    /**
     * Gets the value of the dob property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDob() {
        return dob;
    }

    /**
     * Sets the value of the dob property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDob(String value) {
        this.dob = value;
    }

    /**
     * Gets the value of the dodEdipn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDodEdipn() {
        return dodEdipn;
    }

    /**
     * Sets the value of the dodEdipn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDodEdipn(String value) {
        this.dodEdipn = value;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGender(String value) {
        this.gender = value;
    }

    /**
     * Gets the value of the localDodIen property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocalDodIen() {
        return localDodIen;
    }

    /**
     * Sets the value of the localDodIen property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLocalDodIen(String value) {
        this.localDodIen = value;
    }

    /**
     * Gets the value of the localVAIen property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocalVAIen() {
        return localVAIen;
    }

    /**
     * Sets the value of the localVAIen property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLocalVAIen(String value) {
        this.localVAIen = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the patientId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPatientId() {
        return patientId;
    }

    /**
     * Sets the value of the patientId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPatientId(String value) {
        this.patientId = value;
    }

    /**
     * Gets the value of the patientIdSiteCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPatientIdSiteCode() {
        return patientIdSiteCode;
    }

    /**
     * Sets the value of the patientIdSiteCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPatientIdSiteCode(String value) {
        this.patientIdSiteCode = value;
    }

    /**
     * Gets the value of the ssn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSSN() {
        return ssn;
    }

    /**
     * Sets the value of the ssn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSSN(String value) {
        this.ssn = value;
    }

    /**
     * Gets the value of the sensitive property.
     * 
     */
    public boolean isSensitive() {
        return sensitive;
    }

    /**
     * Sets the value of the sensitive property.
     * 
     */
    public void setSensitive(boolean value) {
        this.sensitive = value;
    }

    /**
     * Gets the value of the vistaIcn property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVistaIcn() {
        return vistaIcn;
    }

    /**
     * Sets the value of the vistaIcn property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVistaIcn(String value) {
        this.vistaIcn = value;
    }

    /**
     * Gets the value of the vistaLocations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the vistaLocations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getVistaLocations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    public List<String> getVistaLocations() {
        if (vistaLocations == null) {
            vistaLocations = new ArrayList<String>();
        }
        return this.vistaLocations;
    }

}
