
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows.webservice;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the gov.va.med.jmeadows.webservice package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _GetPatientConsultRequestsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientConsultRequestsResponse");
    private final static QName _GetPatientRads_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientRads");
    private final static QName _JALFHCCAcknowledgeProviderAlertsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "JALFHCC_acknowledgeProviderAlertsResponse");
    private final static QName _GetInptMedicationDetail_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getInptMedicationDetail");
    private final static QName _GetPatientAdmissionsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAdmissionsResponse");
    private final static QName _CreateNewSignedNote_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "createNewSignedNote");
    private final static QName _GetUserAlertsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getUserAlertsResponse");
    private final static QName _GetUserAlerts_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getUserAlerts");
    private final static QName _GetFeedBackItemsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getFeedBackItemsResponse");
    private final static QName _GetProviderUnsignedNotes_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderUnsignedNotes");
    private final static QName _GetRadiologyReportResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getRadiologyReportResponse");
    private final static QName _GetProviderLabAbnormalResults_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderLabAbnormalResults");
    private final static QName _GetProviderOrdersPendingResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderOrdersPendingResponse");
    private final static QName _GetPrescriptionFills_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPrescriptionFills");
    private final static QName _LookupPatientResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "lookupPatientResponse");
    private final static QName _GetConsultReportResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getConsultReportResponse");
    private final static QName _GetPatientProblemList_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientProblemList");
    private final static QName _GetCISNoteResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getCISNoteResponse");
    private final static QName _GetLabOrderResultResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getLabOrderResultResponse");
    private final static QName _SendFeedBack_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "sendFeedBack");
    private final static QName _GetProblemDetail_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProblemDetail");
    private final static QName _GetPatientProblemListResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientProblemListResponse");
    private final static QName _GetProblemDetailResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProblemDetailResponse");
    private final static QName _GetProgressNote_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProgressNote");
    private final static QName _GetPatientLabs_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientLabs");
    private final static QName _GetPatientConsultRequests_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientConsultRequests");
    private final static QName _GetProviderProfileResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderProfileResponse");
    private final static QName _GetAdmissionDiagnosis_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionDiagnosis");
    private final static QName _JALFHCCAcknowledgeProviderAlerts_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "JALFHCC_acknowledgeProviderAlerts");
    private final static QName _GetProviderAppointments_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderAppointments");
    private final static QName _GetRadiologyReport_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getRadiologyReport");
    private final static QName _LookupPatient_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "lookupPatient");
    private final static QName _GetPatientLabTestResultsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientLabTestResultsResponse");
    private final static QName _GetPatientVitalsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientVitalsResponse");
    private final static QName _SendFeedBackResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "sendFeedBackResponse");
    private final static QName _GetConsultReport_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getConsultReport");
    private final static QName _GetClinicalReminderDetail_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getClinicalReminderDetail");
    private final static QName _LoginResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "loginResponse");
    private final static QName _GetProviderCfg_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderCfg");
    private final static QName _GetPatientCodeGreen_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientCodeGreen");
    private final static QName _GetPatientDischargeSummariesResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDischargeSummariesResponse");
    private final static QName _GetPatientImmunizationsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientImmunizationsResponse");
    private final static QName _GetPatientClinicalReminders_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientClinicalReminders");
    private final static QName _GetProviderConsultsReceivedResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderConsultsReceivedResponse");
    private final static QName _GetPatientClinicalRemindersResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientClinicalRemindersResponse");
    private final static QName _GetPatientDemographicsDetail_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDemographicsDetail");
    private final static QName _GetProviderOrdersPending_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderOrdersPending");
    private final static QName _GetProgressNoteResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProgressNoteResponse");
    private final static QName _GetPatientCodeGreenResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientCodeGreenResponse");
    private final static QName _GetAdmissionDiagnosisResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionDiagnosisResponse");
    private final static QName _GetPatientImmunizations_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientImmunizations");
    private final static QName _GetProviderOrdersResulted_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderOrdersResulted");
    private final static QName _GetPatientAppointmentsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAppointmentsResponse");
    private final static QName _GetPatientOrders_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientOrders");
    private final static QName _JALFHCCRetrieveProviderAlertsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "JALFHCC_retrieveProviderAlertsResponse");
    private final static QName _GetPatientDischargeSummaries_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDischargeSummaries");
    private final static QName _GetAdmissionDetails_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionDetails");
    private final static QName _GetPatientAppointments_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAppointments");
    private final static QName _GetFeedBackItems_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getFeedBackItems");
    private final static QName _GetPatientProgressNotesResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientProgressNotesResponse");
    private final static QName _GetProviderLabAbnormalResultsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderLabAbnormalResultsResponse");
    private final static QName _GetProviderConsultsReceived_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderConsultsReceived");
    private final static QName _GetAdmissionProcedures_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionProcedures");
    private final static QName _SetProviderCfgResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "setProviderCfgResponse");
    private final static QName _GetProviderAdmissionsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderAdmissionsResponse");
    private final static QName _GetOrderDetail_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getOrderDetail");
    private final static QName _GetPatientOrdersResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientOrdersResponse");
    private final static QName _GetVisitNotesResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getVisitNotesResponse");
    private final static QName _SetProviderCfg_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "setProviderCfg");
    private final static QName _GetPatientLabsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientLabsResponse");
    private final static QName _GetPatientProgressNotes_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientProgressNotes");
    private final static QName _GetProviderProfile_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderProfile");
    private final static QName _GetProviderConsultsRequested_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderConsultsRequested");
    private final static QName _GetWardAdmissionsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getWardAdmissionsResponse");
    private final static QName _GetPatientMedicationsNVA_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientMedicationsNVA");
    private final static QName _GetPatientAllergiesResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAllergiesResponse");
    private final static QName _GetPatientDemographicsDetailResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDemographicsDetailResponse");
    private final static QName _JALFHCCRetrieveProviderAlerts_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "JALFHCC_retrieveProviderAlerts");
    private final static QName _GetWardAdmissions_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getWardAdmissions");
    private final static QName _LogAudit_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "logAudit");
    private final static QName _GetProviderConsultsRequestedResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderConsultsRequestedResponse");
    private final static QName _GetVisitNotes_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getVisitNotes");
    private final static QName _GetOrderDetailResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getOrderDetailResponse");
    private final static QName _GetPatientCurrentVitalsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientCurrentVitalsResponse");
    private final static QName _Login_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "login");
    private final static QName _GetPatientCurrentVitals_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientCurrentVitals");
    private final static QName _GetProviderAdmissions_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderAdmissions");
    private final static QName _GetPatientAllergies_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAllergies");
    private final static QName _GetPatientRadsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientRadsResponse");
    private final static QName _GetCISNote_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getCISNote");
    private final static QName _JMeadowsException_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "JMeadowsException");
    private final static QName _GetClinicalReminderDetailResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getClinicalReminderDetailResponse");
    private final static QName _GetProviderCfgResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderCfgResponse");
    private final static QName _GetPatientLabTestResults_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientLabTestResults");
    private final static QName _GetPatientVitals_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientVitals");
    private final static QName _GetProviderUnsignedNotesResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderUnsignedNotesResponse");
    private final static QName _GetProviderAppointmentsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderAppointmentsResponse");
    private final static QName _GetPrescriptionFillsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPrescriptionFillsResponse");
    private final static QName _GetPatientDemographics_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDemographics");
    private final static QName _GetAdmissionDetailsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionDetailsResponse");
    private final static QName _LogAuditResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "logAuditResponse");
    private final static QName _GetPatientMedicationsNVAResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientMedicationsNVAResponse");
    private final static QName _GetPatientMedications_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientMedications");
    private final static QName _SelectPatientResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "selectPatientResponse");
    private final static QName _GetAdmissionProceduresResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getAdmissionProceduresResponse");
    private final static QName _CreateNewSignedNoteResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "createNewSignedNoteResponse");
    private final static QName _GetLabOrderResult_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getLabOrderResult");
    private final static QName _SelectPatient_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "selectPatient");
    private final static QName _GetPatientDemographicsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientDemographicsResponse");
    private final static QName _GetPatientAdmissions_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientAdmissions");
    private final static QName _GetProviderOrdersResultedResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getProviderOrdersResultedResponse");
    private final static QName _GetPatientMedicationsResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getPatientMedicationsResponse");
    private final static QName _GetInptMedicationDetailResponse_QNAME = new QName("http://webservice.jmeadows.med.va.gov/", "getInptMedicationDetailResponse");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: gov.va.med.jmeadows.webservice
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link GetPatientRadsResponse }
     * 
     */
    public GetPatientRadsResponse createGetPatientRadsResponse() {
        return new GetPatientRadsResponse();
    }

    /**
     * Create an instance of {@link RadiologyReport }
     * 
     */
    public RadiologyReport createRadiologyReport() {
        return new RadiologyReport();
    }

    /**
     * Create an instance of {@link GetFeedBackItemsResponse }
     * 
     */
    public GetFeedBackItemsResponse createGetFeedBackItemsResponse() {
        return new GetFeedBackItemsResponse();
    }

    /**
     * Create an instance of {@link GetPrescriptionFills }
     * 
     */
    public GetPrescriptionFills createGetPrescriptionFills() {
        return new GetPrescriptionFills();
    }

    /**
     * Create an instance of {@link GetProgressNote }
     * 
     */
    public GetProgressNote createGetProgressNote() {
        return new GetProgressNote();
    }

    /**
     * Create an instance of {@link GetPatientLabsResponse }
     * 
     */
    public GetPatientLabsResponse createGetPatientLabsResponse() {
        return new GetPatientLabsResponse();
    }

    /**
     * Create an instance of {@link GetProviderLabAbnormalResults }
     * 
     */
    public GetProviderLabAbnormalResults createGetProviderLabAbnormalResults() {
        return new GetProviderLabAbnormalResults();
    }

    /**
     * Create an instance of {@link GetProgressNoteResponse }
     * 
     */
    public GetProgressNoteResponse createGetProgressNoteResponse() {
        return new GetProgressNoteResponse();
    }

    /**
     * Create an instance of {@link GetPatientAppointments }
     * 
     */
    public GetPatientAppointments createGetPatientAppointments() {
        return new GetPatientAppointments();
    }

    /**
     * Create an instance of {@link GetCISNoteResponse }
     * 
     */
    public GetCISNoteResponse createGetCISNoteResponse() {
        return new GetCISNoteResponse();
    }

    /**
     * Create an instance of {@link PatientDemographicsDetail }
     * 
     */
    public PatientDemographicsDetail createPatientDemographicsDetail() {
        return new PatientDemographicsDetail();
    }

    /**
     * Create an instance of {@link GetProviderAdmissionsResponse }
     * 
     */
    public GetProviderAdmissionsResponse createGetProviderAdmissionsResponse() {
        return new GetProviderAdmissionsResponse();
    }

    /**
     * Create an instance of {@link GetProviderCfg }
     * 
     */
    public GetProviderCfg createGetProviderCfg() {
        return new GetProviderCfg();
    }

    /**
     * Create an instance of {@link GetProblemDetail }
     * 
     */
    public GetProblemDetail createGetProblemDetail() {
        return new GetProblemDetail();
    }

    /**
     * Create an instance of {@link UserSecurityKey }
     * 
     */
    public UserSecurityKey createUserSecurityKey() {
        return new UserSecurityKey();
    }

    /**
     * Create an instance of {@link GetPatientImmunizationsResponse }
     * 
     */
    public GetPatientImmunizationsResponse createGetPatientImmunizationsResponse() {
        return new GetPatientImmunizationsResponse();
    }

    /**
     * Create an instance of {@link JALFHCCAcknowledgeProviderAlertsResponse }
     * 
     */
    public JALFHCCAcknowledgeProviderAlertsResponse createJALFHCCAcknowledgeProviderAlertsResponse() {
        return new JALFHCCAcknowledgeProviderAlertsResponse();
    }

    /**
     * Create an instance of {@link GetInptMedicationDetail }
     * 
     */
    public GetInptMedicationDetail createGetInptMedicationDetail() {
        return new GetInptMedicationDetail();
    }

    /**
     * Create an instance of {@link LookupPatientResponse }
     * 
     */
    public LookupPatientResponse createLookupPatientResponse() {
        return new LookupPatientResponse();
    }

    /**
     * Create an instance of {@link NhinProblemComment }
     * 
     */
    public NhinProblemComment createNhinProblemComment() {
        return new NhinProblemComment();
    }

    /**
     * Create an instance of {@link GetProviderConsultsReceived }
     * 
     */
    public GetProviderConsultsReceived createGetProviderConsultsReceived() {
        return new GetProviderConsultsReceived();
    }

    /**
     * Create an instance of {@link GetPatientAllergiesResponse }
     * 
     */
    public GetPatientAllergiesResponse createGetPatientAllergiesResponse() {
        return new GetPatientAllergiesResponse();
    }

    /**
     * Create an instance of {@link JALFHCCRetrieveProviderAlerts }
     * 
     */
    public JALFHCCRetrieveProviderAlerts createJALFHCCRetrieveProviderAlerts() {
        return new JALFHCCRetrieveProviderAlerts();
    }

    /**
     * Create an instance of {@link DataBean }
     * 
     */
    public DataBean createDataBean() {
        return new DataBean();
    }

    /**
     * Create an instance of {@link GetPatientMedicationsResponse }
     * 
     */
    public GetPatientMedicationsResponse createGetPatientMedicationsResponse() {
        return new GetPatientMedicationsResponse();
    }

    /**
     * Create an instance of {@link NhinProblem }
     * 
     */
    public NhinProblem createNhinProblem() {
        return new NhinProblem();
    }

    /**
     * Create an instance of {@link GetPatientConsultRequestsResponse }
     * 
     */
    public GetPatientConsultRequestsResponse createGetPatientConsultRequestsResponse() {
        return new GetPatientConsultRequestsResponse();
    }

    /**
     * Create an instance of {@link GetPatientClinicalRemindersResponse }
     * 
     */
    public GetPatientClinicalRemindersResponse createGetPatientClinicalRemindersResponse() {
        return new GetPatientClinicalRemindersResponse();
    }

    /**
     * Create an instance of {@link GetPatientRads }
     * 
     */
    public GetPatientRads createGetPatientRads() {
        return new GetPatientRads();
    }

    /**
     * Create an instance of {@link KeyValuePair }
     * 
     */
    public KeyValuePair createKeyValuePair() {
        return new KeyValuePair();
    }

    /**
     * Create an instance of {@link RadiologyExam }
     * 
     */
    public RadiologyExam createRadiologyExam() {
        return new RadiologyExam();
    }

    /**
     * Create an instance of {@link PatientAppointments }
     * 
     */
    public PatientAppointments createPatientAppointments() {
        return new PatientAppointments();
    }

    /**
     * Create an instance of {@link GetProviderAppointmentsResponse }
     * 
     */
    public GetProviderAppointmentsResponse createGetProviderAppointmentsResponse() {
        return new GetProviderAppointmentsResponse();
    }

    /**
     * Create an instance of {@link GetPatientLabTestResultsResponse }
     * 
     */
    public GetPatientLabTestResultsResponse createGetPatientLabTestResultsResponse() {
        return new GetPatientLabTestResultsResponse();
    }

    /**
     * Create an instance of {@link ProblemNote }
     * 
     */
    public ProblemNote createProblemNote() {
        return new ProblemNote();
    }

    /**
     * Create an instance of {@link GetAdmissionProceduresResponse }
     * 
     */
    public GetAdmissionProceduresResponse createGetAdmissionProceduresResponse() {
        return new GetAdmissionProceduresResponse();
    }

    /**
     * Create an instance of {@link GetWardAdmissions }
     * 
     */
    public GetWardAdmissions createGetWardAdmissions() {
        return new GetWardAdmissions();
    }

    /**
     * Create an instance of {@link GetPatientOrders }
     * 
     */
    public GetPatientOrders createGetPatientOrders() {
        return new GetPatientOrders();
    }

    /**
     * Create an instance of {@link SelectPatientResponse }
     * 
     */
    public SelectPatientResponse createSelectPatientResponse() {
        return new SelectPatientResponse();
    }

    /**
     * Create an instance of {@link NhinLab }
     * 
     */
    public NhinLab createNhinLab() {
        return new NhinLab();
    }

    /**
     * Create an instance of {@link JalfhccAlert }
     * 
     */
    public JalfhccAlert createJalfhccAlert() {
        return new JalfhccAlert();
    }

    /**
     * Create an instance of {@link GetProviderUnsignedNotes }
     * 
     */
    public GetProviderUnsignedNotes createGetProviderUnsignedNotes() {
        return new GetProviderUnsignedNotes();
    }

    /**
     * Create an instance of {@link GetPatientVitals }
     * 
     */
    public GetPatientVitals createGetPatientVitals() {
        return new GetPatientVitals();
    }

    /**
     * Create an instance of {@link GetProviderOrdersPending }
     * 
     */
    public GetProviderOrdersPending createGetProviderOrdersPending() {
        return new GetProviderOrdersPending();
    }

    /**
     * Create an instance of {@link GetPatientCurrentVitals }
     * 
     */
    public GetPatientCurrentVitals createGetPatientCurrentVitals() {
        return new GetPatientCurrentVitals();
    }

    /**
     * Create an instance of {@link GetPatientVitalsResponse }
     * 
     */
    public GetPatientVitalsResponse createGetPatientVitalsResponse() {
        return new GetPatientVitalsResponse();
    }

    /**
     * Create an instance of {@link GetPrescriptionFillsResponse }
     * 
     */
    public GetPrescriptionFillsResponse createGetPrescriptionFillsResponse() {
        return new GetPrescriptionFillsResponse();
    }

    /**
     * Create an instance of {@link GetProviderConsultsReceivedResponse }
     * 
     */
    public GetProviderConsultsReceivedResponse createGetProviderConsultsReceivedResponse() {
        return new GetProviderConsultsReceivedResponse();
    }

    /**
     * Create an instance of {@link SetProviderCfg }
     * 
     */
    public SetProviderCfg createSetProviderCfg() {
        return new SetProviderCfg();
    }

    /**
     * Create an instance of {@link Login }
     * 
     */
    public Login createLogin() {
        return new Login();
    }

    /**
     * Create an instance of {@link GetProviderConsultsRequestedResponse }
     * 
     */
    public GetProviderConsultsRequestedResponse createGetProviderConsultsRequestedResponse() {
        return new GetProviderConsultsRequestedResponse();
    }

    /**
     * Create an instance of {@link LogAuditResponse }
     * 
     */
    public LogAuditResponse createLogAuditResponse() {
        return new LogAuditResponse();
    }

    /**
     * Create an instance of {@link GetVisitNotes }
     * 
     */
    public GetVisitNotes createGetVisitNotes() {
        return new GetVisitNotes();
    }

    /**
     * Create an instance of {@link JMeadowsException }
     * 
     */
    public JMeadowsException createJMeadowsException() {
        return new JMeadowsException();
    }

    /**
     * Create an instance of {@link GetAdmissionDetails }
     * 
     */
    public GetAdmissionDetails createGetAdmissionDetails() {
        return new GetAdmissionDetails();
    }

    /**
     * Create an instance of {@link LabOrder }
     * 
     */
    public LabOrder createLabOrder() {
        return new LabOrder();
    }

    /**
     * Create an instance of {@link GetVisitNotesResponse }
     * 
     */
    public GetVisitNotesResponse createGetVisitNotesResponse() {
        return new GetVisitNotesResponse();
    }

    /**
     * Create an instance of {@link GetPatientDischargeSummariesResponse }
     * 
     */
    public GetPatientDischargeSummariesResponse createGetPatientDischargeSummariesResponse() {
        return new GetPatientDischargeSummariesResponse();
    }

    /**
     * Create an instance of {@link GetPatientAdmissions }
     * 
     */
    public GetPatientAdmissions createGetPatientAdmissions() {
        return new GetPatientAdmissions();
    }

    /**
     * Create an instance of {@link LabResult }
     * 
     */
    public LabResult createLabResult() {
        return new LabResult();
    }

    /**
     * Create an instance of {@link GetProblemDetailResponse }
     * 
     */
    public GetProblemDetailResponse createGetProblemDetailResponse() {
        return new GetProblemDetailResponse();
    }

    /**
     * Create an instance of {@link GetUserAlerts }
     * 
     */
    public GetUserAlerts createGetUserAlerts() {
        return new GetUserAlerts();
    }

    /**
     * Create an instance of {@link GetLabOrderResult }
     * 
     */
    public GetLabOrderResult createGetLabOrderResult() {
        return new GetLabOrderResult();
    }

    /**
     * Create an instance of {@link GetProviderOrdersResulted }
     * 
     */
    public GetProviderOrdersResulted createGetProviderOrdersResulted() {
        return new GetProviderOrdersResulted();
    }

    /**
     * Create an instance of {@link PatientAdmission }
     * 
     */
    public PatientAdmission createPatientAdmission() {
        return new PatientAdmission();
    }

    /**
     * Create an instance of {@link JALFHCCRetrieveProviderAlertsResponse }
     * 
     */
    public JALFHCCRetrieveProviderAlertsResponse createJALFHCCRetrieveProviderAlertsResponse() {
        return new JALFHCCRetrieveProviderAlertsResponse();
    }

    /**
     * Create an instance of {@link GetPatientAllergies }
     * 
     */
    public GetPatientAllergies createGetPatientAllergies() {
        return new GetPatientAllergies();
    }

    /**
     * Create an instance of {@link SendFeedBack }
     * 
     */
    public SendFeedBack createSendFeedBack() {
        return new SendFeedBack();
    }

    /**
     * Create an instance of {@link GetPatientClinicalReminders }
     * 
     */
    public GetPatientClinicalReminders createGetPatientClinicalReminders() {
        return new GetPatientClinicalReminders();
    }

    /**
     * Create an instance of {@link SelectPatient }
     * 
     */
    public SelectPatient createSelectPatient() {
        return new SelectPatient();
    }

    /**
     * Create an instance of {@link GetConsultReportResponse }
     * 
     */
    public GetConsultReportResponse createGetConsultReportResponse() {
        return new GetConsultReportResponse();
    }

    /**
     * Create an instance of {@link JALFHCCAcknowledgeProviderAlerts }
     * 
     */
    public JALFHCCAcknowledgeProviderAlerts createJALFHCCAcknowledgeProviderAlerts() {
        return new JALFHCCAcknowledgeProviderAlerts();
    }

    /**
     * Create an instance of {@link FeedBack }
     * 
     */
    public FeedBack createFeedBack() {
        return new FeedBack();
    }

    /**
     * Create an instance of {@link GetPatientLabTestResults }
     * 
     */
    public GetPatientLabTestResults createGetPatientLabTestResults() {
        return new GetPatientLabTestResults();
    }

    /**
     * Create an instance of {@link GetProviderOrdersPendingResponse }
     * 
     */
    public GetProviderOrdersPendingResponse createGetProviderOrdersPendingResponse() {
        return new GetProviderOrdersPendingResponse();
    }

    /**
     * Create an instance of {@link ProgressNote }
     * 
     */
    public ProgressNote createProgressNote() {
        return new ProgressNote();
    }

    /**
     * Create an instance of {@link GetPatientCodeGreenResponse }
     * 
     */
    public GetPatientCodeGreenResponse createGetPatientCodeGreenResponse() {
        return new GetPatientCodeGreenResponse();
    }

    /**
     * Create an instance of {@link GetInptMedicationDetailResponse }
     * 
     */
    public GetInptMedicationDetailResponse createGetInptMedicationDetailResponse() {
        return new GetInptMedicationDetailResponse();
    }

    /**
     * Create an instance of {@link NhinMedication }
     * 
     */
    public NhinMedication createNhinMedication() {
        return new NhinMedication();
    }

    /**
     * Create an instance of {@link GetPatientProgressNotes }
     * 
     */
    public GetPatientProgressNotes createGetPatientProgressNotes() {
        return new GetPatientProgressNotes();
    }

    /**
     * Create an instance of {@link ReferralBean }
     * 
     */
    public ReferralBean createReferralBean() {
        return new ReferralBean();
    }

    /**
     * Create an instance of {@link SendFeedBackResponse }
     * 
     */
    public SendFeedBackResponse createSendFeedBackResponse() {
        return new SendFeedBackResponse();
    }

    /**
     * Create an instance of {@link GetProviderLabAbnormalResultsResponse }
     * 
     */
    public GetProviderLabAbnormalResultsResponse createGetProviderLabAbnormalResultsResponse() {
        return new GetProviderLabAbnormalResultsResponse();
    }

    /**
     * Create an instance of {@link Patient }
     * 
     */
    public Patient createPatient() {
        return new Patient();
    }

    /**
     * Create an instance of {@link NhinLabOrder }
     * 
     */
    public NhinLabOrder createNhinLabOrder() {
        return new NhinLabOrder();
    }

    /**
     * Create an instance of {@link InsuranceBean }
     * 
     */
    public InsuranceBean createInsuranceBean() {
        return new InsuranceBean();
    }

    /**
     * Create an instance of {@link LoginResponse }
     * 
     */
    public LoginResponse createLoginResponse() {
        return new LoginResponse();
    }

    /**
     * Create an instance of {@link GetProviderUnsignedNotesResponse }
     * 
     */
    public GetProviderUnsignedNotesResponse createGetProviderUnsignedNotesResponse() {
        return new GetProviderUnsignedNotesResponse();
    }

    /**
     * Create an instance of {@link Diagnosis }
     * 
     */
    public Diagnosis createDiagnosis() {
        return new Diagnosis();
    }

    /**
     * Create an instance of {@link PrescriptionFill }
     * 
     */
    public PrescriptionFill createPrescriptionFill() {
        return new PrescriptionFill();
    }

    /**
     * Create an instance of {@link GetAdmissionProcedures }
     * 
     */
    public GetAdmissionProcedures createGetAdmissionProcedures() {
        return new GetAdmissionProcedures();
    }

    /**
     * Create an instance of {@link GetPatientOrdersResponse }
     * 
     */
    public GetPatientOrdersResponse createGetPatientOrdersResponse() {
        return new GetPatientOrdersResponse();
    }

    /**
     * Create an instance of {@link GetPatientConsultRequests }
     * 
     */
    public GetPatientConsultRequests createGetPatientConsultRequests() {
        return new GetPatientConsultRequests();
    }

    /**
     * Create an instance of {@link ProblemDetail }
     * 
     */
    public ProblemDetail createProblemDetail() {
        return new ProblemDetail();
    }

    /**
     * Create an instance of {@link GetRadiologyReport }
     * 
     */
    public GetRadiologyReport createGetRadiologyReport() {
        return new GetRadiologyReport();
    }

    /**
     * Create an instance of {@link Problem }
     * 
     */
    public Problem createProblem() {
        return new Problem();
    }

    /**
     * Create an instance of {@link LookupPatient }
     * 
     */
    public LookupPatient createLookupPatient() {
        return new LookupPatient();
    }

    /**
     * Create an instance of {@link GetPatientDemographicsDetailResponse }
     * 
     */
    public GetPatientDemographicsDetailResponse createGetPatientDemographicsDetailResponse() {
        return new GetPatientDemographicsDetailResponse();
    }

    /**
     * Create an instance of {@link GetPatientAdmissionsResponse }
     * 
     */
    public GetPatientAdmissionsResponse createGetPatientAdmissionsResponse() {
        return new GetPatientAdmissionsResponse();
    }

    /**
     * Create an instance of {@link Medication }
     * 
     */
    public Medication createMedication() {
        return new Medication();
    }

    /**
     * Create an instance of {@link AdmissionDetail }
     * 
     */
    public AdmissionDetail createAdmissionDetail() {
        return new AdmissionDetail();
    }

    /**
     * Create an instance of {@link GetClinicalReminderDetailResponse }
     * 
     */
    public GetClinicalReminderDetailResponse createGetClinicalReminderDetailResponse() {
        return new GetClinicalReminderDetailResponse();
    }

    /**
     * Create an instance of {@link GetAdmissionDiagnosis }
     * 
     */
    public GetAdmissionDiagnosis createGetAdmissionDiagnosis() {
        return new GetAdmissionDiagnosis();
    }

    /**
     * Create an instance of {@link PatientDemographics }
     * 
     */
    public PatientDemographics createPatientDemographics() {
        return new PatientDemographics();
    }

    /**
     * Create an instance of {@link Alert }
     * 
     */
    public Alert createAlert() {
        return new Alert();
    }

    /**
     * Create an instance of {@link GetPatientDischargeSummaries }
     * 
     */
    public GetPatientDischargeSummaries createGetPatientDischargeSummaries() {
        return new GetPatientDischargeSummaries();
    }

    /**
     * Create an instance of {@link GetPatientCurrentVitalsResponse }
     * 
     */
    public GetPatientCurrentVitalsResponse createGetPatientCurrentVitalsResponse() {
        return new GetPatientCurrentVitalsResponse();
    }

    /**
     * Create an instance of {@link GetProviderAdmissions }
     * 
     */
    public GetProviderAdmissions createGetProviderAdmissions() {
        return new GetProviderAdmissions();
    }

    /**
     * Create an instance of {@link GetPatientMedicationsNVA }
     * 
     */
    public GetPatientMedicationsNVA createGetPatientMedicationsNVA() {
        return new GetPatientMedicationsNVA();
    }

    /**
     * Create an instance of {@link GetLabOrderResultResponse }
     * 
     */
    public GetLabOrderResultResponse createGetLabOrderResultResponse() {
        return new GetLabOrderResultResponse();
    }

    /**
     * Create an instance of {@link GetPatientDemographicsResponse }
     * 
     */
    public GetPatientDemographicsResponse createGetPatientDemographicsResponse() {
        return new GetPatientDemographicsResponse();
    }

    /**
     * Create an instance of {@link GetAdmissionDetailsResponse }
     * 
     */
    public GetAdmissionDetailsResponse createGetAdmissionDetailsResponse() {
        return new GetAdmissionDetailsResponse();
    }

    /**
     * Create an instance of {@link GetUserAlertsResponse }
     * 
     */
    public GetUserAlertsResponse createGetUserAlertsResponse() {
        return new GetUserAlertsResponse();
    }

    /**
     * Create an instance of {@link GetPatientProblemList }
     * 
     */
    public GetPatientProblemList createGetPatientProblemList() {
        return new GetPatientProblemList();
    }

    /**
     * Create an instance of {@link Provider }
     * 
     */
    public Provider createProvider() {
        return new Provider();
    }

    /**
     * Create an instance of {@link GetPatientProblemListResponse }
     * 
     */
    public GetPatientProblemListResponse createGetPatientProblemListResponse() {
        return new GetPatientProblemListResponse();
    }

    /**
     * Create an instance of {@link CreateNewSignedNote }
     * 
     */
    public CreateNewSignedNote createCreateNewSignedNote() {
        return new CreateNewSignedNote();
    }

    /**
     * Create an instance of {@link Immunization }
     * 
     */
    public Immunization createImmunization() {
        return new Immunization();
    }

    /**
     * Create an instance of {@link GetRadiologyReportResponse }
     * 
     */
    public GetRadiologyReportResponse createGetRadiologyReportResponse() {
        return new GetRadiologyReportResponse();
    }

    /**
     * Create an instance of {@link LogAudit }
     * 
     */
    public LogAudit createLogAudit() {
        return new LogAudit();
    }

    /**
     * Create an instance of {@link GetPatientMedicationsNVAResponse }
     * 
     */
    public GetPatientMedicationsNVAResponse createGetPatientMedicationsNVAResponse() {
        return new GetPatientMedicationsNVAResponse();
    }

    /**
     * Create an instance of {@link GetPatientProgressNotesResponse }
     * 
     */
    public GetPatientProgressNotesResponse createGetPatientProgressNotesResponse() {
        return new GetPatientProgressNotesResponse();
    }

    /**
     * Create an instance of {@link GetPatientMedications }
     * 
     */
    public GetPatientMedications createGetPatientMedications() {
        return new GetPatientMedications();
    }

    /**
     * Create an instance of {@link GetProviderOrdersResultedResponse }
     * 
     */
    public GetProviderOrdersResultedResponse createGetProviderOrdersResultedResponse() {
        return new GetProviderOrdersResultedResponse();
    }

    /**
     * Create an instance of {@link ClinicalReminder }
     * 
     */
    public ClinicalReminder createClinicalReminder() {
        return new ClinicalReminder();
    }

    /**
     * Create an instance of {@link GetPatientLabs }
     * 
     */
    public GetPatientLabs createGetPatientLabs() {
        return new GetPatientLabs();
    }

    /**
     * Create an instance of {@link Procedure }
     * 
     */
    public Procedure createProcedure() {
        return new Procedure();
    }

    /**
     * Create an instance of {@link GetPatientDemographics }
     * 
     */
    public GetPatientDemographics createGetPatientDemographics() {
        return new GetPatientDemographics();
    }

    /**
     * Create an instance of {@link GetWardAdmissionsResponse }
     * 
     */
    public GetWardAdmissionsResponse createGetWardAdmissionsResponse() {
        return new GetWardAdmissionsResponse();
    }

    /**
     * Create an instance of {@link GetProviderProfile }
     * 
     */
    public GetProviderProfile createGetProviderProfile() {
        return new GetProviderProfile();
    }

    /**
     * Create an instance of {@link Order }
     * 
     */
    public Order createOrder() {
        return new Order();
    }

    /**
     * Create an instance of {@link GetOrderDetailResponse }
     * 
     */
    public GetOrderDetailResponse createGetOrderDetailResponse() {
        return new GetOrderDetailResponse();
    }

    /**
     * Create an instance of {@link GetProviderConsultsRequested }
     * 
     */
    public GetProviderConsultsRequested createGetProviderConsultsRequested() {
        return new GetProviderConsultsRequested();
    }

    /**
     * Create an instance of {@link GetAdmissionDiagnosisResponse }
     * 
     */
    public GetAdmissionDiagnosisResponse createGetAdmissionDiagnosisResponse() {
        return new GetAdmissionDiagnosisResponse();
    }

    /**
     * Create an instance of {@link CreateNewSignedNoteResponse }
     * 
     */
    public CreateNewSignedNoteResponse createCreateNewSignedNoteResponse() {
        return new CreateNewSignedNoteResponse();
    }

    /**
     * Create an instance of {@link GetPatientAppointmentsResponse }
     * 
     */
    public GetPatientAppointmentsResponse createGetPatientAppointmentsResponse() {
        return new GetPatientAppointmentsResponse();
    }

    /**
     * Create an instance of {@link SetProviderCfgResponse }
     * 
     */
    public SetProviderCfgResponse createSetProviderCfgResponse() {
        return new SetProviderCfgResponse();
    }

    /**
     * Create an instance of {@link GetProviderProfileResponse }
     * 
     */
    public GetProviderProfileResponse createGetProviderProfileResponse() {
        return new GetProviderProfileResponse();
    }

    /**
     * Create an instance of {@link GetOrderDetail }
     * 
     */
    public GetOrderDetail createGetOrderDetail() {
        return new GetOrderDetail();
    }

    /**
     * Create an instance of {@link QueryBean }
     * 
     */
    public QueryBean createQueryBean() {
        return new QueryBean();
    }

    /**
     * Create an instance of {@link GetCISNote }
     * 
     */
    public GetCISNote createGetCISNote() {
        return new GetCISNote();
    }

    /**
     * Create an instance of {@link GetPatientImmunizations }
     * 
     */
    public GetPatientImmunizations createGetPatientImmunizations() {
        return new GetPatientImmunizations();
    }

    /**
     * Create an instance of {@link Allergy }
     * 
     */
    public Allergy createAllergy() {
        return new Allergy();
    }

    /**
     * Create an instance of {@link GetProviderCfgResponse }
     * 
     */
    public GetProviderCfgResponse createGetProviderCfgResponse() {
        return new GetProviderCfgResponse();
    }

    /**
     * Create an instance of {@link GetFeedBackItems }
     * 
     */
    public GetFeedBackItems createGetFeedBackItems() {
        return new GetFeedBackItems();
    }

    /**
     * Create an instance of {@link GetPatientCodeGreen }
     * 
     */
    public GetPatientCodeGreen createGetPatientCodeGreen() {
        return new GetPatientCodeGreen();
    }

    /**
     * Create an instance of {@link GetConsultReport }
     * 
     */
    public GetConsultReport createGetConsultReport() {
        return new GetConsultReport();
    }

    /**
     * Create an instance of {@link Vitals }
     * 
     */
    public Vitals createVitals() {
        return new Vitals();
    }

    /**
     * Create an instance of {@link GetProviderAppointments }
     * 
     */
    public GetProviderAppointments createGetProviderAppointments() {
        return new GetProviderAppointments();
    }

    /**
     * Create an instance of {@link Consult }
     * 
     */
    public Consult createConsult() {
        return new Consult();
    }

    /**
     * Create an instance of {@link GetClinicalReminderDetail }
     * 
     */
    public GetClinicalReminderDetail createGetClinicalReminderDetail() {
        return new GetClinicalReminderDetail();
    }

    /**
     * Create an instance of {@link GetPatientDemographicsDetail }
     * 
     */
    public GetPatientDemographicsDetail createGetPatientDemographicsDetail() {
        return new GetPatientDemographicsDetail();
    }

    /**
     * Create an instance of {@link Prescription }
     * 
     */
    public Prescription createPrescription() {
        return new Prescription();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientConsultRequestsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientConsultRequestsResponse")
    public JAXBElement<GetPatientConsultRequestsResponse> createGetPatientConsultRequestsResponse(GetPatientConsultRequestsResponse value) {
        return new JAXBElement<GetPatientConsultRequestsResponse>(_GetPatientConsultRequestsResponse_QNAME, GetPatientConsultRequestsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientRads }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientRads")
    public JAXBElement<GetPatientRads> createGetPatientRads(GetPatientRads value) {
        return new JAXBElement<GetPatientRads>(_GetPatientRads_QNAME, GetPatientRads.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link JALFHCCAcknowledgeProviderAlertsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "JALFHCC_acknowledgeProviderAlertsResponse")
    public JAXBElement<JALFHCCAcknowledgeProviderAlertsResponse> createJALFHCCAcknowledgeProviderAlertsResponse(JALFHCCAcknowledgeProviderAlertsResponse value) {
        return new JAXBElement<JALFHCCAcknowledgeProviderAlertsResponse>(_JALFHCCAcknowledgeProviderAlertsResponse_QNAME, JALFHCCAcknowledgeProviderAlertsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetInptMedicationDetail }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getInptMedicationDetail")
    public JAXBElement<GetInptMedicationDetail> createGetInptMedicationDetail(GetInptMedicationDetail value) {
        return new JAXBElement<GetInptMedicationDetail>(_GetInptMedicationDetail_QNAME, GetInptMedicationDetail.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAdmissionsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAdmissionsResponse")
    public JAXBElement<GetPatientAdmissionsResponse> createGetPatientAdmissionsResponse(GetPatientAdmissionsResponse value) {
        return new JAXBElement<GetPatientAdmissionsResponse>(_GetPatientAdmissionsResponse_QNAME, GetPatientAdmissionsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CreateNewSignedNote }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "createNewSignedNote")
    public JAXBElement<CreateNewSignedNote> createCreateNewSignedNote(CreateNewSignedNote value) {
        return new JAXBElement<CreateNewSignedNote>(_CreateNewSignedNote_QNAME, CreateNewSignedNote.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetUserAlertsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getUserAlertsResponse")
    public JAXBElement<GetUserAlertsResponse> createGetUserAlertsResponse(GetUserAlertsResponse value) {
        return new JAXBElement<GetUserAlertsResponse>(_GetUserAlertsResponse_QNAME, GetUserAlertsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetUserAlerts }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getUserAlerts")
    public JAXBElement<GetUserAlerts> createGetUserAlerts(GetUserAlerts value) {
        return new JAXBElement<GetUserAlerts>(_GetUserAlerts_QNAME, GetUserAlerts.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetFeedBackItemsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getFeedBackItemsResponse")
    public JAXBElement<GetFeedBackItemsResponse> createGetFeedBackItemsResponse(GetFeedBackItemsResponse value) {
        return new JAXBElement<GetFeedBackItemsResponse>(_GetFeedBackItemsResponse_QNAME, GetFeedBackItemsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderUnsignedNotes }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderUnsignedNotes")
    public JAXBElement<GetProviderUnsignedNotes> createGetProviderUnsignedNotes(GetProviderUnsignedNotes value) {
        return new JAXBElement<GetProviderUnsignedNotes>(_GetProviderUnsignedNotes_QNAME, GetProviderUnsignedNotes.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetRadiologyReportResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getRadiologyReportResponse")
    public JAXBElement<GetRadiologyReportResponse> createGetRadiologyReportResponse(GetRadiologyReportResponse value) {
        return new JAXBElement<GetRadiologyReportResponse>(_GetRadiologyReportResponse_QNAME, GetRadiologyReportResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderLabAbnormalResults }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderLabAbnormalResults")
    public JAXBElement<GetProviderLabAbnormalResults> createGetProviderLabAbnormalResults(GetProviderLabAbnormalResults value) {
        return new JAXBElement<GetProviderLabAbnormalResults>(_GetProviderLabAbnormalResults_QNAME, GetProviderLabAbnormalResults.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderOrdersPendingResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderOrdersPendingResponse")
    public JAXBElement<GetProviderOrdersPendingResponse> createGetProviderOrdersPendingResponse(GetProviderOrdersPendingResponse value) {
        return new JAXBElement<GetProviderOrdersPendingResponse>(_GetProviderOrdersPendingResponse_QNAME, GetProviderOrdersPendingResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPrescriptionFills }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPrescriptionFills")
    public JAXBElement<GetPrescriptionFills> createGetPrescriptionFills(GetPrescriptionFills value) {
        return new JAXBElement<GetPrescriptionFills>(_GetPrescriptionFills_QNAME, GetPrescriptionFills.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link LookupPatientResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "lookupPatientResponse")
    public JAXBElement<LookupPatientResponse> createLookupPatientResponse(LookupPatientResponse value) {
        return new JAXBElement<LookupPatientResponse>(_LookupPatientResponse_QNAME, LookupPatientResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetConsultReportResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getConsultReportResponse")
    public JAXBElement<GetConsultReportResponse> createGetConsultReportResponse(GetConsultReportResponse value) {
        return new JAXBElement<GetConsultReportResponse>(_GetConsultReportResponse_QNAME, GetConsultReportResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientProblemList }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientProblemList")
    public JAXBElement<GetPatientProblemList> createGetPatientProblemList(GetPatientProblemList value) {
        return new JAXBElement<GetPatientProblemList>(_GetPatientProblemList_QNAME, GetPatientProblemList.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetCISNoteResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getCISNoteResponse")
    public JAXBElement<GetCISNoteResponse> createGetCISNoteResponse(GetCISNoteResponse value) {
        return new JAXBElement<GetCISNoteResponse>(_GetCISNoteResponse_QNAME, GetCISNoteResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetLabOrderResultResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getLabOrderResultResponse")
    public JAXBElement<GetLabOrderResultResponse> createGetLabOrderResultResponse(GetLabOrderResultResponse value) {
        return new JAXBElement<GetLabOrderResultResponse>(_GetLabOrderResultResponse_QNAME, GetLabOrderResultResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SendFeedBack }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "sendFeedBack")
    public JAXBElement<SendFeedBack> createSendFeedBack(SendFeedBack value) {
        return new JAXBElement<SendFeedBack>(_SendFeedBack_QNAME, SendFeedBack.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProblemDetail }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProblemDetail")
    public JAXBElement<GetProblemDetail> createGetProblemDetail(GetProblemDetail value) {
        return new JAXBElement<GetProblemDetail>(_GetProblemDetail_QNAME, GetProblemDetail.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientProblemListResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientProblemListResponse")
    public JAXBElement<GetPatientProblemListResponse> createGetPatientProblemListResponse(GetPatientProblemListResponse value) {
        return new JAXBElement<GetPatientProblemListResponse>(_GetPatientProblemListResponse_QNAME, GetPatientProblemListResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProblemDetailResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProblemDetailResponse")
    public JAXBElement<GetProblemDetailResponse> createGetProblemDetailResponse(GetProblemDetailResponse value) {
        return new JAXBElement<GetProblemDetailResponse>(_GetProblemDetailResponse_QNAME, GetProblemDetailResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProgressNote }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProgressNote")
    public JAXBElement<GetProgressNote> createGetProgressNote(GetProgressNote value) {
        return new JAXBElement<GetProgressNote>(_GetProgressNote_QNAME, GetProgressNote.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientLabs }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientLabs")
    public JAXBElement<GetPatientLabs> createGetPatientLabs(GetPatientLabs value) {
        return new JAXBElement<GetPatientLabs>(_GetPatientLabs_QNAME, GetPatientLabs.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientConsultRequests }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientConsultRequests")
    public JAXBElement<GetPatientConsultRequests> createGetPatientConsultRequests(GetPatientConsultRequests value) {
        return new JAXBElement<GetPatientConsultRequests>(_GetPatientConsultRequests_QNAME, GetPatientConsultRequests.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderProfileResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderProfileResponse")
    public JAXBElement<GetProviderProfileResponse> createGetProviderProfileResponse(GetProviderProfileResponse value) {
        return new JAXBElement<GetProviderProfileResponse>(_GetProviderProfileResponse_QNAME, GetProviderProfileResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionDiagnosis }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionDiagnosis")
    public JAXBElement<GetAdmissionDiagnosis> createGetAdmissionDiagnosis(GetAdmissionDiagnosis value) {
        return new JAXBElement<GetAdmissionDiagnosis>(_GetAdmissionDiagnosis_QNAME, GetAdmissionDiagnosis.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link JALFHCCAcknowledgeProviderAlerts }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "JALFHCC_acknowledgeProviderAlerts")
    public JAXBElement<JALFHCCAcknowledgeProviderAlerts> createJALFHCCAcknowledgeProviderAlerts(JALFHCCAcknowledgeProviderAlerts value) {
        return new JAXBElement<JALFHCCAcknowledgeProviderAlerts>(_JALFHCCAcknowledgeProviderAlerts_QNAME, JALFHCCAcknowledgeProviderAlerts.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderAppointments }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderAppointments")
    public JAXBElement<GetProviderAppointments> createGetProviderAppointments(GetProviderAppointments value) {
        return new JAXBElement<GetProviderAppointments>(_GetProviderAppointments_QNAME, GetProviderAppointments.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetRadiologyReport }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getRadiologyReport")
    public JAXBElement<GetRadiologyReport> createGetRadiologyReport(GetRadiologyReport value) {
        return new JAXBElement<GetRadiologyReport>(_GetRadiologyReport_QNAME, GetRadiologyReport.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link LookupPatient }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "lookupPatient")
    public JAXBElement<LookupPatient> createLookupPatient(LookupPatient value) {
        return new JAXBElement<LookupPatient>(_LookupPatient_QNAME, LookupPatient.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientLabTestResultsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientLabTestResultsResponse")
    public JAXBElement<GetPatientLabTestResultsResponse> createGetPatientLabTestResultsResponse(GetPatientLabTestResultsResponse value) {
        return new JAXBElement<GetPatientLabTestResultsResponse>(_GetPatientLabTestResultsResponse_QNAME, GetPatientLabTestResultsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientVitalsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientVitalsResponse")
    public JAXBElement<GetPatientVitalsResponse> createGetPatientVitalsResponse(GetPatientVitalsResponse value) {
        return new JAXBElement<GetPatientVitalsResponse>(_GetPatientVitalsResponse_QNAME, GetPatientVitalsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SendFeedBackResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "sendFeedBackResponse")
    public JAXBElement<SendFeedBackResponse> createSendFeedBackResponse(SendFeedBackResponse value) {
        return new JAXBElement<SendFeedBackResponse>(_SendFeedBackResponse_QNAME, SendFeedBackResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetConsultReport }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getConsultReport")
    public JAXBElement<GetConsultReport> createGetConsultReport(GetConsultReport value) {
        return new JAXBElement<GetConsultReport>(_GetConsultReport_QNAME, GetConsultReport.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetClinicalReminderDetail }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getClinicalReminderDetail")
    public JAXBElement<GetClinicalReminderDetail> createGetClinicalReminderDetail(GetClinicalReminderDetail value) {
        return new JAXBElement<GetClinicalReminderDetail>(_GetClinicalReminderDetail_QNAME, GetClinicalReminderDetail.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link LoginResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "loginResponse")
    public JAXBElement<LoginResponse> createLoginResponse(LoginResponse value) {
        return new JAXBElement<LoginResponse>(_LoginResponse_QNAME, LoginResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderCfg }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderCfg")
    public JAXBElement<GetProviderCfg> createGetProviderCfg(GetProviderCfg value) {
        return new JAXBElement<GetProviderCfg>(_GetProviderCfg_QNAME, GetProviderCfg.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientCodeGreen }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientCodeGreen")
    public JAXBElement<GetPatientCodeGreen> createGetPatientCodeGreen(GetPatientCodeGreen value) {
        return new JAXBElement<GetPatientCodeGreen>(_GetPatientCodeGreen_QNAME, GetPatientCodeGreen.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDischargeSummariesResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDischargeSummariesResponse")
    public JAXBElement<GetPatientDischargeSummariesResponse> createGetPatientDischargeSummariesResponse(GetPatientDischargeSummariesResponse value) {
        return new JAXBElement<GetPatientDischargeSummariesResponse>(_GetPatientDischargeSummariesResponse_QNAME, GetPatientDischargeSummariesResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientImmunizationsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientImmunizationsResponse")
    public JAXBElement<GetPatientImmunizationsResponse> createGetPatientImmunizationsResponse(GetPatientImmunizationsResponse value) {
        return new JAXBElement<GetPatientImmunizationsResponse>(_GetPatientImmunizationsResponse_QNAME, GetPatientImmunizationsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientClinicalReminders }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientClinicalReminders")
    public JAXBElement<GetPatientClinicalReminders> createGetPatientClinicalReminders(GetPatientClinicalReminders value) {
        return new JAXBElement<GetPatientClinicalReminders>(_GetPatientClinicalReminders_QNAME, GetPatientClinicalReminders.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderConsultsReceivedResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderConsultsReceivedResponse")
    public JAXBElement<GetProviderConsultsReceivedResponse> createGetProviderConsultsReceivedResponse(GetProviderConsultsReceivedResponse value) {
        return new JAXBElement<GetProviderConsultsReceivedResponse>(_GetProviderConsultsReceivedResponse_QNAME, GetProviderConsultsReceivedResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientClinicalRemindersResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientClinicalRemindersResponse")
    public JAXBElement<GetPatientClinicalRemindersResponse> createGetPatientClinicalRemindersResponse(GetPatientClinicalRemindersResponse value) {
        return new JAXBElement<GetPatientClinicalRemindersResponse>(_GetPatientClinicalRemindersResponse_QNAME, GetPatientClinicalRemindersResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDemographicsDetail }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDemographicsDetail")
    public JAXBElement<GetPatientDemographicsDetail> createGetPatientDemographicsDetail(GetPatientDemographicsDetail value) {
        return new JAXBElement<GetPatientDemographicsDetail>(_GetPatientDemographicsDetail_QNAME, GetPatientDemographicsDetail.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderOrdersPending }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderOrdersPending")
    public JAXBElement<GetProviderOrdersPending> createGetProviderOrdersPending(GetProviderOrdersPending value) {
        return new JAXBElement<GetProviderOrdersPending>(_GetProviderOrdersPending_QNAME, GetProviderOrdersPending.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProgressNoteResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProgressNoteResponse")
    public JAXBElement<GetProgressNoteResponse> createGetProgressNoteResponse(GetProgressNoteResponse value) {
        return new JAXBElement<GetProgressNoteResponse>(_GetProgressNoteResponse_QNAME, GetProgressNoteResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientCodeGreenResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientCodeGreenResponse")
    public JAXBElement<GetPatientCodeGreenResponse> createGetPatientCodeGreenResponse(GetPatientCodeGreenResponse value) {
        return new JAXBElement<GetPatientCodeGreenResponse>(_GetPatientCodeGreenResponse_QNAME, GetPatientCodeGreenResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionDiagnosisResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionDiagnosisResponse")
    public JAXBElement<GetAdmissionDiagnosisResponse> createGetAdmissionDiagnosisResponse(GetAdmissionDiagnosisResponse value) {
        return new JAXBElement<GetAdmissionDiagnosisResponse>(_GetAdmissionDiagnosisResponse_QNAME, GetAdmissionDiagnosisResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientImmunizations }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientImmunizations")
    public JAXBElement<GetPatientImmunizations> createGetPatientImmunizations(GetPatientImmunizations value) {
        return new JAXBElement<GetPatientImmunizations>(_GetPatientImmunizations_QNAME, GetPatientImmunizations.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderOrdersResulted }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderOrdersResulted")
    public JAXBElement<GetProviderOrdersResulted> createGetProviderOrdersResulted(GetProviderOrdersResulted value) {
        return new JAXBElement<GetProviderOrdersResulted>(_GetProviderOrdersResulted_QNAME, GetProviderOrdersResulted.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAppointmentsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAppointmentsResponse")
    public JAXBElement<GetPatientAppointmentsResponse> createGetPatientAppointmentsResponse(GetPatientAppointmentsResponse value) {
        return new JAXBElement<GetPatientAppointmentsResponse>(_GetPatientAppointmentsResponse_QNAME, GetPatientAppointmentsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientOrders }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientOrders")
    public JAXBElement<GetPatientOrders> createGetPatientOrders(GetPatientOrders value) {
        return new JAXBElement<GetPatientOrders>(_GetPatientOrders_QNAME, GetPatientOrders.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link JALFHCCRetrieveProviderAlertsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "JALFHCC_retrieveProviderAlertsResponse")
    public JAXBElement<JALFHCCRetrieveProviderAlertsResponse> createJALFHCCRetrieveProviderAlertsResponse(JALFHCCRetrieveProviderAlertsResponse value) {
        return new JAXBElement<JALFHCCRetrieveProviderAlertsResponse>(_JALFHCCRetrieveProviderAlertsResponse_QNAME, JALFHCCRetrieveProviderAlertsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDischargeSummaries }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDischargeSummaries")
    public JAXBElement<GetPatientDischargeSummaries> createGetPatientDischargeSummaries(GetPatientDischargeSummaries value) {
        return new JAXBElement<GetPatientDischargeSummaries>(_GetPatientDischargeSummaries_QNAME, GetPatientDischargeSummaries.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionDetails }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionDetails")
    public JAXBElement<GetAdmissionDetails> createGetAdmissionDetails(GetAdmissionDetails value) {
        return new JAXBElement<GetAdmissionDetails>(_GetAdmissionDetails_QNAME, GetAdmissionDetails.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAppointments }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAppointments")
    public JAXBElement<GetPatientAppointments> createGetPatientAppointments(GetPatientAppointments value) {
        return new JAXBElement<GetPatientAppointments>(_GetPatientAppointments_QNAME, GetPatientAppointments.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetFeedBackItems }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getFeedBackItems")
    public JAXBElement<GetFeedBackItems> createGetFeedBackItems(GetFeedBackItems value) {
        return new JAXBElement<GetFeedBackItems>(_GetFeedBackItems_QNAME, GetFeedBackItems.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientProgressNotesResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientProgressNotesResponse")
    public JAXBElement<GetPatientProgressNotesResponse> createGetPatientProgressNotesResponse(GetPatientProgressNotesResponse value) {
        return new JAXBElement<GetPatientProgressNotesResponse>(_GetPatientProgressNotesResponse_QNAME, GetPatientProgressNotesResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderLabAbnormalResultsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderLabAbnormalResultsResponse")
    public JAXBElement<GetProviderLabAbnormalResultsResponse> createGetProviderLabAbnormalResultsResponse(GetProviderLabAbnormalResultsResponse value) {
        return new JAXBElement<GetProviderLabAbnormalResultsResponse>(_GetProviderLabAbnormalResultsResponse_QNAME, GetProviderLabAbnormalResultsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderConsultsReceived }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderConsultsReceived")
    public JAXBElement<GetProviderConsultsReceived> createGetProviderConsultsReceived(GetProviderConsultsReceived value) {
        return new JAXBElement<GetProviderConsultsReceived>(_GetProviderConsultsReceived_QNAME, GetProviderConsultsReceived.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionProcedures }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionProcedures")
    public JAXBElement<GetAdmissionProcedures> createGetAdmissionProcedures(GetAdmissionProcedures value) {
        return new JAXBElement<GetAdmissionProcedures>(_GetAdmissionProcedures_QNAME, GetAdmissionProcedures.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SetProviderCfgResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "setProviderCfgResponse")
    public JAXBElement<SetProviderCfgResponse> createSetProviderCfgResponse(SetProviderCfgResponse value) {
        return new JAXBElement<SetProviderCfgResponse>(_SetProviderCfgResponse_QNAME, SetProviderCfgResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderAdmissionsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderAdmissionsResponse")
    public JAXBElement<GetProviderAdmissionsResponse> createGetProviderAdmissionsResponse(GetProviderAdmissionsResponse value) {
        return new JAXBElement<GetProviderAdmissionsResponse>(_GetProviderAdmissionsResponse_QNAME, GetProviderAdmissionsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetOrderDetail }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getOrderDetail")
    public JAXBElement<GetOrderDetail> createGetOrderDetail(GetOrderDetail value) {
        return new JAXBElement<GetOrderDetail>(_GetOrderDetail_QNAME, GetOrderDetail.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientOrdersResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientOrdersResponse")
    public JAXBElement<GetPatientOrdersResponse> createGetPatientOrdersResponse(GetPatientOrdersResponse value) {
        return new JAXBElement<GetPatientOrdersResponse>(_GetPatientOrdersResponse_QNAME, GetPatientOrdersResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetVisitNotesResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getVisitNotesResponse")
    public JAXBElement<GetVisitNotesResponse> createGetVisitNotesResponse(GetVisitNotesResponse value) {
        return new JAXBElement<GetVisitNotesResponse>(_GetVisitNotesResponse_QNAME, GetVisitNotesResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SetProviderCfg }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "setProviderCfg")
    public JAXBElement<SetProviderCfg> createSetProviderCfg(SetProviderCfg value) {
        return new JAXBElement<SetProviderCfg>(_SetProviderCfg_QNAME, SetProviderCfg.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientLabsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientLabsResponse")
    public JAXBElement<GetPatientLabsResponse> createGetPatientLabsResponse(GetPatientLabsResponse value) {
        return new JAXBElement<GetPatientLabsResponse>(_GetPatientLabsResponse_QNAME, GetPatientLabsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientProgressNotes }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientProgressNotes")
    public JAXBElement<GetPatientProgressNotes> createGetPatientProgressNotes(GetPatientProgressNotes value) {
        return new JAXBElement<GetPatientProgressNotes>(_GetPatientProgressNotes_QNAME, GetPatientProgressNotes.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderProfile }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderProfile")
    public JAXBElement<GetProviderProfile> createGetProviderProfile(GetProviderProfile value) {
        return new JAXBElement<GetProviderProfile>(_GetProviderProfile_QNAME, GetProviderProfile.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderConsultsRequested }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderConsultsRequested")
    public JAXBElement<GetProviderConsultsRequested> createGetProviderConsultsRequested(GetProviderConsultsRequested value) {
        return new JAXBElement<GetProviderConsultsRequested>(_GetProviderConsultsRequested_QNAME, GetProviderConsultsRequested.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetWardAdmissionsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getWardAdmissionsResponse")
    public JAXBElement<GetWardAdmissionsResponse> createGetWardAdmissionsResponse(GetWardAdmissionsResponse value) {
        return new JAXBElement<GetWardAdmissionsResponse>(_GetWardAdmissionsResponse_QNAME, GetWardAdmissionsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientMedicationsNVA }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientMedicationsNVA")
    public JAXBElement<GetPatientMedicationsNVA> createGetPatientMedicationsNVA(GetPatientMedicationsNVA value) {
        return new JAXBElement<GetPatientMedicationsNVA>(_GetPatientMedicationsNVA_QNAME, GetPatientMedicationsNVA.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAllergiesResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAllergiesResponse")
    public JAXBElement<GetPatientAllergiesResponse> createGetPatientAllergiesResponse(GetPatientAllergiesResponse value) {
        return new JAXBElement<GetPatientAllergiesResponse>(_GetPatientAllergiesResponse_QNAME, GetPatientAllergiesResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDemographicsDetailResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDemographicsDetailResponse")
    public JAXBElement<GetPatientDemographicsDetailResponse> createGetPatientDemographicsDetailResponse(GetPatientDemographicsDetailResponse value) {
        return new JAXBElement<GetPatientDemographicsDetailResponse>(_GetPatientDemographicsDetailResponse_QNAME, GetPatientDemographicsDetailResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link JALFHCCRetrieveProviderAlerts }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "JALFHCC_retrieveProviderAlerts")
    public JAXBElement<JALFHCCRetrieveProviderAlerts> createJALFHCCRetrieveProviderAlerts(JALFHCCRetrieveProviderAlerts value) {
        return new JAXBElement<JALFHCCRetrieveProviderAlerts>(_JALFHCCRetrieveProviderAlerts_QNAME, JALFHCCRetrieveProviderAlerts.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetWardAdmissions }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getWardAdmissions")
    public JAXBElement<GetWardAdmissions> createGetWardAdmissions(GetWardAdmissions value) {
        return new JAXBElement<GetWardAdmissions>(_GetWardAdmissions_QNAME, GetWardAdmissions.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link LogAudit }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "logAudit")
    public JAXBElement<LogAudit> createLogAudit(LogAudit value) {
        return new JAXBElement<LogAudit>(_LogAudit_QNAME, LogAudit.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderConsultsRequestedResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderConsultsRequestedResponse")
    public JAXBElement<GetProviderConsultsRequestedResponse> createGetProviderConsultsRequestedResponse(GetProviderConsultsRequestedResponse value) {
        return new JAXBElement<GetProviderConsultsRequestedResponse>(_GetProviderConsultsRequestedResponse_QNAME, GetProviderConsultsRequestedResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetVisitNotes }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getVisitNotes")
    public JAXBElement<GetVisitNotes> createGetVisitNotes(GetVisitNotes value) {
        return new JAXBElement<GetVisitNotes>(_GetVisitNotes_QNAME, GetVisitNotes.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetOrderDetailResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getOrderDetailResponse")
    public JAXBElement<GetOrderDetailResponse> createGetOrderDetailResponse(GetOrderDetailResponse value) {
        return new JAXBElement<GetOrderDetailResponse>(_GetOrderDetailResponse_QNAME, GetOrderDetailResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientCurrentVitalsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientCurrentVitalsResponse")
    public JAXBElement<GetPatientCurrentVitalsResponse> createGetPatientCurrentVitalsResponse(GetPatientCurrentVitalsResponse value) {
        return new JAXBElement<GetPatientCurrentVitalsResponse>(_GetPatientCurrentVitalsResponse_QNAME, GetPatientCurrentVitalsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link Login }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "login")
    public JAXBElement<Login> createLogin(Login value) {
        return new JAXBElement<Login>(_Login_QNAME, Login.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientCurrentVitals }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientCurrentVitals")
    public JAXBElement<GetPatientCurrentVitals> createGetPatientCurrentVitals(GetPatientCurrentVitals value) {
        return new JAXBElement<GetPatientCurrentVitals>(_GetPatientCurrentVitals_QNAME, GetPatientCurrentVitals.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderAdmissions }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderAdmissions")
    public JAXBElement<GetProviderAdmissions> createGetProviderAdmissions(GetProviderAdmissions value) {
        return new JAXBElement<GetProviderAdmissions>(_GetProviderAdmissions_QNAME, GetProviderAdmissions.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAllergies }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAllergies")
    public JAXBElement<GetPatientAllergies> createGetPatientAllergies(GetPatientAllergies value) {
        return new JAXBElement<GetPatientAllergies>(_GetPatientAllergies_QNAME, GetPatientAllergies.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientRadsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientRadsResponse")
    public JAXBElement<GetPatientRadsResponse> createGetPatientRadsResponse(GetPatientRadsResponse value) {
        return new JAXBElement<GetPatientRadsResponse>(_GetPatientRadsResponse_QNAME, GetPatientRadsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetCISNote }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getCISNote")
    public JAXBElement<GetCISNote> createGetCISNote(GetCISNote value) {
        return new JAXBElement<GetCISNote>(_GetCISNote_QNAME, GetCISNote.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link JMeadowsException }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "JMeadowsException")
    public JAXBElement<JMeadowsException> createJMeadowsException(JMeadowsException value) {
        return new JAXBElement<JMeadowsException>(_JMeadowsException_QNAME, JMeadowsException.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetClinicalReminderDetailResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getClinicalReminderDetailResponse")
    public JAXBElement<GetClinicalReminderDetailResponse> createGetClinicalReminderDetailResponse(GetClinicalReminderDetailResponse value) {
        return new JAXBElement<GetClinicalReminderDetailResponse>(_GetClinicalReminderDetailResponse_QNAME, GetClinicalReminderDetailResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderCfgResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderCfgResponse")
    public JAXBElement<GetProviderCfgResponse> createGetProviderCfgResponse(GetProviderCfgResponse value) {
        return new JAXBElement<GetProviderCfgResponse>(_GetProviderCfgResponse_QNAME, GetProviderCfgResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientLabTestResults }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientLabTestResults")
    public JAXBElement<GetPatientLabTestResults> createGetPatientLabTestResults(GetPatientLabTestResults value) {
        return new JAXBElement<GetPatientLabTestResults>(_GetPatientLabTestResults_QNAME, GetPatientLabTestResults.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientVitals }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientVitals")
    public JAXBElement<GetPatientVitals> createGetPatientVitals(GetPatientVitals value) {
        return new JAXBElement<GetPatientVitals>(_GetPatientVitals_QNAME, GetPatientVitals.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderUnsignedNotesResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderUnsignedNotesResponse")
    public JAXBElement<GetProviderUnsignedNotesResponse> createGetProviderUnsignedNotesResponse(GetProviderUnsignedNotesResponse value) {
        return new JAXBElement<GetProviderUnsignedNotesResponse>(_GetProviderUnsignedNotesResponse_QNAME, GetProviderUnsignedNotesResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderAppointmentsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderAppointmentsResponse")
    public JAXBElement<GetProviderAppointmentsResponse> createGetProviderAppointmentsResponse(GetProviderAppointmentsResponse value) {
        return new JAXBElement<GetProviderAppointmentsResponse>(_GetProviderAppointmentsResponse_QNAME, GetProviderAppointmentsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPrescriptionFillsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPrescriptionFillsResponse")
    public JAXBElement<GetPrescriptionFillsResponse> createGetPrescriptionFillsResponse(GetPrescriptionFillsResponse value) {
        return new JAXBElement<GetPrescriptionFillsResponse>(_GetPrescriptionFillsResponse_QNAME, GetPrescriptionFillsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDemographics }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDemographics")
    public JAXBElement<GetPatientDemographics> createGetPatientDemographics(GetPatientDemographics value) {
        return new JAXBElement<GetPatientDemographics>(_GetPatientDemographics_QNAME, GetPatientDemographics.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionDetailsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionDetailsResponse")
    public JAXBElement<GetAdmissionDetailsResponse> createGetAdmissionDetailsResponse(GetAdmissionDetailsResponse value) {
        return new JAXBElement<GetAdmissionDetailsResponse>(_GetAdmissionDetailsResponse_QNAME, GetAdmissionDetailsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link LogAuditResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "logAuditResponse")
    public JAXBElement<LogAuditResponse> createLogAuditResponse(LogAuditResponse value) {
        return new JAXBElement<LogAuditResponse>(_LogAuditResponse_QNAME, LogAuditResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientMedicationsNVAResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientMedicationsNVAResponse")
    public JAXBElement<GetPatientMedicationsNVAResponse> createGetPatientMedicationsNVAResponse(GetPatientMedicationsNVAResponse value) {
        return new JAXBElement<GetPatientMedicationsNVAResponse>(_GetPatientMedicationsNVAResponse_QNAME, GetPatientMedicationsNVAResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientMedications }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientMedications")
    public JAXBElement<GetPatientMedications> createGetPatientMedications(GetPatientMedications value) {
        return new JAXBElement<GetPatientMedications>(_GetPatientMedications_QNAME, GetPatientMedications.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SelectPatientResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "selectPatientResponse")
    public JAXBElement<SelectPatientResponse> createSelectPatientResponse(SelectPatientResponse value) {
        return new JAXBElement<SelectPatientResponse>(_SelectPatientResponse_QNAME, SelectPatientResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetAdmissionProceduresResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getAdmissionProceduresResponse")
    public JAXBElement<GetAdmissionProceduresResponse> createGetAdmissionProceduresResponse(GetAdmissionProceduresResponse value) {
        return new JAXBElement<GetAdmissionProceduresResponse>(_GetAdmissionProceduresResponse_QNAME, GetAdmissionProceduresResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CreateNewSignedNoteResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "createNewSignedNoteResponse")
    public JAXBElement<CreateNewSignedNoteResponse> createCreateNewSignedNoteResponse(CreateNewSignedNoteResponse value) {
        return new JAXBElement<CreateNewSignedNoteResponse>(_CreateNewSignedNoteResponse_QNAME, CreateNewSignedNoteResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetLabOrderResult }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getLabOrderResult")
    public JAXBElement<GetLabOrderResult> createGetLabOrderResult(GetLabOrderResult value) {
        return new JAXBElement<GetLabOrderResult>(_GetLabOrderResult_QNAME, GetLabOrderResult.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link SelectPatient }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "selectPatient")
    public JAXBElement<SelectPatient> createSelectPatient(SelectPatient value) {
        return new JAXBElement<SelectPatient>(_SelectPatient_QNAME, SelectPatient.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientDemographicsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientDemographicsResponse")
    public JAXBElement<GetPatientDemographicsResponse> createGetPatientDemographicsResponse(GetPatientDemographicsResponse value) {
        return new JAXBElement<GetPatientDemographicsResponse>(_GetPatientDemographicsResponse_QNAME, GetPatientDemographicsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientAdmissions }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientAdmissions")
    public JAXBElement<GetPatientAdmissions> createGetPatientAdmissions(GetPatientAdmissions value) {
        return new JAXBElement<GetPatientAdmissions>(_GetPatientAdmissions_QNAME, GetPatientAdmissions.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetProviderOrdersResultedResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getProviderOrdersResultedResponse")
    public JAXBElement<GetProviderOrdersResultedResponse> createGetProviderOrdersResultedResponse(GetProviderOrdersResultedResponse value) {
        return new JAXBElement<GetProviderOrdersResultedResponse>(_GetProviderOrdersResultedResponse_QNAME, GetProviderOrdersResultedResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetPatientMedicationsResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getPatientMedicationsResponse")
    public JAXBElement<GetPatientMedicationsResponse> createGetPatientMedicationsResponse(GetPatientMedicationsResponse value) {
        return new JAXBElement<GetPatientMedicationsResponse>(_GetPatientMedicationsResponse_QNAME, GetPatientMedicationsResponse.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link GetInptMedicationDetailResponse }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "http://webservice.jmeadows.med.va.gov/", name = "getInptMedicationDetailResponse")
    public JAXBElement<GetInptMedicationDetailResponse> createGetInptMedicationDetailResponse(GetInptMedicationDetailResponse value) {
        return new JAXBElement<GetInptMedicationDetailResponse>(_GetInptMedicationDetailResponse_QNAME, GetInptMedicationDetailResponse.class, null, value);
    }

}
