
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows.webservice;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;


/**
 * <p>Java class for nhinMedication complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="nhinMedication">
 *   &lt;complexContent>
 *     &lt;extension base="{http://webservice.vds.med.va.gov/}dataBean">
 *       &lt;sequence>
 *         &lt;element name="currentProviderCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="currentProviderName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="daysSupply" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="dose" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="doseNoun" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="doseRoute" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="doseSchedule" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="doseUnits" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="doseUnitsPerDose" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="expiration" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="fillCost" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="fillsAllowed" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="fillsRemaining" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="formType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="lastFilled" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="locationCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="locationName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="orderID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="ordered" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="orderingProviderCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="orderingProviderName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="pharmacistCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="pharmacistName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="prescriptionID" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productClassCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productRole" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaGenericCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaGenericName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaGenericVuid" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaProductCode" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaProductName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="productVaProductVuid" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="quantity" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         &lt;element name="routing" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="sig" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="start" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="status" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="stop" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/>
 *         &lt;element name="type" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="vaStatus" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="vaType" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "nhinMedication", namespace = "http://webservice.vds.med.va.gov/", propOrder = {
    "currentProviderCode",
    "currentProviderName",
    "daysSupply",
    "dose",
    "doseNoun",
    "doseRoute",
    "doseSchedule",
    "doseUnits",
    "doseUnitsPerDose",
    "expiration",
    "fillCost",
    "fillsAllowed",
    "fillsRemaining",
    "formType",
    "id",
    "lastFilled",
    "locationCode",
    "locationName",
    "name",
    "orderID",
    "ordered",
    "orderingProviderCode",
    "orderingProviderName",
    "pharmacistCode",
    "pharmacistName",
    "prescriptionID",
    "productClassCode",
    "productCode",
    "productName",
    "productRole",
    "productVaGenericCode",
    "productVaGenericName",
    "productVaGenericVuid",
    "productVaProductCode",
    "productVaProductName",
    "productVaProductVuid",
    "quantity",
    "routing",
    "sig",
    "start",
    "status",
    "stop",
    "type",
    "vaStatus",
    "vaType"
})
public class NhinMedication
    extends DataBean
{

    protected String currentProviderCode;
    protected String currentProviderName;
    protected int daysSupply;
    protected String dose;
    protected String doseNoun;
    protected String doseRoute;
    protected String doseSchedule;
    protected String doseUnits;
    protected String doseUnitsPerDose;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar expiration;
    protected String fillCost;
    protected int fillsAllowed;
    protected int fillsRemaining;
    protected String formType;
    protected String id;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar lastFilled;
    protected String locationCode;
    protected String locationName;
    protected String name;
    protected String orderID;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar ordered;
    protected String orderingProviderCode;
    protected String orderingProviderName;
    protected String pharmacistCode;
    protected String pharmacistName;
    protected String prescriptionID;
    protected String productClassCode;
    protected String productCode;
    protected String productName;
    protected String productRole;
    protected String productVaGenericCode;
    protected String productVaGenericName;
    protected String productVaGenericVuid;
    protected String productVaProductCode;
    protected String productVaProductName;
    protected String productVaProductVuid;
    protected int quantity;
    protected String routing;
    protected String sig;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar start;
    protected String status;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar stop;
    protected String type;
    protected String vaStatus;
    protected String vaType;

    /**
     * Gets the value of the currentProviderCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCurrentProviderCode() {
        return currentProviderCode;
    }

    /**
     * Sets the value of the currentProviderCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCurrentProviderCode(String value) {
        this.currentProviderCode = value;
    }

    /**
     * Gets the value of the currentProviderName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCurrentProviderName() {
        return currentProviderName;
    }

    /**
     * Sets the value of the currentProviderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCurrentProviderName(String value) {
        this.currentProviderName = value;
    }

    /**
     * Gets the value of the daysSupply property.
     * 
     */
    public int getDaysSupply() {
        return daysSupply;
    }

    /**
     * Sets the value of the daysSupply property.
     * 
     */
    public void setDaysSupply(int value) {
        this.daysSupply = value;
    }

    /**
     * Gets the value of the dose property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDose() {
        return dose;
    }

    /**
     * Sets the value of the dose property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDose(String value) {
        this.dose = value;
    }

    /**
     * Gets the value of the doseNoun property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDoseNoun() {
        return doseNoun;
    }

    /**
     * Sets the value of the doseNoun property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDoseNoun(String value) {
        this.doseNoun = value;
    }

    /**
     * Gets the value of the doseRoute property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDoseRoute() {
        return doseRoute;
    }

    /**
     * Sets the value of the doseRoute property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDoseRoute(String value) {
        this.doseRoute = value;
    }

    /**
     * Gets the value of the doseSchedule property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDoseSchedule() {
        return doseSchedule;
    }

    /**
     * Sets the value of the doseSchedule property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDoseSchedule(String value) {
        this.doseSchedule = value;
    }

    /**
     * Gets the value of the doseUnits property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDoseUnits() {
        return doseUnits;
    }

    /**
     * Sets the value of the doseUnits property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDoseUnits(String value) {
        this.doseUnits = value;
    }

    /**
     * Gets the value of the doseUnitsPerDose property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDoseUnitsPerDose() {
        return doseUnitsPerDose;
    }

    /**
     * Sets the value of the doseUnitsPerDose property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDoseUnitsPerDose(String value) {
        this.doseUnitsPerDose = value;
    }

    /**
     * Gets the value of the expiration property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getExpiration() {
        return expiration;
    }

    /**
     * Sets the value of the expiration property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setExpiration(XMLGregorianCalendar value) {
        this.expiration = value;
    }

    /**
     * Gets the value of the fillCost property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFillCost() {
        return fillCost;
    }

    /**
     * Sets the value of the fillCost property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFillCost(String value) {
        this.fillCost = value;
    }

    /**
     * Gets the value of the fillsAllowed property.
     * 
     */
    public int getFillsAllowed() {
        return fillsAllowed;
    }

    /**
     * Sets the value of the fillsAllowed property.
     * 
     */
    public void setFillsAllowed(int value) {
        this.fillsAllowed = value;
    }

    /**
     * Gets the value of the fillsRemaining property.
     * 
     */
    public int getFillsRemaining() {
        return fillsRemaining;
    }

    /**
     * Sets the value of the fillsRemaining property.
     * 
     */
    public void setFillsRemaining(int value) {
        this.fillsRemaining = value;
    }

    /**
     * Gets the value of the formType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormType() {
        return formType;
    }

    /**
     * Sets the value of the formType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormType(String value) {
        this.formType = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the lastFilled property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getLastFilled() {
        return lastFilled;
    }

    /**
     * Sets the value of the lastFilled property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setLastFilled(XMLGregorianCalendar value) {
        this.lastFilled = value;
    }

    /**
     * Gets the value of the locationCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocationCode() {
        return locationCode;
    }

    /**
     * Sets the value of the locationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLocationCode(String value) {
        this.locationCode = value;
    }

    /**
     * Gets the value of the locationName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLocationName() {
        return locationName;
    }

    /**
     * Sets the value of the locationName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLocationName(String value) {
        this.locationName = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the orderID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderID() {
        return orderID;
    }

    /**
     * Sets the value of the orderID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderID(String value) {
        this.orderID = value;
    }

    /**
     * Gets the value of the ordered property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getOrdered() {
        return ordered;
    }

    /**
     * Sets the value of the ordered property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setOrdered(XMLGregorianCalendar value) {
        this.ordered = value;
    }

    /**
     * Gets the value of the orderingProviderCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderingProviderCode() {
        return orderingProviderCode;
    }

    /**
     * Sets the value of the orderingProviderCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderingProviderCode(String value) {
        this.orderingProviderCode = value;
    }

    /**
     * Gets the value of the orderingProviderName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderingProviderName() {
        return orderingProviderName;
    }

    /**
     * Sets the value of the orderingProviderName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderingProviderName(String value) {
        this.orderingProviderName = value;
    }

    /**
     * Gets the value of the pharmacistCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPharmacistCode() {
        return pharmacistCode;
    }

    /**
     * Sets the value of the pharmacistCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPharmacistCode(String value) {
        this.pharmacistCode = value;
    }

    /**
     * Gets the value of the pharmacistName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPharmacistName() {
        return pharmacistName;
    }

    /**
     * Sets the value of the pharmacistName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPharmacistName(String value) {
        this.pharmacistName = value;
    }

    /**
     * Gets the value of the prescriptionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrescriptionID() {
        return prescriptionID;
    }

    /**
     * Sets the value of the prescriptionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPrescriptionID(String value) {
        this.prescriptionID = value;
    }

    /**
     * Gets the value of the productClassCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductClassCode() {
        return productClassCode;
    }

    /**
     * Sets the value of the productClassCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductClassCode(String value) {
        this.productClassCode = value;
    }

    /**
     * Gets the value of the productCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductCode() {
        return productCode;
    }

    /**
     * Sets the value of the productCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductCode(String value) {
        this.productCode = value;
    }

    /**
     * Gets the value of the productName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductName() {
        return productName;
    }

    /**
     * Sets the value of the productName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductName(String value) {
        this.productName = value;
    }

    /**
     * Gets the value of the productRole property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductRole() {
        return productRole;
    }

    /**
     * Sets the value of the productRole property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductRole(String value) {
        this.productRole = value;
    }

    /**
     * Gets the value of the productVaGenericCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaGenericCode() {
        return productVaGenericCode;
    }

    /**
     * Sets the value of the productVaGenericCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaGenericCode(String value) {
        this.productVaGenericCode = value;
    }

    /**
     * Gets the value of the productVaGenericName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaGenericName() {
        return productVaGenericName;
    }

    /**
     * Sets the value of the productVaGenericName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaGenericName(String value) {
        this.productVaGenericName = value;
    }

    /**
     * Gets the value of the productVaGenericVuid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaGenericVuid() {
        return productVaGenericVuid;
    }

    /**
     * Sets the value of the productVaGenericVuid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaGenericVuid(String value) {
        this.productVaGenericVuid = value;
    }

    /**
     * Gets the value of the productVaProductCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaProductCode() {
        return productVaProductCode;
    }

    /**
     * Sets the value of the productVaProductCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaProductCode(String value) {
        this.productVaProductCode = value;
    }

    /**
     * Gets the value of the productVaProductName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaProductName() {
        return productVaProductName;
    }

    /**
     * Sets the value of the productVaProductName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaProductName(String value) {
        this.productVaProductName = value;
    }

    /**
     * Gets the value of the productVaProductVuid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getProductVaProductVuid() {
        return productVaProductVuid;
    }

    /**
     * Sets the value of the productVaProductVuid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProductVaProductVuid(String value) {
        this.productVaProductVuid = value;
    }

    /**
     * Gets the value of the quantity property.
     * 
     */
    public int getQuantity() {
        return quantity;
    }

    /**
     * Sets the value of the quantity property.
     * 
     */
    public void setQuantity(int value) {
        this.quantity = value;
    }

    /**
     * Gets the value of the routing property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRouting() {
        return routing;
    }

    /**
     * Sets the value of the routing property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRouting(String value) {
        this.routing = value;
    }

    /**
     * Gets the value of the sig property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSig() {
        return sig;
    }

    /**
     * Sets the value of the sig property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSig(String value) {
        this.sig = value;
    }

    /**
     * Gets the value of the start property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getStart() {
        return start;
    }

    /**
     * Sets the value of the start property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStart(XMLGregorianCalendar value) {
        this.start = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatus(String value) {
        this.status = value;
    }

    /**
     * Gets the value of the stop property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getStop() {
        return stop;
    }

    /**
     * Sets the value of the stop property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStop(XMLGregorianCalendar value) {
        this.stop = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the vaStatus property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVaStatus() {
        return vaStatus;
    }

    /**
     * Sets the value of the vaStatus property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVaStatus(String value) {
        this.vaStatus = value;
    }

    /**
     * Gets the value of the vaType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getVaType() {
        return vaType;
    }

    /**
     * Sets the value of the vaType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVaType(String value) {
        this.vaType = value;
    }

}
