
/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows.webservice;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6 in JDK 6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "JMeadowsData", targetNamespace = "http://webservice.jmeadows.med.va.gov/")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface JMeadowsData {


    /**
     * 
     * @param verifyCode
     * @param requestingApp
     * @param accessCode
     * @param siteCode
     * @return
     *     returns gov.va.med.jmeadows.webservice.Provider
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "login", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.Login")
    @ResponseWrapper(localName = "loginResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.LoginResponse")
    public Provider login(
        @WebParam(name = "siteCode", targetNamespace = "")
        String siteCode,
        @WebParam(name = "accessCode", targetNamespace = "")
        String accessCode,
        @WebParam(name = "verifyCode", targetNamespace = "")
        String verifyCode,
        @WebParam(name = "requestingApp", targetNamespace = "")
        String requestingApp)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientAdmission>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientAdmissions", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAdmissions")
    @ResponseWrapper(localName = "getPatientAdmissionsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAdmissionsResponse")
    public List<PatientAdmission> getPatientAdmissions(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.AdmissionDetail
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAdmissionDetails", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionDetails")
    @ResponseWrapper(localName = "getAdmissionDetailsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionDetailsResponse")
    public AdmissionDetail getAdmissionDetails(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Diagnosis>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAdmissionDiagnosis", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionDiagnosis")
    @ResponseWrapper(localName = "getAdmissionDiagnosisResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionDiagnosisResponse")
    public List<Diagnosis> getAdmissionDiagnosis(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Procedure>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAdmissionProcedures", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionProcedures")
    @ResponseWrapper(localName = "getAdmissionProceduresResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetAdmissionProceduresResponse")
    public List<Procedure> getAdmissionProcedures(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Allergy>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientAllergies", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAllergies")
    @ResponseWrapper(localName = "getPatientAllergiesResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAllergiesResponse")
    public List<Allergy> getPatientAllergies(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientAppointments>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientAppointments", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAppointments")
    @ResponseWrapper(localName = "getPatientAppointmentsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientAppointmentsResponse")
    public List<PatientAppointments> getPatientAppointments(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.ClinicalReminder>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientClinicalReminders", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientClinicalReminders")
    @ResponseWrapper(localName = "getPatientClinicalRemindersResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientClinicalRemindersResponse")
    public List<ClinicalReminder> getPatientClinicalReminders(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getClinicalReminderDetail", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetClinicalReminderDetail")
    @ResponseWrapper(localName = "getClinicalReminderDetailResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetClinicalReminderDetailResponse")
    public String getClinicalReminderDetail(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientDemographics>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientDemographics", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDemographics")
    @ResponseWrapper(localName = "getPatientDemographicsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDemographicsResponse")
    public List<PatientDemographics> getPatientDemographics(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientDemographicsDetail>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientDemographicsDetail", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDemographicsDetail")
    @ResponseWrapper(localName = "getPatientDemographicsDetailResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDemographicsDetailResponse")
    public List<PatientDemographicsDetail> getPatientDemographicsDetail(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Patient>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "lookupPatient", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.LookupPatient")
    @ResponseWrapper(localName = "lookupPatientResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.LookupPatientResponse")
    public List<Patient> lookupPatient(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.Patient
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "selectPatient", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SelectPatient")
    @ResponseWrapper(localName = "selectPatientResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SelectPatientResponse")
    public Patient selectPatient(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Immunization>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientImmunizations", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientImmunizations")
    @ResponseWrapper(localName = "getPatientImmunizationsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientImmunizationsResponse")
    public List<Immunization> getPatientImmunizations(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Medication>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientMedications", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientMedications")
    @ResponseWrapper(localName = "getPatientMedicationsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientMedicationsResponse")
    public List<Medication> getPatientMedications(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Consult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientConsultRequests", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientConsultRequests")
    @ResponseWrapper(localName = "getPatientConsultRequestsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientConsultRequestsResponse")
    public List<Consult> getPatientConsultRequests(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getConsultReport", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetConsultReport")
    @ResponseWrapper(localName = "getConsultReportResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetConsultReportResponse")
    public List<String> getConsultReport(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.ProgressNote>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientDischargeSummaries", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDischargeSummaries")
    @ResponseWrapper(localName = "getPatientDischargeSummariesResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientDischargeSummariesResponse")
    public List<ProgressNote> getPatientDischargeSummaries(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.ProgressNote>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientProgressNotes", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientProgressNotes")
    @ResponseWrapper(localName = "getPatientProgressNotesResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientProgressNotesResponse")
    public List<ProgressNote> getPatientProgressNotes(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Order>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientOrders", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientOrders")
    @ResponseWrapper(localName = "getPatientOrdersResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientOrdersResponse")
    public List<Order> getPatientOrders(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Problem>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientProblemList", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientProblemList")
    @ResponseWrapper(localName = "getPatientProblemListResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientProblemListResponse")
    public List<Problem> getPatientProblemList(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.ProblemDetail
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProblemDetail", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProblemDetail")
    @ResponseWrapper(localName = "getProblemDetailResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProblemDetailResponse")
    public ProblemDetail getProblemDetail(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.RadiologyReport>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientRads", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientRads")
    @ResponseWrapper(localName = "getPatientRadsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientRadsResponse")
    public List<RadiologyReport> getPatientRads(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Vitals>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientVitals", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientVitals")
    @ResponseWrapper(localName = "getPatientVitalsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientVitalsResponse")
    public List<Vitals> getPatientVitals(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Vitals>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientCurrentVitals", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientCurrentVitals")
    @ResponseWrapper(localName = "getPatientCurrentVitalsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientCurrentVitalsResponse")
    public List<Vitals> getPatientCurrentVitals(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.FeedBack>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getFeedBackItems", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetFeedBackItems")
    @ResponseWrapper(localName = "getFeedBackItemsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetFeedBackItemsResponse")
    public List<FeedBack> getFeedBackItems(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Medication>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientMedicationsNVA", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientMedicationsNVA")
    @ResponseWrapper(localName = "getPatientMedicationsNVAResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientMedicationsNVAResponse")
    public List<Medication> getPatientMedicationsNVA(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.Prescription
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPrescriptionFills", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPrescriptionFills")
    @ResponseWrapper(localName = "getPrescriptionFillsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPrescriptionFillsResponse")
    public Prescription getPrescriptionFills(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProgressNote", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProgressNote")
    @ResponseWrapper(localName = "getProgressNoteResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProgressNoteResponse")
    public String getProgressNote(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.Provider
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderProfile", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderProfile")
    @ResponseWrapper(localName = "getProviderProfileResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderProfileResponse")
    public Provider getProviderProfile(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns gov.va.med.jmeadows.webservice.RadiologyReport
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getRadiologyReport", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetRadiologyReport")
    @ResponseWrapper(localName = "getRadiologyReportResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetRadiologyReportResponse")
    public RadiologyReport getRadiologyReport(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Alert>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getUserAlerts", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetUserAlerts")
    @ResponseWrapper(localName = "getUserAlertsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetUserAlertsResponse")
    public List<Alert> getUserAlerts(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getVisitNotes", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetVisitNotes")
    @ResponseWrapper(localName = "getVisitNotesResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetVisitNotesResponse")
    public String getVisitNotes(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param feedback
     * @param siteCode
     * @return
     *     returns boolean
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "sendFeedBack", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SendFeedBack")
    @ResponseWrapper(localName = "sendFeedBackResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SendFeedBackResponse")
    public boolean sendFeedBack(
        @WebParam(name = "siteCode", targetNamespace = "")
        String siteCode,
        @WebParam(name = "feedback", targetNamespace = "")
        FeedBack feedback)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInptMedicationDetail", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetInptMedicationDetail")
    @ResponseWrapper(localName = "getInptMedicationDetailResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetInptMedicationDetailResponse")
    public String getInptMedicationDetail(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.LabResult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getLabOrderResult", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetLabOrderResult")
    @ResponseWrapper(localName = "getLabOrderResultResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetLabOrderResultResponse")
    public List<LabResult> getLabOrderResult(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.LabOrder>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientLabs", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientLabs")
    @ResponseWrapper(localName = "getPatientLabsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientLabsResponse")
    public List<LabOrder> getPatientLabs(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.LabResult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientLabTestResults", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientLabTestResults")
    @ResponseWrapper(localName = "getPatientLabTestResultsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientLabTestResultsResponse")
    public List<LabResult> getPatientLabTestResults(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getOrderDetail", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetOrderDetail")
    @ResponseWrapper(localName = "getOrderDetailResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetOrderDetailResponse")
    public String getOrderDetail(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getPatientCodeGreen", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientCodeGreen")
    @ResponseWrapper(localName = "getPatientCodeGreenResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetPatientCodeGreenResponse")
    public String getPatientCodeGreen(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientAppointments>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderAppointments", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderAppointments")
    @ResponseWrapper(localName = "getProviderAppointmentsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderAppointmentsResponse")
    public List<PatientAppointments> getProviderAppointments(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientAdmission>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getWardAdmissions", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetWardAdmissions")
    @ResponseWrapper(localName = "getWardAdmissionsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetWardAdmissionsResponse")
    public List<PatientAdmission> getWardAdmissions(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.PatientAdmission>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderAdmissions", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderAdmissions")
    @ResponseWrapper(localName = "getProviderAdmissionsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderAdmissionsResponse")
    public List<PatientAdmission> getProviderAdmissions(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Consult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderConsultsRequested", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderConsultsRequested")
    @ResponseWrapper(localName = "getProviderConsultsRequestedResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderConsultsRequestedResponse")
    public List<Consult> getProviderConsultsRequested(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Consult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderConsultsReceived", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderConsultsReceived")
    @ResponseWrapper(localName = "getProviderConsultsReceivedResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderConsultsReceivedResponse")
    public List<Consult> getProviderConsultsReceived(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.ProgressNote>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderUnsignedNotes", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderUnsignedNotes")
    @ResponseWrapper(localName = "getProviderUnsignedNotesResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderUnsignedNotesResponse")
    public List<ProgressNote> getProviderUnsignedNotes(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Order>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderOrdersPending", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderOrdersPending")
    @ResponseWrapper(localName = "getProviderOrdersPendingResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderOrdersPendingResponse")
    public List<Order> getProviderOrdersPending(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.Order>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderOrdersResulted", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderOrdersResulted")
    @ResponseWrapper(localName = "getProviderOrdersResultedResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderOrdersResultedResponse")
    public List<Order> getProviderOrdersResulted(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.LabResult>
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderLabAbnormalResults", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderLabAbnormalResults")
    @ResponseWrapper(localName = "getProviderLabAbnormalResultsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderLabAbnormalResultsResponse")
    public List<LabResult> getProviderLabAbnormalResults(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param progressNote
     * @param queryBean
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "createNewSignedNote", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.CreateNewSignedNote")
    @ResponseWrapper(localName = "createNewSignedNoteResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.CreateNewSignedNoteResponse")
    public void createNewSignedNote(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean,
        @WebParam(name = "progressNote", targetNamespace = "")
        ProgressNote progressNote)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCISNote", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetCISNote")
    @ResponseWrapper(localName = "getCISNoteResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetCISNoteResponse")
    public String getCISNote(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param startDate
     * @param category
     * @param patId
     * @param userNPI
     * @param userId
     * @param userName
     * @param endDate
     * @param requestingApp
     * @param siteCode
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "logAudit", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.LogAudit")
    @ResponseWrapper(localName = "logAuditResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.LogAuditResponse")
    public void logAudit(
        @WebParam(name = "siteCode", targetNamespace = "")
        String siteCode,
        @WebParam(name = "userId", targetNamespace = "")
        String userId,
        @WebParam(name = "userNPI", targetNamespace = "")
        String userNPI,
        @WebParam(name = "userName", targetNamespace = "")
        String userName,
        @WebParam(name = "patId", targetNamespace = "")
        String patId,
        @WebParam(name = "category", targetNamespace = "")
        String category,
        @WebParam(name = "requestingApp", targetNamespace = "")
        String requestingApp,
        @WebParam(name = "startDate", targetNamespace = "")
        String startDate,
        @WebParam(name = "endDate", targetNamespace = "")
        String endDate)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @return
     *     returns java.lang.String
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getProviderCfg", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderCfg")
    @ResponseWrapper(localName = "getProviderCfgResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.GetProviderCfgResponse")
    public String getProviderCfg(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param queryBean
     * @param cfg
     * @return
     *     returns boolean
     * @throws JMeadowsException_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "setProviderCfg", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SetProviderCfg")
    @ResponseWrapper(localName = "setProviderCfgResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.SetProviderCfgResponse")
    public boolean setProviderCfg(
        @WebParam(name = "queryBean", targetNamespace = "")
        QueryBean queryBean,
        @WebParam(name = "cfg", targetNamespace = "")
        String cfg)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param provider
     * @return
     *     returns java.util.List<gov.va.med.jmeadows.webservice.JalfhccAlert>
     * @throws JMeadowsException_Exception
     */
    @WebMethod(operationName = "JALFHCC_retrieveProviderAlerts")
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "JALFHCC_retrieveProviderAlerts", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.JALFHCCRetrieveProviderAlerts")
    @ResponseWrapper(localName = "JALFHCC_retrieveProviderAlertsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.JALFHCCRetrieveProviderAlertsResponse")
    public List<JalfhccAlert> jalfhccRetrieveProviderAlerts(
        @WebParam(name = "provider", targetNamespace = "")
        Provider provider)
        throws JMeadowsException_Exception
    ;

    /**
     * 
     * @param requestingApp
     * @param provider
     * @param orderNumbers
     * @return
     *     returns boolean
     * @throws JMeadowsException_Exception
     */
    @WebMethod(operationName = "JALFHCC_acknowledgeProviderAlerts")
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "JALFHCC_acknowledgeProviderAlerts", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.JALFHCCAcknowledgeProviderAlerts")
    @ResponseWrapper(localName = "JALFHCC_acknowledgeProviderAlertsResponse", targetNamespace = "http://webservice.jmeadows.med.va.gov/", className = "gov.va.med.jmeadows.webservice.JALFHCCAcknowledgeProviderAlertsResponse")
    public boolean jalfhccAcknowledgeProviderAlerts(
        @WebParam(name = "provider", targetNamespace = "")
        Provider provider,
        @WebParam(name = "orderNumbers", targetNamespace = "")
        List<String> orderNumbers,
        @WebParam(name = "requestingApp", targetNamespace = "")
        String requestingApp)
        throws JMeadowsException_Exception
    ;

}
