/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.jmeadows;

import gov.va.med.jmeadows.webservice.*;
import groovy.util.ConfigObject;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.BindingProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class JMeadowsServiceHandler {

    private final String CONNECT_TIMEOUT_PROPERTIES_PACKAGE =
            (String)((ConfigObject) ConfigurationHolder.getConfig()).getProperty("connectTimeoutPropertiesPackage");
    private final String REQUEST_TIMEOUT_PROPERTIES_PACKAGE =
            (String)((ConfigObject) ConfigurationHolder.getConfig()).getProperty("requestTimeoutPropertiesPackage");

    private final int CONNECTION_TIMEOUT_MS = Integer.parseInt((String)((ConfigObject) ConfigurationHolder.getConfig()).
                                    getProperty("connectionTimeoutMS"));
    private final int REQUEST_TIMEOUT_MS = Integer.parseInt((String)((ConfigObject) ConfigurationHolder.getConfig()).
                                    getProperty("requestTimeoutMS"));

    private String m_url;
    private String m_ServiceName;
    private String m_namespace;
    private QName m_QserviceName;

    private JMeadowsDataService m_jmeadowsDataService;

    public JMeadowsServiceHandler(String url)
    {
        m_url = url;
        m_ServiceName = "JMeadowsDataService";
        m_namespace = "http://webservice.jmeadows.med.va.gov/";
        m_QserviceName = new QName(m_namespace, m_ServiceName);
    }

    private JMeadowsData getJMeadowsDataPort()
    {
        if (m_jmeadowsDataService == null)
        {
            createService();
        }

        JMeadowsData port = m_jmeadowsDataService.getJMeadowsDataPort();

        //set connection timeout
        Map<String, Object> ctxt = ((BindingProvider)port).getRequestContext();
        ctxt.put(CONNECT_TIMEOUT_PROPERTIES_PACKAGE, CONNECTION_TIMEOUT_MS);
        ctxt.put(REQUEST_TIMEOUT_PROPERTIES_PACKAGE, REQUEST_TIMEOUT_MS);

        return port;
    }

    private synchronized void createService()
    {
        if (m_jmeadowsDataService == null)
        {
            try
            {
                m_jmeadowsDataService = new JMeadowsDataService(new URL(m_url), m_QserviceName);
            }
            catch(Exception e)
            {
                throw new RuntimeException(e);
            }

        }
    }

    public Provider login(String siteCode, String accessCode, String verifyCode) throws SOAPException
    {
            Provider result = null;

            try {

                    JMeadowsData port = getJMeadowsDataPort();
                    String requestingApp = (String) ((ConfigObject) ConfigurationHolder.getConfig()).getProperty("appName");
                    result = port.login(siteCode,accessCode, verifyCode, requestingApp);

            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

            return result;
    }

    public AdmissionDetail getAdmissionDetails(QueryBean queryBean) throws SOAPException
      {
            AdmissionDetail returnVal = null;

            try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getAdmissionDetails(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }



            return returnVal;
      }

    public Diagnosis[] getAdmissionDiagnosis(QueryBean queryBean) throws SOAPException
      {
        Diagnosis[] returnVal = null;

        try {

            JMeadowsData port = getJMeadowsDataPort();
            returnVal = port.getAdmissionDiagnosis(queryBean).toArray(new Diagnosis[0]);
    }
    catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }


    public Procedure[] getAdmissionProcedures(QueryBean queryBean) throws SOAPException
      {
        Procedure[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getAdmissionProcedures(queryBean).toArray(new Procedure[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

     public String getClinicalReminderDetail(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getClinicalReminderDetail(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }

     public String[] getConsultReport(QueryBean queryBean) throws SOAPException
      {
        String[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getConsultReport(queryBean).toArray(new String[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

     public FeedBack[] getFeedBackItems(QueryBean queryBean) throws SOAPException
      {
        FeedBack[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getFeedBackItems(queryBean).toArray(new FeedBack[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
      }

      public String getInptMedicationDetail(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getInptMedicationDetail(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public LabResult[] getLabOrderResult(QueryBean queryBean) throws SOAPException
      {
              LabResult[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getLabOrderResult(queryBean).toArray(new LabResult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public String getOrderDetail(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getOrderDetail(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public PatientAdmission[] getPatientAdmissions(QueryBean queryBean) throws SOAPException
      {
              PatientAdmission[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientAdmissions(queryBean).toArray(new PatientAdmission[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }
    public Allergy[] getPatientAllergies(QueryBean queryBean) throws SOAPException
    {
            Allergy[] returnVal = null;

            try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientAllergies(queryBean).toArray(new Allergy[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

            return returnVal;
    }
      public PatientAppointments[] getPatientAppointments(QueryBean queryBean) throws SOAPException
      {
              PatientAppointments[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientAppointments(queryBean).toArray(new PatientAppointments[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public ClinicalReminder[] getPatientClinicalReminders(QueryBean queryBean) throws SOAPException
      {
              ClinicalReminder[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientClinicalReminders(queryBean).toArray(new ClinicalReminder[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public String getPatientCodeGreen(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientCodeGreen(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Consult[] getPatientConsultRequests(QueryBean queryBean) throws SOAPException
      {
              Consult[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientConsultRequests(queryBean).toArray(new Consult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Vitals[] getPatientCurrentVitals(QueryBean queryBean) throws SOAPException
      {
              Vitals[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientCurrentVitals(queryBean).toArray(new Vitals[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }

      public List<PatientDemographicsDetail> getAllPatientDemographicDetails(QueryBean queryBean) throws SOAPException
      {
        List<PatientDemographicsDetail> returnVal = null;
        try
        {

            JMeadowsData port = getJMeadowsDataPort();
            returnVal = port.getPatientDemographicsDetail(queryBean);
        }
        catch (Exception e)
        {
                throw new SOAPException(e);
        }
        return returnVal;
      }

      public List<PatientDemographics> getPatientDemographics(QueryBean queryBean) throws SOAPException
      {
              List<PatientDemographics> returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientDemographics(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
       return returnVal;
      }

      public ProgressNote[] getPatientDischargeSummaries(QueryBean queryBean) throws SOAPException
      {
              ProgressNote[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientDischargeSummaries(queryBean).toArray(new ProgressNote[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Immunization[] getPatientImmunizations(QueryBean queryBean) throws SOAPException
      {
              Immunization[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientImmunizations(queryBean).toArray(new Immunization[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
      }

      public LabOrder[] getPatientLabs(QueryBean queryBean) throws SOAPException
      {
              LabOrder[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientLabs(queryBean).toArray(new LabOrder[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public LabResult[] getPatientLabTestResults(QueryBean queryBean) throws SOAPException
      {
        LabResult[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientLabTestResults(queryBean).toArray(new LabResult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Medication[] getPatientMedications(QueryBean queryBean) throws SOAPException
      {
              Medication[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientMedications(queryBean).toArray(new Medication[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Medication[] getPatientMedicationsNVA(QueryBean queryBean) throws SOAPException
      {
              Medication[] returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientMedicationsNVA(queryBean).toArray(new Medication[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;

      }
      public Order[] getPatientOrders(QueryBean queryBean) throws SOAPException
      {
        Order[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientOrders(queryBean).toArray(new Order[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Problem[] getPatientProblemList(QueryBean queryBean) throws SOAPException
      {
              Problem[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientProblemList(queryBean).toArray(new Problem[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

//      public Procedure[] getPatientProcedures(QueryBean queryBean) throws SOAPException
//      {
//              Procedure[] returnVal = null;
//
//        try {
//
//                    JMeadowsData port = getJMeadowsDataPort();
//                    returnVal = port.getPatientProcedures(queryBean).toArray(new Procedure[0]);
//            }
//            catch (Exception e)
//            {
//                    throw new SOAPException(e);
//            }
//
//        return returnVal;
//
//      }

      public ProgressNote[] getPatientProgressNotes(QueryBean queryBean) throws SOAPException
      {
              ProgressNote[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientProgressNotes(queryBean).toArray(new ProgressNote[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public RadiologyExam[] getPatientRads(QueryBean queryBean) throws SOAPException
      {
              RadiologyExam[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientRads(queryBean).toArray(new RadiologyExam[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

//      public Object[] getPatientSummaryData(QueryBean queryBean) throws SOAPException
//      {
//              Object[] returnVal = null;
//
//              try {
//
//                            JMeadowsData port = getJMeadowsDataPort();
//                            returnVal = port.getPatientSummaryData(queryBean).toArray(new Object[0]);
//                    }
//                    catch (Exception e)
//                    {
//                            throw new SOAPException(e);
//                    }
//
//              return returnVal;
//      }

      public Vitals[] getPatientVitals(QueryBean queryBean) throws SOAPException
      {
              Vitals[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPatientVitals(queryBean).toArray(new Vitals[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Prescription getPrescriptionFills(QueryBean queryBean) throws SOAPException
      {
        Prescription returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getPrescriptionFills(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }

      public ProblemDetail getProblemDetail(QueryBean queryBean) throws SOAPException
      {
              ProblemDetail returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProblemDetail(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public String getProgressNote(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProgressNote(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public String getCISNote(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getCISNote(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

      public Provider getProviderProfile(QueryBean queryBean) throws SOAPException
      {
        Provider returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderProfile(queryBean);

            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
      }

      public RadiologyReport getRadiologyReport(QueryBean queryBean) throws SOAPException
      {
              RadiologyReport returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getRadiologyReport(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }

      public Alert[] getUserAlerts(QueryBean queryBean) throws SOAPException
      {
              Alert[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getUserAlerts(queryBean).toArray(new Alert[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;

      }

      public String getVisitNotes(QueryBean queryBean) throws SOAPException
      {
        String returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getVisitNotes(queryBean);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
      }

      public Patient[] lookupPatient(QueryBean queryBean) throws SOAPException
      {
              Patient[] returnVal = null;

        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.lookupPatient(queryBean).toArray(new Patient[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;

      }

      public Patient selectPatient(QueryBean queryBean) throws SOAPException
      {
        Patient returnVal = null;

        try {

            JMeadowsData port = getJMeadowsDataPort();
            returnVal = port.selectPatient(queryBean);
        }
        catch (Exception e)
        {
        throw new SOAPException(e);
        }

        return returnVal;

      }

      public void logAudit(String siteId, String userId, String userNPI,
              String userName, String patId, String category,
              String startDate, String endDate) throws SOAPException
      {
        try {
                JMeadowsData port = getJMeadowsDataPort();
                String requestingApp = (String) ((ConfigObject) ConfigurationHolder.getConfig()).getProperty("appName");
                port.logAudit(siteId, userId, userNPI, userName, patId, category, requestingApp, startDate, endDate);
        }
        catch (Exception e)
        {
                throw new SOAPException(e);
        }

      }

      public Boolean sendFeedBack(String siteCode, FeedBack feedback) throws SOAPException
      {
        Boolean returnVal = null;
        try {

                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.sendFeedBack(siteCode, feedback);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }

        return returnVal;
      }

    public PatientAdmission[] getProviderAdmissions(QueryBean queryBean) throws SOAPException
    {
              PatientAdmission[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderAdmissions(queryBean).toArray(new PatientAdmission[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public PatientAppointments[] getProviderAppointments(QueryBean queryBean) throws SOAPException
    {
              PatientAppointments[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderAppointments(queryBean).toArray(new PatientAppointments[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public Consult[] getProviderConsultsReceived(QueryBean queryBean) throws SOAPException
    {
              Consult[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderConsultsReceived(queryBean).toArray(new Consult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public Consult[] getProviderConsultsRequested(QueryBean queryBean) throws SOAPException
    {
              Consult[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderConsultsRequested(queryBean).toArray(new Consult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public LabResult[] getProviderLabAbnormalResults(QueryBean queryBean) throws SOAPException
    {
              LabResult[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderLabAbnormalResults(queryBean).toArray(new LabResult[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public Order[] getProviderOrdersPending(QueryBean queryBean) throws SOAPException
    {
              Order[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderOrdersPending(queryBean).toArray(new Order[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public Order[] getProviderOrdersResulted(QueryBean queryBean) throws SOAPException
    {
              Order[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderOrdersResulted(queryBean).toArray(new Order[0]);
            }
            catch (Exception e)
            {
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public ProgressNote[] getProviderUnsignedNotes(QueryBean queryBean) throws SOAPException
    {
              ProgressNote[] returnVal = null;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    returnVal = port.getProviderUnsignedNotes(queryBean).toArray(new ProgressNote[0]);
            }
            catch (Exception e)
            {
                    e.printStackTrace(System.out);
                    throw new SOAPException(e);
            }
        return returnVal;
    }

    public String createNewSignedNote(QueryBean queryBean, ProgressNote progressNote) throws SOAPException
    {
        String returnVal = "Success";
        try {
            JMeadowsData port = getJMeadowsDataPort();
            port.createNewSignedNote(queryBean, progressNote);
        } catch (Exception e) {
            e.printStackTrace(System.out);
            throw new SOAPException(e);
        }

        return returnVal;
    }

    public boolean setProviderCfg(QueryBean queryBean, String cfg) throws SOAPException
    {
        boolean bRet = false;
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    bRet = port.setProviderCfg(queryBean, cfg);
            }
            catch (Exception e)
            {
                    e.printStackTrace(System.out);
                    throw new SOAPException(e);
            }
        return bRet;
    }

    public String getProviderCfg(QueryBean queryBean) throws SOAPException
    {
        String retVal = "";
        try {
                    JMeadowsData port = getJMeadowsDataPort();
                    retVal = port.getProviderCfg(queryBean);
            }
            catch (Exception e)
            {
                    e.printStackTrace(System.out);
                    throw new SOAPException(e);
            }
        return retVal;
    }

}
