/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.guibeans;

import java.util.List;

public class GUIVitalsGraphResults
{
    private List<GUIVitalsGraphEntry> vitalEntries;
    private int count;

    private double totalRate;
    private double avgRate;
    private double minRate;
    private double maxRate;
    private String minRateDate;
    private String maxRateDate;

    private boolean exceptionFlag;
    private boolean bloodPressureVital;

    //only pertains to blood pressure
    private double totalSystolic;
    private double avgSystolic;
    private double minSystolic;
    private double maxSystolic;
    private String minSystolicDate;
    private String maxSystolicDate;

    private double totalDiastolic;
    private double avgDiastolic;
    private double minDiastolic;
    private double maxDiastolic;
    private String minDiastolicDate;
    private String maxDiastolicDate;

    public List<GUIVitalsGraphEntry> getVitalEntries() {
        return vitalEntries;
    }

    public void setVitalEntries(List<GUIVitalsGraphEntry> vitalEntries) {
        this.vitalEntries = vitalEntries;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public double getTotalRate() {
        return totalRate;
    }

    public void setTotalRate(double totalRate) {
        this.totalRate = totalRate;
    }

    public double getAvgRate() {
        return avgRate;
    }

    public void setAvgRate(double avgRate) {
        this.avgRate = avgRate;
    }

    public double getMinRate() {
        return minRate;
    }

    public void setMinRate(double minRate) {
        this.minRate = minRate;
    }

    public double getMaxRate() {
        return maxRate;
    }

    public void setMaxRate(double maxRate) {
        this.maxRate = maxRate;
    }

    public String getMinRateDate() {
        return minRateDate;
    }

    public void setMinRateDate(String minRateDate) {
        this.minRateDate = minRateDate;
    }

    public String getMaxRateDate() {
        return maxRateDate;
    }

    public void setMaxRateDate(String maxRateDate) {
        this.maxRateDate = maxRateDate;
    }

    public boolean isExceptionFlag() {
        return exceptionFlag;
    }

    public void setExceptionFlag(boolean exceptionFlag) {
        this.exceptionFlag = exceptionFlag;
    }

    public boolean isBloodPressureVital() {
        return bloodPressureVital;
    }

    public void setBloodPressureVital(boolean bloodPressureVital) {
        this.bloodPressureVital = bloodPressureVital;
    }

    public double getTotalSystolic() {
        return totalSystolic;
    }

    public void setTotalSystolic(double totalSystolic) {
        this.totalSystolic = totalSystolic;
    }

    public double getAvgSystolic() {
        return avgSystolic;
    }

    public void setAvgSystolic(double avgSystolic) {
        this.avgSystolic = avgSystolic;
    }

    public double getMinSystolic() {
        return minSystolic;
    }

    public void setMinSystolic(double minSystolic) {
        this.minSystolic = minSystolic;
    }

    public double getMaxSystolic() {
        return maxSystolic;
    }

    public void setMaxSystolic(double maxSystolic) {
        this.maxSystolic = maxSystolic;
    }

    public String getMinSystolicDate() {
        return minSystolicDate;
    }

    public void setMinSystolicDate(String minSystolicDate) {
        this.minSystolicDate = minSystolicDate;
    }

    public String getMaxSystolicDate() {
        return maxSystolicDate;
    }

    public void setMaxSystolicDate(String maxSystolicDate) {
        this.maxSystolicDate = maxSystolicDate;
    }

    public double getTotalDiastolic() {
        return totalDiastolic;
    }

    public void setTotalDiastolic(double totalDiastolic) {
        this.totalDiastolic = totalDiastolic;
    }

    public double getAvgDiastolic() {
        return avgDiastolic;
    }

    public void setAvgDiastolic(double avgDiastolic) {
        this.avgDiastolic = avgDiastolic;
    }

    public double getMinDiastolic() {
        return minDiastolic;
    }

    public void setMinDiastolic(double minDiastolic) {
        this.minDiastolic = minDiastolic;
    }

    public double getMaxDiastolic() {
        return maxDiastolic;
    }

    public void setMaxDiastolic(double maxDiastolic) {
        this.maxDiastolic = maxDiastolic;
    }

    public String getMinDiastolicDate() {
        return minDiastolicDate;
    }

    public void setMinDiastolicDate(String minDiastolicDate) {
        this.minDiastolicDate = minDiastolicDate;
    }

    public String getMaxDiastolicDate() {
        return maxDiastolicDate;
    }

    public void setMaxDiastolicDate(String maxDiastolicDate) {
        this.maxDiastolicDate = maxDiastolicDate;
    }
}
