/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.guibeans;

public class GUIVitalsGraphEntry
{
    private String dateTimeTaken;
    private String type;
    private boolean isBloodPressureVital;
    private String rate;
    private String systolicRate;
    private String diastolicRate;
    private String siteCode;
    private String siteMoniker;
    private String siteName;
    private String siteAgency;
    private String sourcePlatform;
    private String units;
    private String qualifiers;

    public String getDateTimeTaken() {
        return dateTimeTaken;
    }

    public void setDateTimeTaken(String dateTimeTaken) {
        this.dateTimeTaken = dateTimeTaken;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isBloodPressureVital() {
        return isBloodPressureVital;
    }

    public void setBloodPressureVital(boolean bloodPressureVital) {
        isBloodPressureVital = bloodPressureVital;
    }

    public String getRate() {
        return rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public String getSystolicRate() {
        return systolicRate;
    }

    public void setSystolicRate(String systolicRate) {
        this.systolicRate = systolicRate;
    }

    public String getDiastolicRate() {
        return diastolicRate;
    }

    public void setDiastolicRate(String diastolicRate) {
        this.diastolicRate = diastolicRate;
    }

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getSiteMoniker() {
        return siteMoniker;
    }

    public void setSiteMoniker(String siteMoniker) {
        this.siteMoniker = siteMoniker;
    }

    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getSiteAgency() {
        return siteAgency;
    }

    public void setSiteAgency(String siteAgency) {
        this.siteAgency = siteAgency;
    }

    public String getSourcePlatform() {
        return sourcePlatform;
    }

    public void setSourcePlatform(String sourcePlatform) {
        this.sourcePlatform = sourcePlatform;
    }

    public String getUnits() {
        return units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getQualifiers() {
        return qualifiers;
    }

    public void setQualifiers(String qualifiers) {
        this.qualifiers = qualifiers;
    }
}
