/*
 * Janus 4.0 (c)
 * Copyright (c) 2011 Hawaii Resource Group LLC. All Rights Reserved.
 * Developed for the Pacific Telehealth & Technology Hui and the Pacific Joint Information Technology Center
 * Contributors:
 *             Honorable Senator Daniel K. Inouye
 *             VA Pacific Islands Health Care System
 *             Tripler Army Medical Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.
 *
 * You may obtain a copy of the License at:
 *
 *            http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package gov.va.med.guibeans;

import java.io.Serializable;
import java.util.ArrayList;

public class GUIProvider implements Serializable
{
    public static final long serialVersionUID = 100;

    private String cfg;
    private String dob;
    private boolean dodProvider;
    private String dutyPhone;
    private String email;
    private String encryptedAvCode;
    private String gender;
    private ArrayList<GUIKeyValuePair> locationIdMappings;
    private String loginSiteCode;
    private String loginSiteName;
    private String npi;
    private String name;
    private String pager;
    private String permissionString;
    private GUIKeyValuePair primaryPermission;
    private String providerClass;
    private String providerFlag;
    private String ssn;
    private ArrayList<GUIUserSecurityKey> securityKeys;
    private String sigClass;
    private String sigText;
    private ArrayList<GUIKeyValuePair> sitePermissions;
    private String userId;

    public String getCfg() {
        return cfg;
    }

    public void setCfg(String cfg) {
        this.cfg = cfg;
    }

    public String getDob() {
        return dob;
    }

    public void setDob(String dob) {
        this.dob = dob;
    }

    public boolean isDodProvider() {
        return dodProvider;
    }

    public void setDodProvider(boolean dodProvider) {
        this.dodProvider = dodProvider;
    }

    public String getDutyPhone() {
        return dutyPhone;
    }

    public void setDutyPhone(String dutyPhone) {
        this.dutyPhone = dutyPhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEncryptedAvCode() {
        return encryptedAvCode;
    }

    public void setEncryptedAvCode(String encryptedAvCode) {
        this.encryptedAvCode = encryptedAvCode;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public ArrayList<GUIKeyValuePair> getLocationIdMappings() {
        return locationIdMappings;
    }

    public void setLocationIdMappings(ArrayList<GUIKeyValuePair> locationIdMappings) {
        this.locationIdMappings = locationIdMappings;
    }

    public String getLoginSiteCode() {
        return loginSiteCode;
    }

    public void setLoginSiteCode(String loginSiteCode) {
        this.loginSiteCode = loginSiteCode;
    }

    public String getLoginSiteName() {
        return loginSiteName;
    }

    public void setLoginSiteName(String loginSiteName) {
        this.loginSiteName = loginSiteName;
    }

    public String getNpi() {
        return npi;
    }

    public void setNpi(String npi) {
        this.npi = npi;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPager() {
        return pager;
    }

    public void setPager(String pager) {
        this.pager = pager;
    }

    public String getPermissionString() {
        return permissionString;
    }

    public void setPermissionString(String permissionString) {
        this.permissionString = permissionString;
    }

    public GUIKeyValuePair getPrimaryPermission() {
        return primaryPermission;
    }

    public void setPrimaryPermission(GUIKeyValuePair primaryPermission) {
        this.primaryPermission = primaryPermission;
    }

    public String getProviderClass() {
        return providerClass;
    }

    public void setProviderClass(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getProviderFlag() {
        return providerFlag;
    }

    public void setProviderFlag(String providerFlag) {
        this.providerFlag = providerFlag;
    }

    public String getSsn() {
        return ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public ArrayList<GUIUserSecurityKey> getSecurityKeys() {
        return securityKeys;
    }

    public void setSecurityKeys(ArrayList<GUIUserSecurityKey> securityKeys) {
        this.securityKeys = securityKeys;
    }

    public String getSigClass() {
        return sigClass;
    }

    public void setSigClass(String sigClass) {
        this.sigClass = sigClass;
    }

    public String getSigText() {
        return sigText;
    }

    public void setSigText(String sigText) {
        this.sigText = sigText;
    }

    public ArrayList<GUIKeyValuePair> getSitePermissions() {
        return sitePermissions;
    }

    public void setSitePermissions(ArrayList<GUIKeyValuePair> sitePermissions) {
        this.sitePermissions = sitePermissions;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
